/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.init.headtype;

import fuzs.alltheheads.init.HeadTypes;
import fuzs.alltheheads.world.item.component.headtype.Color;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.SheepPredicate;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;

public class SheepHeadType {
    public static final ResourceKey<HeadType> WHITE_SHEEP = HeadTypes.register("sheep/white");
    public static final ResourceKey<HeadType> WHITE_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/white");
    public static final ResourceKey<HeadType> ORANGE_SHEEP = HeadTypes.register("sheep/orange");
    public static final ResourceKey<HeadType> ORANGE_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/orange");
    public static final ResourceKey<HeadType> MAGENTA_SHEEP = HeadTypes.register("sheep/magenta");
    public static final ResourceKey<HeadType> MAGENTA_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/magenta");
    public static final ResourceKey<HeadType> LIGHT_BLUE_SHEEP = HeadTypes.register("sheep/light_blue");
    public static final ResourceKey<HeadType> LIGHT_BLUE_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/light_blue");
    public static final ResourceKey<HeadType> YELLOW_SHEEP = HeadTypes.register("sheep/yellow");
    public static final ResourceKey<HeadType> YELLOW_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/yellow");
    public static final ResourceKey<HeadType> LIME_SHEEP = HeadTypes.register("sheep/lime");
    public static final ResourceKey<HeadType> LIME_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/lime");
    public static final ResourceKey<HeadType> PINK_SHEEP = HeadTypes.register("sheep/pink");
    public static final ResourceKey<HeadType> PINK_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/pink");
    public static final ResourceKey<HeadType> GRAY_SHEEP = HeadTypes.register("sheep/gray");
    public static final ResourceKey<HeadType> GRAY_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/gray");
    public static final ResourceKey<HeadType> LIGHT_GRAY_SHEEP = HeadTypes.register("sheep/light_gray");
    public static final ResourceKey<HeadType> LIGHT_GRAY_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/light_gray");
    public static final ResourceKey<HeadType> CYAN_SHEEP = HeadTypes.register("sheep/cyan");
    public static final ResourceKey<HeadType> CYAN_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/cyan");
    public static final ResourceKey<HeadType> PURPLE_SHEEP = HeadTypes.register("sheep/purple");
    public static final ResourceKey<HeadType> PURPLE_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/purple");
    public static final ResourceKey<HeadType> BLUE_SHEEP = HeadTypes.register("sheep/blue");
    public static final ResourceKey<HeadType> BLUE_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/blue");
    public static final ResourceKey<HeadType> BROWN_SHEEP = HeadTypes.register("sheep/brown");
    public static final ResourceKey<HeadType> BROWN_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/brown");
    public static final ResourceKey<HeadType> GREEN_SHEEP = HeadTypes.register("sheep/green");
    public static final ResourceKey<HeadType> GREEN_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/green");
    public static final ResourceKey<HeadType> RED_SHEEP = HeadTypes.register("sheep/red");
    public static final ResourceKey<HeadType> RED_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/red");
    public static final ResourceKey<HeadType> BLACK_SHEEP = HeadTypes.register("sheep/black");
    public static final ResourceKey<HeadType> BLACK_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/black");
    public static final ResourceKey<HeadType> RAINBOW_SHEEP = HeadTypes.register("sheep/rainbow");
    public static final ResourceKey<HeadType> RAINBOW_WOOLLY_SHEEP = HeadTypes.register("sheep/woolly/rainbow");

    public static void bootstrap(BootstrapContext<HeadType> context) {
        SheepHeadType.bootstrapSheep(context, DyeColor.WHITE, WHITE_SHEEP, WHITE_WOOLLY_SHEEP);
        SheepHeadType.bootstrapSheep(context, DyeColor.ORANGE, ORANGE_SHEEP, ORANGE_WOOLLY_SHEEP);
        SheepHeadType.bootstrapSheep(context, DyeColor.MAGENTA, MAGENTA_SHEEP, MAGENTA_WOOLLY_SHEEP);
        SheepHeadType.bootstrapSheep(context, DyeColor.LIGHT_BLUE, LIGHT_BLUE_SHEEP, LIGHT_BLUE_WOOLLY_SHEEP);
        SheepHeadType.bootstrapSheep(context, DyeColor.YELLOW, YELLOW_SHEEP, YELLOW_WOOLLY_SHEEP);
        SheepHeadType.bootstrapSheep(context, DyeColor.LIME, LIME_SHEEP, LIME_WOOLLY_SHEEP);
        SheepHeadType.bootstrapSheep(context, DyeColor.PINK, PINK_SHEEP, PINK_WOOLLY_SHEEP);
        SheepHeadType.bootstrapSheep(context, DyeColor.GRAY, GRAY_SHEEP, GRAY_WOOLLY_SHEEP);
        SheepHeadType.bootstrapSheep(context, DyeColor.LIGHT_GRAY, LIGHT_GRAY_SHEEP, LIGHT_GRAY_WOOLLY_SHEEP);
        SheepHeadType.bootstrapSheep(context, DyeColor.CYAN, CYAN_SHEEP, CYAN_WOOLLY_SHEEP);
        SheepHeadType.bootstrapSheep(context, DyeColor.PURPLE, PURPLE_SHEEP, PURPLE_WOOLLY_SHEEP);
        SheepHeadType.bootstrapSheep(context, DyeColor.BLUE, BLUE_SHEEP, BLUE_WOOLLY_SHEEP);
        SheepHeadType.bootstrapSheep(context, DyeColor.BROWN, BROWN_SHEEP, BROWN_WOOLLY_SHEEP);
        SheepHeadType.bootstrapSheep(context, DyeColor.GREEN, GREEN_SHEEP, GREEN_WOOLLY_SHEEP);
        SheepHeadType.bootstrapSheep(context, DyeColor.RED, RED_SHEEP, RED_WOOLLY_SHEEP);
        SheepHeadType.bootstrapSheep(context, DyeColor.BLACK, BLACK_SHEEP, BLACK_WOOLLY_SHEEP);
        HeadType.builder(EntityType.SHEEP).entityPredicate(builder -> builder.components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect((DataComponentType)DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"jeb_"))).build()).subPredicate((EntitySubPredicate)new SheepPredicate(Optional.of(true)))).shape(6.0, 6.0, 8.0).model(ModelType.SHEEP, ResourceLocationHelper.withDefaultNamespace((String)"entity/sheep/sheep")).dyedModel(ModelType.SHEEP, ResourceLocationHelper.withDefaultNamespace((String)"entity/sheep/sheep_wool_undercoat"), new Color.Rainbow()).noteBlockSound(SoundEvents.SHEEP_AMBIENT).build(context, RAINBOW_SHEEP);
        HeadType.builder(EntityType.SHEEP).entityPredicate(builder -> builder.components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect((DataComponentType)DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"jeb_"))).build()).subPredicate((EntitySubPredicate)SheepPredicate.hasWool())).shape(6.0, 6.0, 8.0).model(ModelType.SHEEP, ResourceLocationHelper.withDefaultNamespace((String)"entity/sheep/sheep")).dyedModel(ModelType.SHEEP, ResourceLocationHelper.withDefaultNamespace((String)"entity/sheep/sheep_wool_undercoat"), new Color.Rainbow()).dyedModel(ModelType.SHEEP_WOOL, ResourceLocationHelper.withDefaultNamespace((String)"entity/sheep/sheep_wool"), new Color.Rainbow()).noteBlockSound(SoundEvents.SHEEP_AMBIENT).build(context, RAINBOW_WOOLLY_SHEEP);
    }

    private static void bootstrapSheep(BootstrapContext<HeadType> context, DyeColor dyeColor, ResourceKey<HeadType> sheep, ResourceKey<HeadType> woollySheep) {
        SheepHeadType.bootstrapSheep(context, dyeColor, sheep);
        SheepHeadType.bootstrapWoollySheep(context, dyeColor, woollySheep);
    }

    private static void bootstrapSheep(BootstrapContext<HeadType> context, DyeColor dyeColor, ResourceKey<HeadType> resourceKey) {
        HeadType.builder(EntityType.SHEEP).entityPredicate(builder -> builder.components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect((DataComponentType)DataComponents.SHEEP_COLOR, (Object)dyeColor)).build()).subPredicate((EntitySubPredicate)new SheepPredicate(Optional.of(true)))).shape(6.0, 6.0, 8.0).model(ModelType.SHEEP, ResourceLocationHelper.withDefaultNamespace((String)"entity/sheep/sheep")).dyedModel(ModelType.SHEEP, ResourceLocationHelper.withDefaultNamespace((String)"entity/sheep/sheep_wool_undercoat"), new Color.Sheep(dyeColor)).noteBlockSound(SoundEvents.SHEEP_AMBIENT).build(context, resourceKey);
    }

    private static void bootstrapWoollySheep(BootstrapContext<HeadType> context, DyeColor dyeColor, ResourceKey<HeadType> resourceKey) {
        HeadType.builder(EntityType.SHEEP).entityPredicate(builder -> builder.components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect((DataComponentType)DataComponents.SHEEP_COLOR, (Object)dyeColor)).build()).subPredicate((EntitySubPredicate)SheepPredicate.hasWool())).shape(6.0, 6.0, 8.0).model(ModelType.SHEEP, ResourceLocationHelper.withDefaultNamespace((String)"entity/sheep/sheep")).dyedModel(ModelType.SHEEP, ResourceLocationHelper.withDefaultNamespace((String)"entity/sheep/sheep_wool_undercoat"), new Color.Sheep(dyeColor)).dyedModel(ModelType.SHEEP_WOOL, ResourceLocationHelper.withDefaultNamespace((String)"entity/sheep/sheep_wool"), new Color.Sheep(dyeColor)).noteBlockSound(SoundEvents.SHEEP_AMBIENT).build(context, resourceKey);
    }

    public static void registerTranslations(BiConsumer<ResourceKey<HeadType>, String> translationConsumer) {
        translationConsumer.accept(WHITE_SHEEP, "White Sheep Head");
        translationConsumer.accept(WHITE_WOOLLY_SHEEP, "White Woolly Sheep Head");
        translationConsumer.accept(ORANGE_SHEEP, "Orange Sheep Head");
        translationConsumer.accept(ORANGE_WOOLLY_SHEEP, "Orange Woolly Sheep Head");
        translationConsumer.accept(MAGENTA_SHEEP, "Magenta Sheep Head");
        translationConsumer.accept(MAGENTA_WOOLLY_SHEEP, "Magenta Woolly Sheep Head");
        translationConsumer.accept(LIGHT_BLUE_SHEEP, "Light Blue Sheep Head");
        translationConsumer.accept(LIGHT_BLUE_WOOLLY_SHEEP, "Light Blue Woolly Sheep Head");
        translationConsumer.accept(YELLOW_SHEEP, "Yellow Sheep Head");
        translationConsumer.accept(YELLOW_WOOLLY_SHEEP, "Yellow Woolly Sheep Head");
        translationConsumer.accept(LIME_SHEEP, "Lime Sheep Head");
        translationConsumer.accept(LIME_WOOLLY_SHEEP, "Lime Woolly Sheep Head");
        translationConsumer.accept(PINK_SHEEP, "Pink Sheep Head");
        translationConsumer.accept(PINK_WOOLLY_SHEEP, "Pink Woolly Sheep Head");
        translationConsumer.accept(GRAY_SHEEP, "Gray Sheep Head");
        translationConsumer.accept(GRAY_WOOLLY_SHEEP, "Gray Woolly Sheep Head");
        translationConsumer.accept(LIGHT_GRAY_SHEEP, "Light Gray Sheep Head");
        translationConsumer.accept(LIGHT_GRAY_WOOLLY_SHEEP, "Light Gray Woolly Sheep Head");
        translationConsumer.accept(CYAN_SHEEP, "Cyan Sheep Head");
        translationConsumer.accept(CYAN_WOOLLY_SHEEP, "Cyan Woolly Sheep Head");
        translationConsumer.accept(PURPLE_SHEEP, "Purple Sheep Head");
        translationConsumer.accept(PURPLE_WOOLLY_SHEEP, "Purple Woolly Sheep Head");
        translationConsumer.accept(BLUE_SHEEP, "Blue Sheep Head");
        translationConsumer.accept(BLUE_WOOLLY_SHEEP, "Blue Woolly Sheep Head");
        translationConsumer.accept(BROWN_SHEEP, "Brown Sheep Head");
        translationConsumer.accept(BROWN_WOOLLY_SHEEP, "Brown Woolly Sheep Head");
        translationConsumer.accept(GREEN_SHEEP, "Green Sheep Head");
        translationConsumer.accept(GREEN_WOOLLY_SHEEP, "Green Woolly Sheep Head");
        translationConsumer.accept(RED_SHEEP, "Red Sheep Head");
        translationConsumer.accept(RED_WOOLLY_SHEEP, "Red Woolly Sheep Head");
        translationConsumer.accept(BLACK_SHEEP, "Black Sheep Head");
        translationConsumer.accept(BLACK_WOOLLY_SHEEP, "Black Woolly Sheep Head");
        translationConsumer.accept(RAINBOW_SHEEP, "Rainbow Sheep Head");
        translationConsumer.accept(RAINBOW_WOOLLY_SHEEP, "Rainbow Woolly Sheep Head");
    }
}

