/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.init.headtype;

import fuzs.alltheheads.advancements.critereon.StriderPredicate;
import fuzs.alltheheads.init.HeadTypes;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;

public class StriderHeadType {
    public static final ResourceKey<HeadType> STRIDER = HeadTypes.register("strider");
    public static final ResourceKey<HeadType> COLD_STRIDER = HeadTypes.register("strider/cold");

    public static void bootstrap(BootstrapContext<HeadType> context) {
        StriderHeadType.bootstrapStrider(context, false, STRIDER, "entity/strider/strider", SoundEvents.STRIDER_HAPPY);
        StriderHeadType.bootstrapStrider(context, true, COLD_STRIDER, "entity/strider/strider_cold", SoundEvents.STRIDER_AMBIENT);
    }

    private static void bootstrapStrider(BootstrapContext<HeadType> context, boolean isCold, ResourceKey<HeadType> resourceKey, String textureLocation, SoundEvent noteBlockSound) {
        HeadType.builder(EntityType.STRIDER).entityPredicate(builder -> builder.subPredicate((EntitySubPredicate)StriderPredicate.isCold(isCold))).shape(16.0, 14.0, 16.0).scale(0.625).model(ModelType.STRIDER, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).noteBlockSound(noteBlockSound).build(context, resourceKey);
    }

    public static void registerTranslations(BiConsumer<ResourceKey<HeadType>, String> translationConsumer) {
        translationConsumer.accept(STRIDER, "Strider Head");
        translationConsumer.accept(COLD_STRIDER, "Cold Strider Head");
    }
}

