/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.init.headtype;

import com.google.common.collect.ImmutableMap;
import fuzs.alltheheads.advancements.critereon.TropicalFishPredicate;
import fuzs.alltheheads.init.HeadTypes;
import fuzs.alltheheads.world.item.component.headtype.Color;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.alltheheads.world.item.component.headtype.Shape;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.TropicalFish;

public class TropicalFishHeadType {
    public static final ResourceKey<HeadType> ANEMONE = HeadTypes.register("tropical_fish/anemone");
    public static final ResourceKey<HeadType> BLACK_TANG = HeadTypes.register("tropical_fish/black_tang");
    public static final ResourceKey<HeadType> BLUE_TANG = HeadTypes.register("tropical_fish/blue_tang");
    public static final ResourceKey<HeadType> BUTTERFLYFISH = HeadTypes.register("tropical_fish/butterflyfish");
    public static final ResourceKey<HeadType> CICHLID = HeadTypes.register("tropical_fish/cichlid");
    public static final ResourceKey<HeadType> CLOWNFISH = HeadTypes.register("tropical_fish/clownfish");
    public static final ResourceKey<HeadType> COTTON_CANDY_BETTA = HeadTypes.register("tropical_fish/cotton_candy_betta");
    public static final ResourceKey<HeadType> DOTTYBACK = HeadTypes.register("tropical_fish/dottyback");
    public static final ResourceKey<HeadType> EMPEROR_RED_SNAPPER = HeadTypes.register("tropical_fish/emperor_red_snapper");
    public static final ResourceKey<HeadType> GOATFISH = HeadTypes.register("tropical_fish/goatfish");
    public static final ResourceKey<HeadType> MOORISH_IDOL = HeadTypes.register("tropical_fish/moorish_idol");
    public static final ResourceKey<HeadType> ORNATE_BUTTERFLYFISH = HeadTypes.register("tropical_fish/ornate_butterflyfish");
    public static final ResourceKey<HeadType> PARROTFISH = HeadTypes.register("tropical_fish/parrotfish");
    public static final ResourceKey<HeadType> QUEEN_ANGELFISH = HeadTypes.register("tropical_fish/queen_angelfish");
    public static final ResourceKey<HeadType> RED_CICHLID = HeadTypes.register("tropical_fish/red_cichlid");
    public static final ResourceKey<HeadType> RED_LIPPED_BLENNY = HeadTypes.register("tropical_fish/red_lipped_blenny");
    public static final ResourceKey<HeadType> RED_SNAPPER = HeadTypes.register("tropical_fish/red_snapper");
    public static final ResourceKey<HeadType> THREADFIN = HeadTypes.register("tropical_fish/threadfin");
    public static final ResourceKey<HeadType> TOMATO_CLOWNFISH = HeadTypes.register("tropical_fish/tomato_clownfish");
    public static final ResourceKey<HeadType> TRIGGERFISH = HeadTypes.register("tropical_fish/triggerfish");
    public static final ResourceKey<HeadType> YELLOWTAIL_PARROTFISH = HeadTypes.register("tropical_fish/yellowtail_parrotfish");
    public static final ResourceKey<HeadType> YELLOW_TANG = HeadTypes.register("tropical_fish/yellow_tang");
    private static final List<ResourceKey<HeadType>> COMMON_TROPICAL_FISH_VARIANTS = List.of(ANEMONE, BLACK_TANG, BLUE_TANG, BUTTERFLYFISH, CICHLID, CLOWNFISH, COTTON_CANDY_BETTA, DOTTYBACK, EMPEROR_RED_SNAPPER, GOATFISH, MOORISH_IDOL, ORNATE_BUTTERFLYFISH, PARROTFISH, QUEEN_ANGELFISH, RED_CICHLID, RED_LIPPED_BLENNY, RED_SNAPPER, THREADFIN, TOMATO_CLOWNFISH, TRIGGERFISH, YELLOWTAIL_PARROTFISH, YELLOW_TANG);
    private static final Map<TropicalFish.Pattern, ResourceLocation> TROPICAL_FISH_PATTERN_TEXTURES = ImmutableMap.builder().put((Object)TropicalFish.Pattern.KOB, (Object)ResourceLocation.withDefaultNamespace((String)"entity/fish/tropical_a_pattern_1")).put((Object)TropicalFish.Pattern.SUNSTREAK, (Object)ResourceLocation.withDefaultNamespace((String)"entity/fish/tropical_a_pattern_2")).put((Object)TropicalFish.Pattern.SNOOPER, (Object)ResourceLocation.withDefaultNamespace((String)"entity/fish/tropical_a_pattern_3")).put((Object)TropicalFish.Pattern.DASHER, (Object)ResourceLocation.withDefaultNamespace((String)"entity/fish/tropical_a_pattern_4")).put((Object)TropicalFish.Pattern.BRINELY, (Object)ResourceLocation.withDefaultNamespace((String)"entity/fish/tropical_a_pattern_5")).put((Object)TropicalFish.Pattern.SPOTTY, (Object)ResourceLocation.withDefaultNamespace((String)"entity/fish/tropical_a_pattern_6")).put((Object)TropicalFish.Pattern.FLOPPER, (Object)ResourceLocation.withDefaultNamespace((String)"entity/fish/tropical_b_pattern_1")).put((Object)TropicalFish.Pattern.STRIPEY, (Object)ResourceLocation.withDefaultNamespace((String)"entity/fish/tropical_b_pattern_2")).put((Object)TropicalFish.Pattern.GLITTER, (Object)ResourceLocation.withDefaultNamespace((String)"entity/fish/tropical_b_pattern_3")).put((Object)TropicalFish.Pattern.BLOCKFISH, (Object)ResourceLocation.withDefaultNamespace((String)"entity/fish/tropical_b_pattern_4")).put((Object)TropicalFish.Pattern.BETTY, (Object)ResourceLocation.withDefaultNamespace((String)"entity/fish/tropical_b_pattern_5")).put((Object)TropicalFish.Pattern.CLAYFISH, (Object)ResourceLocation.withDefaultNamespace((String)"entity/fish/tropical_b_pattern_6")).build();

    public static void bootstrap(BootstrapContext<HeadType> context) {
        for (int i = 0; i < COMMON_TROPICAL_FISH_VARIANTS.size(); ++i) {
            TropicalFish.Variant variant = (TropicalFish.Variant)TropicalFish.COMMON_VARIANTS.get(i);
            ResourceKey<HeadType> resourceKey = COMMON_TROPICAL_FISH_VARIANTS.get(i);
            TropicalFishHeadType.boostrapTropicalFish(context, variant, resourceKey);
        }
    }

    private static void boostrapTropicalFish(BootstrapContext<HeadType> context, TropicalFish.Variant variant, ResourceKey<HeadType> resourceKey) {
        switch (variant.pattern().base()) {
            case LARGE: {
                TropicalFishHeadType.boostrapTropicalFish(context, variant, resourceKey, "entity/fish/tropical_b", new Shape(2.0, 6.0, 4.0), ModelType.TROPICAL_FISH_LARGE);
                break;
            }
            case SMALL: {
                TropicalFishHeadType.boostrapTropicalFish(context, variant, resourceKey, "entity/fish/tropical_a", new Shape(2.0, 3.0, 4.0), ModelType.TROPICAL_FISH_SMALL);
            }
        }
    }

    private static void boostrapTropicalFish(BootstrapContext<HeadType> context, TropicalFish.Variant variant, ResourceKey<HeadType> resourceKey, String textureLocation, Shape shape, ModelType modelType) {
        HeadType.builder(EntityType.TROPICAL_FISH).entityPredicate(builder -> builder.subPredicate((EntitySubPredicate)TropicalFishPredicate.hasVariant(variant))).shape(shape).scale(1.5).dyedModel(modelType, ResourceLocationHelper.withDefaultNamespace((String)textureLocation), new Color.Dye(variant.baseColor())).dyedModel(modelType, TROPICAL_FISH_PATTERN_TEXTURES.get(variant.pattern()), new Color.Dye(variant.patternColor())).noteBlockSound(SoundEvents.TROPICAL_FISH_FLOP).build(context, resourceKey);
    }

    public static void registerTranslations(BiConsumer<ResourceKey<HeadType>, String> translationConsumer) {
        translationConsumer.accept(ANEMONE, "Anemone Head");
        translationConsumer.accept(BLACK_TANG, "Black Tang Head");
        translationConsumer.accept(BLUE_TANG, "Blue Tang Head");
        translationConsumer.accept(BUTTERFLYFISH, "Butterflyfish Head");
        translationConsumer.accept(CICHLID, "Cichlid Head");
        translationConsumer.accept(CLOWNFISH, "Clownfish Head");
        translationConsumer.accept(COTTON_CANDY_BETTA, "Cotton Candy Betta Head");
        translationConsumer.accept(DOTTYBACK, "Dottyback Head");
        translationConsumer.accept(EMPEROR_RED_SNAPPER, "Emperor Red Snapper Head");
        translationConsumer.accept(GOATFISH, "Goatfish Head");
        translationConsumer.accept(MOORISH_IDOL, "Moorish Idol Head");
        translationConsumer.accept(ORNATE_BUTTERFLYFISH, "Ornate Butterflyfish Head");
        translationConsumer.accept(PARROTFISH, "Parrotfish Head");
        translationConsumer.accept(QUEEN_ANGELFISH, "Queen Angelfish Head");
        translationConsumer.accept(RED_CICHLID, "Red Cichlid Head");
        translationConsumer.accept(RED_LIPPED_BLENNY, "Red Lipped Blenny Head");
        translationConsumer.accept(RED_SNAPPER, "Red Snapper Head");
        translationConsumer.accept(THREADFIN, "Threadfin Head");
        translationConsumer.accept(TOMATO_CLOWNFISH, "Tomato Clownfish Head");
        translationConsumer.accept(TRIGGERFISH, "Triggerfish Head");
        translationConsumer.accept(YELLOWTAIL_PARROTFISH, "Yellowtail Parrotfish Head");
        translationConsumer.accept(YELLOW_TANG, "Yellow Tang Head");
    }
}

