/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.init.headtype;

import fuzs.alltheheads.init.HeadTypes;
import fuzs.alltheheads.world.item.component.headtype.Color;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.function.BiConsumer;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;

public class WitherHeadType {
    public static final ResourceKey<HeadType> WITHER = HeadTypes.register("wither");
    public static final ResourceKey<HeadType> SHIELED_WITHER = HeadTypes.register("wither/shielded");
    public static final ResourceKey<HeadType> BLUE_WITHER = HeadTypes.register("wither/blue");
    public static final ResourceKey<HeadType> SHIELDED_BLUE_WITHER = HeadTypes.register("wither/blue/shielded");

    public static void bootstrap(BootstrapContext<HeadType> context) {
        WitherHeadType.bootstrapWither(context, WITHER, "entity/wither/wither");
        WitherHeadType.bootstrapWither(context, BLUE_WITHER, "entity/wither/wither_invulnerable");
        WitherHeadType.bootstrapPoweredWither(context, SHIELED_WITHER, "entity/wither/wither");
        WitherHeadType.bootstrapPoweredWither(context, SHIELDED_BLUE_WITHER, "entity/wither/wither_invulnerable");
    }

    private static void bootstrapWither(BootstrapContext<HeadType> context, ResourceKey<HeadType> resourceKey, String textureLocation) {
        HeadType.builder(EntityType.WITHER).shape(8.0, 8.0, 8.0).litModel(ModelType.HUMANOID, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).noteBlockSound(SoundEvents.WITHER_AMBIENT).build(context, resourceKey);
    }

    private static void bootstrapPoweredWither(BootstrapContext<HeadType> context, ResourceKey<HeadType> resourceKey, String textureLocation) {
        HeadType.builder(EntityType.WITHER).shape(8.0, 8.0, 8.0).litModel(ModelType.HUMANOID, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).dyedModel(ModelType.WITHER_SHIELD, ResourceLocationHelper.withDefaultNamespace((String)"entity/wither/wither_armor"), new Color.Constant(-8355712)).noteBlockSound(SoundEvents.WITHER_AMBIENT).build(context, resourceKey);
    }

    public static void registerTranslations(BiConsumer<ResourceKey<HeadType>, String> translationConsumer) {
        translationConsumer.accept(BLUE_WITHER, "Blue Wither Head");
        translationConsumer.accept(SHIELDED_BLUE_WITHER, "Shielded Blue Wither Head");
        translationConsumer.accept(SHIELED_WITHER, "Shielded Wither Head");
        translationConsumer.accept(WITHER, "Wither Head");
    }
}

