/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.world.item.component.headtype;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.alltheheads.init.ModRegistry;
import fuzs.alltheheads.world.item.component.headtype.Builder;
import fuzs.alltheheads.world.item.component.headtype.Loot;
import fuzs.alltheheads.world.item.component.headtype.Model;
import fuzs.alltheheads.world.item.component.headtype.Shape;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public record HeadType(EntityPredicate entityPredicate, Shape shape, Loot loot, Optional<String> customName, boolean mobDisguise, Optional<Holder<SoundEvent>> noteBlockSound, List<Model> models) {
    public static final Codec<HeadType> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.CODEC.fieldOf("entity_predicate").forGetter(HeadType::entityPredicate), (App)Shape.CODEC.fieldOf("shape").forGetter(HeadType::shape), (App)Loot.CODEC.forGetter(HeadType::loot), (App)Codec.STRING.optionalFieldOf("custom_name").forGetter(HeadType::customName), (App)Codec.BOOL.optionalFieldOf("mob_disguise", (Object)true).forGetter(HeadType::mobDisguise), (App)BuiltInRegistries.SOUND_EVENT.holderByNameCodec().optionalFieldOf("note_block_sound").forGetter(HeadType::noteBlockSound), (App)Model.CODEC.listOf(1, Integer.MAX_VALUE).fieldOf("models").forGetter(HeadType::models)).apply((Applicative)instance, HeadType::new));
    public static final Codec<HeadType> DIRECT_NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Shape.CODEC.fieldOf("shape").forGetter(HeadType::shape), (App)Codec.STRING.optionalFieldOf("custom_name").forGetter(HeadType::customName), (App)BuiltInRegistries.SOUND_EVENT.holderByNameCodec().optionalFieldOf("note_block_sound").forGetter(HeadType::noteBlockSound), (App)Model.CODEC.listOf(1, Integer.MAX_VALUE).fieldOf("models").forGetter(HeadType::models)).apply((Applicative)instance, HeadType::new));
    public static final Codec<Holder<HeadType>> CODEC = RegistryFixedCodec.create(ModRegistry.HEAD_REGISTRY_KEY);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<HeadType>> STREAM_CODEC = ByteBufCodecs.holderRegistry(ModRegistry.HEAD_REGISTRY_KEY);

    private HeadType(Shape shape, Optional<String> customName, Optional<Holder<SoundEvent>> noteBlockSound, List<Model> models) {
        this(EntityPredicate.Builder.entity().build(), shape, new Loot(Optional.empty(), true), customName, false, noteBlockSound, models);
    }

    public static Builder builder(EntityType<?> entityType) {
        return new Builder(entityType);
    }

    public static ResourceLocation customName(ResourceKey<HeadType> resourceKey) {
        String joinedPath = String.join((CharSequence)":", resourceKey.location().getPath().split("/", 2));
        return Optional.ofNullable(ResourceLocationHelper.tryParse((String)joinedPath)).orElse(resourceKey.location()).withPath(path -> path.replace('/', '_'));
    }

    public Stream<EntityType<?>> getEntityTypes() {
        return ((EntityTypePredicate)this.entityPredicate.entityType().orElseThrow()).types().stream().map(Holder::value);
    }

    public EntityType<?> getEntityType() {
        return this.getEntityTypes().findFirst().orElseThrow();
    }

    public Component getName(String descriptionId) {
        return Component.translatable((String)this.customName.map(s -> descriptionId + "." + s).orElse(descriptionId));
    }

    public boolean matches(Entity entity) {
        return this.entityPredicate().matches((ServerLevel)entity.level(), entity.position(), entity);
    }
}

