/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.world.level.block.entity;

import fuzs.alltheheads.init.ModRegistry;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class MobHeadBlockEntity
extends SkullBlockEntity
implements TickingBlockEntity {
    public static final String TAG_HEAD_TYPE = "head_type";
    @Nullable
    private Holder<HeadType> headType;
    public int tickCount;

    public MobHeadBlockEntity(BlockPos pos, BlockState blockState) {
        super(pos, blockState);
    }

    public void clientTick() {
        ++this.tickCount;
        MobHeadBlockEntity.animation((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState(), (SkullBlockEntity)this);
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)ModRegistry.MOB_HEAD_BLOCK_ENTITY_TYPE.value();
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.storeNullable(TAG_HEAD_TYPE, HeadType.CODEC, this.headType);
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.headType = valueInput.read(TAG_HEAD_TYPE, HeadType.CODEC).orElse(null);
    }

    @Nullable
    public Holder<HeadType> getHeadType() {
        return this.headType;
    }

    @Nullable
    public ResourceLocation getNoteBlockSound() {
        ResourceLocation noteBlockSound = super.getNoteBlockSound();
        if (noteBlockSound != null) {
            return noteBlockSound;
        }
        if (this.headType != null) {
            return ((HeadType)this.headType.value()).noteBlockSound().map(Holder::value).map(SoundEvent::location).orElse(null);
        }
        return null;
    }

    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        super.applyImplicitComponents(componentGetter);
        this.headType = (Holder)componentGetter.get((DataComponentType)ModRegistry.HEAD_TYPE_DATA_COMPONENT_TYPE.value());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set((DataComponentType)ModRegistry.HEAD_TYPE_DATA_COMPONENT_TYPE.value(), this.headType);
    }

    public void removeComponentsFromTag(ValueOutput output) {
        super.removeComponentsFromTag(output);
        output.discard(TAG_HEAD_TYPE);
    }
}

