/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.client.renderer.blockentity;

import fuzs.alltheheads.client.renderer.blockentity.state.MobHeadRenderState;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.Model;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.alltheheads.world.item.component.headtype.Shape;
import fuzs.alltheheads.world.level.block.entity.MobHeadBlockEntity;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1068;
import net.minecraft.class_10693;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11972;
import net.minecraft.class_12075;
import net.minecraft.class_12079;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_5614;
import net.minecraft.class_607;
import net.minecraft.class_630;
import net.minecraft.class_6880;
import net.minecraft.class_765;
import net.minecraft.class_7946;
import net.minecraft.class_836;
import org.jetbrains.annotations.Nullable;

public class MobHeadRenderer
extends class_836 {
    private static final List<Model> DEFAULT_MODELS = List.of(new Model((class_10693<ModelType>)new class_10693((Object)ModelType.DEFAULT, new class_12079.class_10726(class_1068.method_4649(), class_1068.method_4649())), Optional.empty(), Optional.empty()));
    private static final Shape DEFAULT_SHAPE = new Shape(8.0, 8.0, 8.0);
    private static final Map<ModelType, Function<class_630, class_5598>> SKULL_MODELS = Collections.unmodifiableMap((Map)class_156.method_654(new IdentityHashMap(), map -> map.put(ModelType.PIGLIN, class_7946::new)));
    private static final Map<ModelType, BiFunction<class_2960, Float, class_1921>> RENDER_TYPES = Collections.unmodifiableMap((Map)class_156.method_654(new IdentityHashMap(), map -> {
        MobHeadRenderer.putRenderType(ModelType.ALLAY, class_1921::method_23580, map::put);
        MobHeadRenderer.putRenderType(ModelType.BAT, class_1921::method_23576, map::put);
        MobHeadRenderer.putEyesRenderType(ModelType.BREEZE, ModelType.BREEZE_EYES, map::put);
        MobHeadRenderer.putEyesRenderType(ModelType.COPPER_GOLEM, ModelType.COPPER_GOLEM_EYES, map::put);
        MobHeadRenderer.putEyesRenderType(ModelType.CREAKING, ModelType.CREAKING_EYES, map::put);
        map.put(ModelType.CREEPER_CHARGE, (resourceLocation, tickCount) -> class_1921.method_23018((class_2960)resourceLocation, (float)(tickCount.floatValue() * 0.01f % 1.0f), (float)(tickCount.floatValue() * 0.01f % 1.0f)));
        MobHeadRenderer.putEyesRenderType(ModelType.ENDERMAN, ModelType.ENDERMAN_EYES, map::put);
        MobHeadRenderer.putRenderType(ModelType.HORSE, class_1921::method_23578, map::put);
        MobHeadRenderer.putRenderType(ModelType.HORSE_MARKINGS, class_1921::method_23580, map::put);
        MobHeadRenderer.putEyesRenderType(ModelType.PHANTOM, ModelType.PHANTOM_EYES, map::put);
        MobHeadRenderer.putRenderType(ModelType.SLIME_GEL, class_1921::method_23580, map::put);
        MobHeadRenderer.putEyesRenderType(ModelType.SPIDER, ModelType.SPIDER_EYES, map::put);
        MobHeadRenderer.putRenderType(ModelType.TROPICAL_FISH_LARGE, class_1921::method_23578, map::put);
        MobHeadRenderer.putRenderType(ModelType.TROPICAL_FISH_SMALL, class_1921::method_23578, map::put);
        MobHeadRenderer.putRenderType(ModelType.VEX, class_1921::method_23580, map::put);
        map.put(ModelType.WITHER_SHIELD, (resourceLocation, tickCount) -> class_1921.method_23018((class_2960)resourceLocation, (float)(class_3532.method_15362((float)(tickCount.floatValue() * 0.02f)) * 3.0f % 1.0f), (float)(tickCount.floatValue() * 0.01f % 1.0f)));
    }));
    private final Function<ModelType, class_5598> skullModelGetter;

    public MobHeadRenderer(class_5614.class_5615 context) {
        super(context);
        this.skullModelGetter = MobHeadRenderer.createSkullModels(context.comp_4539());
    }

    private static void putEyesRenderType(ModelType modelType, ModelType eyesModelType, BiConsumer<ModelType, BiFunction<class_2960, Float, class_1921>> consumer) {
        MobHeadRenderer.putRenderType(modelType, class_1921::method_23578, consumer);
        MobHeadRenderer.putRenderType(eyesModelType, class_1921::method_23026, consumer);
    }

    private static void putRenderType(ModelType modelType, Function<class_2960, class_1921> renderTypeGetter, BiConsumer<ModelType, BiFunction<class_2960, Float, class_1921>> consumer) {
        consumer.accept(modelType, (resourceLocation, tickCount) -> (class_1921)renderTypeGetter.apply((class_2960)resourceLocation));
    }

    public static Function<ModelType, class_5598> createSkullModels(class_5599 entityModelSet) {
        return class_156.method_34866(modelType -> {
            Function<class_630, class_5598> skullModelGetter = SKULL_MODELS.getOrDefault(modelType, class_607::new);
            class_5601 modelLayerLocation = MobHeadRenderer.createModelLayer(modelType);
            class_630 modelPart = entityModelSet.method_32072(modelLayerLocation);
            return skullModelGetter.apply(modelPart);
        });
    }

    public static class_5601 createModelLayer(ModelType modelType) {
        return new class_5601(modelType.model(), modelType.layer());
    }

    public MobHeadRenderState createRenderState() {
        return new MobHeadRenderState();
    }

    public void method_74386(class_2631 blockEntity, class_11972 renderState, float partialTick, class_243 cameraPosition, @Nullable class_11683.class_11792 breakProgress) {
        super.method_74386(blockEntity, renderState, partialTick, cameraPosition, breakProgress);
        ((MobHeadRenderState)renderState).headType = ((MobHeadBlockEntity)blockEntity).getHeadType();
        ((MobHeadRenderState)renderState).time = (float)((MobHeadBlockEntity)blockEntity).tickCount + partialTick;
    }

    public void method_3577(class_11972 renderState, class_4587 poseStack, class_11659 nodeCollector, class_12075 cameraRenderState) {
        MobHeadRenderer.submitSkull((MobHeadRenderState)renderState, poseStack, nodeCollector, this.skullModelGetter);
    }

    public static void submitSkull(MobHeadRenderState renderState, class_4587 poseStack, class_11659 nodeCollector, Function<ModelType, class_5598> skullModelGetter) {
        Shape shape = MobHeadRenderer.getShape(renderState.headType);
        for (Model model : MobHeadRenderer.getModels(renderState.headType)) {
            class_5598 skullModelBase = skullModelGetter.apply((ModelType)model.model().comp_3572());
            class_1921 renderType = MobHeadRenderer.getRenderType(model.model(), renderState.time);
            MobHeadRenderer.submitSkull(renderState, poseStack, nodeCollector, skullModelBase, renderType, model.blockLight().map(blockLight -> class_765.method_23687((int)blockLight, (int)class_765.method_24187((int)renderState.field_62676))).orElse(renderState.field_62676), model.color().map(tintColor -> tintColor.getColor(renderState.time)).orElse(-1), shape);
        }
    }

    private static void submitSkull(MobHeadRenderState renderState, class_4587 poseStack, class_11659 nodeCollector, class_5598 model, class_1921 renderType, int packedLight, int tintColor, Shape shape) {
        poseStack.method_22903();
        double offsetY = (16.0 - shape.sizeY()) / 2.0;
        if (renderState.field_62746 != null) {
            double offsetX = 8.0 - (double)renderState.field_62746.method_10148() * (16.0 - shape.sizeX(renderState.field_62746)) / 2.0;
            double offsetZ = 8.0 - (double)renderState.field_62746.method_10165() * (16.0 - shape.sizeZ(renderState.field_62746)) / 2.0;
            poseStack.method_22904(offsetX / 16.0, offsetY / 16.0, offsetZ / 16.0);
        } else {
            poseStack.method_46416(0.5f, renderState.guiOffset ? ((float)offsetY - 3.3333333f) / 16.0f : 0.0f, 0.5f);
        }
        poseStack.method_22905((float)(-shape.scale()), (float)(-shape.scale()), (float)shape.scale());
        class_5598.class_11652 state = new class_5598.class_11652();
        state.field_61681 = renderState.field_62745;
        state.field_61682 = renderState.field_62747;
        nodeCollector.method_73490((class_3879)model, (Object)state, poseStack, renderType, packedLight, class_4608.field_21444, tintColor, null, renderState.outlineColor, renderState.field_62677);
        poseStack.method_22909();
    }

    private static List<Model> getModels(class_6880<HeadType> headType) {
        return headType != null ? ((HeadType)headType.comp_349()).models() : DEFAULT_MODELS;
    }

    private static Shape getShape(class_6880<HeadType> headType) {
        return headType != null ? ((HeadType)headType.comp_349()).shape() : DEFAULT_SHAPE;
    }

    private static class_1921 getRenderType(class_10693<ModelType> modelAndTexture, float tickCount) {
        BiFunction<class_2960, Float, class_1921> renderTypeGetter = RENDER_TYPES.getOrDefault(modelAndTexture.comp_3572(), (resourceLocation, tickCountX) -> class_1921.method_28116((class_2960)resourceLocation));
        return renderTypeGetter.apply(modelAndTexture.comp_3573().comp_3627(), Float.valueOf(tickCount));
    }
}

