/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.world.item.component.headtype;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.alltheheads.AllTheHeads;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5699;
import net.minecraft.class_9848;

public interface Color {
    public static final class_5699.class_10388<class_2960, MapCodec<? extends Color>> ID_MAPPER = (class_5699.class_10388)class_156.method_654((Object)new class_5699.class_10388(), idMapper -> {
        idMapper.method_65325((Object)AllTheHeads.id("constant"), Constant.CODEC);
        idMapper.method_65325((Object)AllTheHeads.id("dye"), Dye.CODEC);
        idMapper.method_65325((Object)AllTheHeads.id("sheep"), Sheep.CODEC);
        idMapper.method_65325((Object)AllTheHeads.id("rainbow"), Rainbow.CODEC);
    });
    public static final Codec<Color> CODEC = ID_MAPPER.method_65323(class_2960.field_25139).dispatch(Color::type, Function.identity());

    public MapCodec<? extends Color> type();

    public int getColor(float var1);

    public record Constant(int value) implements Color
    {
        public static final MapCodec<Constant> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_54067.fieldOf("value").forGetter(Constant::value)).apply((Applicative)instance, Constant::new));

        public Constant(int value) {
            this.value = class_9848.method_61334((int)value);
        }

        @Override
        public MapCodec<? extends Color> type() {
            return CODEC;
        }

        @Override
        public int getColor(float tickCount) {
            return this.value;
        }
    }

    public record Dye(class_1767 dye) implements Color
    {
        public static final MapCodec<Dye> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1767.field_41600.fieldOf("dye").forGetter(Dye::dye)).apply((Applicative)instance, Dye::new));

        @Override
        public MapCodec<? extends Color> type() {
            return CODEC;
        }

        @Override
        public int getColor(float tickCount) {
            return this.dye.method_7787();
        }
    }

    public record Sheep(class_1767 dye) implements Color
    {
        public static final MapCodec<Sheep> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1767.field_41600.fieldOf("dye").forGetter(Sheep::dye)).apply((Applicative)instance, Sheep::new));
        static final Map<class_1767, Integer> COLOR_BY_DYE = (Map)Arrays.stream(class_1767.values()).collect(Maps.toImmutableEnumMap(Function.identity(), Sheep::getModifiedColor));

        @Override
        public MapCodec<? extends Color> type() {
            return CODEC;
        }

        @Override
        public int getColor(float tickCount) {
            return COLOR_BY_DYE.get(this.dye);
        }

        static int getModifiedColor(class_1767 color) {
            return Sheep.getModifiedColor(color, 0.75f);
        }

        static int getModifiedColor(class_1767 color, float brightness) {
            if (color == class_1767.field_7952) {
                return -1644826;
            }
            int i = color.method_7787();
            return class_9848.method_61324((int)255, (int)class_3532.method_15375((float)((float)class_9848.method_61327((int)i) * brightness)), (int)class_3532.method_15375((float)((float)class_9848.method_61329((int)i) * brightness)), (int)class_3532.method_15375((float)((float)class_9848.method_61331((int)i) * brightness)));
        }
    }

    public record Rainbow() implements Color
    {
        public static final MapCodec<Rainbow> CODEC = MapCodec.unit((Object)new Rainbow());
        private static final class_1767[] COLORS = class_1767.values();
        private static final int COLOR_DURATION = 25;

        @Override
        public MapCodec<? extends Color> type() {
            return CODEC;
        }

        @Override
        public int getColor(float tickCount) {
            return Rainbow.getLerpedColor(tickCount);
        }

        static int getLerpedColor(float time) {
            int i = class_3532.method_15375((float)time);
            int j = i / 25;
            int k = COLORS.length;
            int l = j % k;
            int m = (j + 1) % k;
            float f = ((float)(i % 25) + class_3532.method_22450((float)time)) / 25.0f;
            int n = Sheep.COLOR_BY_DYE.get(COLORS[l]);
            int o = Sheep.COLOR_BY_DYE.get(COLORS[m]);
            return class_9848.method_61319((float)f, (int)n, (int)o);
        }
    }
}

