/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.world.item.component.headtype;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_7718;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record Shape(double width, double height, double depth, double scale, Int2ObjectMap<class_265> verticalShapes, Map<class_2350, class_265> horizontalShapes) {
    public static final Codec<Shape> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.doubleRange((double)1.0, (double)24.0).fieldOf("width").forGetter(Shape::width), (App)Codec.doubleRange((double)1.0, (double)24.0).fieldOf("height").forGetter(Shape::height), (App)Codec.doubleRange((double)1.0, (double)24.0).fieldOf("depth").forGetter(Shape::depth), (App)Codec.doubleRange((double)0.0, (double)Double.MAX_VALUE).optionalFieldOf("scale", (Object)1.0).forGetter(Shape::scale)).apply((Applicative)instance, Shape::new));
    public static final class_9139<ByteBuf, Shape> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_48553, Shape::scaledWidth, (class_9139)class_9135.field_48553, Shape::scaledHeight, (class_9139)class_9135.field_48553, Shape::scaledDepth, Shape::new);

    public Shape(double width, double height, double depth) {
        this(width, height, depth, 1.0);
    }

    private Shape(double width, double height, double depth, double scale) {
        this(width, height, depth, scale, (Int2ObjectMap<class_265>)((Int2ObjectMap)class_156.method_654((Object)new Int2ObjectArrayMap(), map -> {
            Map rotatedShapes = class_259.method_66501((class_265)class_2248.method_66395((double)(width * scale), (double)(depth * scale), (double)0.0, (double)(height * scale)));
            for (int i = 0; i <= class_7718.method_45478(); ++i) {
                map.put(i, (Object)class_7718.method_45480((int)i).map(rotatedShapes::get).orElseGet(() -> class_2248.method_66404((double)(Math.max(width, depth) * scale), (double)0.0, (double)(height * scale))));
            }
        })), class_259.method_66501((class_265)class_2248.method_66396((double)(width * scale), (double)(8.0 - height * scale / 2.0), (double)(8.0 + height * scale / 2.0), (double)(16.0 - depth * scale), (double)16.0)));
    }

    public Shape scale(double scale) {
        return new Shape(this.width, this.height, this.depth, this.scale * scale);
    }

    private double scaledWidth() {
        return this.width * this.scale;
    }

    private double scaledHeight() {
        return this.height * this.scale;
    }

    private double scaledDepth() {
        return this.depth * this.scale;
    }

    public double sizeX(class_2350 direction) {
        return direction.method_10166() != class_2350.class_2351.field_11051 ? this.scaledDepth() : this.scaledWidth();
    }

    public double sizeY() {
        return this.scaledHeight();
    }

    public double sizeZ(class_2350 direction) {
        return direction.method_10166() == class_2350.class_2351.field_11051 ? this.scaledDepth() : this.scaledWidth();
    }
}

