/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.client.renderer.blockentity;

import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.Model;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.alltheheads.world.item.component.headtype.Shape;
import fuzs.alltheheads.world.level.block.entity.MobHeadBlockEntity;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1068;
import net.minecraft.class_10693;
import net.minecraft.class_10726;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2484;
import net.minecraft.class_2549;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_5614;
import net.minecraft.class_607;
import net.minecraft.class_630;
import net.minecraft.class_6880;
import net.minecraft.class_765;
import net.minecraft.class_7718;
import net.minecraft.class_7946;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class MobHeadBlockRenderer
implements class_827<MobHeadBlockEntity> {
    private static final List<Model> DEFAULT_MODELS = List.of(new Model((class_10693<ModelType>)new class_10693((Object)ModelType.DEFAULT, new class_10726(class_1068.method_4649(), class_1068.method_4649())), Optional.empty(), Optional.empty()));
    private static final Shape DEFAULT_SHAPE = new Shape(8.0, 8.0, 8.0);
    private static final Map<ModelType, Function<class_630, class_5598>> SKULL_MODELS = Collections.unmodifiableMap((Map)class_156.method_654(new IdentityHashMap(), map -> map.put(ModelType.PIGLIN, class_7946::new)));
    private static final Map<ModelType, BiFunction<class_2960, Float, class_1921>> RENDER_TYPES = Collections.unmodifiableMap((Map)class_156.method_654(new IdentityHashMap(), map -> {
        MobHeadBlockRenderer.putRenderType(ModelType.ALLAY, class_1921::method_23580, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.BAT, class_1921::method_23576, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.BREEZE, class_1921::method_23578, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.BREEZE_EYES, class_1921::method_23026, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.CREAKING, class_1921::method_23578, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.CREAKING_EYES, class_1921::method_23026, map::put);
        map.put(ModelType.CREEPER_CHARGE, (resourceLocation, tickCount) -> class_1921.method_23018((class_2960)resourceLocation, (float)(tickCount.floatValue() * 0.01f % 1.0f), (float)(tickCount.floatValue() * 0.01f % 1.0f)));
        MobHeadBlockRenderer.putRenderType(ModelType.ENDERMAN, class_1921::method_23578, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.ENDERMAN_EYES, class_1921::method_23026, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.HORSE, class_1921::method_23578, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.HORSE_MARKINGS, class_1921::method_23580, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.PHANTOM, class_1921::method_23578, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.PHANTOM_EYES, class_1921::method_23026, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.SLIME_GEL, class_1921::method_23580, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.SPIDER, class_1921::method_23578, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.SPIDER_EYES, class_1921::method_23026, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.TROPICAL_FISH_LARGE, class_1921::method_23578, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.TROPICAL_FISH_SMALL, class_1921::method_23578, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.VEX, class_1921::method_23580, map::put);
        map.put(ModelType.WITHER_SHIELD, (resourceLocation, tickCount) -> class_1921.method_23018((class_2960)resourceLocation, (float)(class_3532.method_15362((float)(tickCount.floatValue() * 0.02f)) * 3.0f % 1.0f), (float)(tickCount.floatValue() * 0.01f % 1.0f)));
    }));
    private final Function<ModelType, class_5598> skullModelGetter;

    public MobHeadBlockRenderer(class_5614.class_5615 context) {
        this.skullModelGetter = MobHeadBlockRenderer.createSkullModels(context.method_32142());
    }

    private static void putRenderType(ModelType modelType, Function<class_2960, class_1921> renderTypeGetter, BiConsumer<ModelType, BiFunction<class_2960, Float, class_1921>> consumer) {
        consumer.accept(modelType, (resourceLocation, tickCount) -> (class_1921)renderTypeGetter.apply((class_2960)resourceLocation));
    }

    public static Function<ModelType, class_5598> createSkullModels(class_5599 entityModelSet) {
        return class_156.method_34866(modelType -> {
            Function<class_630, class_5598> skullModelGetter = SKULL_MODELS.getOrDefault(modelType, class_607::new);
            class_5601 modelLayerLocation = MobHeadBlockRenderer.createModelLayer(modelType);
            class_630 modelPart = entityModelSet.method_32072(modelLayerLocation);
            return skullModelGetter.apply(modelPart);
        });
    }

    public static class_5601 createModelLayer(ModelType modelType) {
        return new class_5601(modelType.model(), modelType.layer());
    }

    public void render(MobHeadBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight, int packedOverlay, class_243 cameraPos) {
        float animation = blockEntity.method_47588(partialTick);
        class_2680 blockState = blockEntity.method_11010();
        boolean isWallSkullBlock = blockState.method_26204() instanceof class_2549;
        class_2350 direction = isWallSkullBlock ? (class_2350)blockState.method_11654((class_2769)class_2549.field_11724) : null;
        int rotationSegment = isWallSkullBlock ? class_7718.method_45481((class_2350)direction.method_10153()) : (Integer)blockState.method_11654((class_2769)class_2484.field_11505);
        float rotationSegmentDegrees = class_7718.method_45482((int)rotationSegment);
        MobHeadBlockRenderer.renderSkull(direction, rotationSegmentDegrees, animation, poseStack, bufferSource, packedLight, this.skullModelGetter, blockEntity.getHeadType(), false, (float)blockEntity.tickCount + partialTick);
    }

    public static void renderSkull(@Nullable class_2350 direction, float rotationSegmentDegrees, float animation, class_4587 poseStack, class_4597 bufferSource, int packedLight, Function<ModelType, class_5598> skullModelGetter, @Nullable class_6880<HeadType> headType, boolean guiOffset, float tickCount) {
        Shape shape = MobHeadBlockRenderer.getShape(headType);
        for (Model model : MobHeadBlockRenderer.getModels(headType)) {
            class_5598 skullModelBase = skullModelGetter.apply((ModelType)model.model().comp_3572());
            class_1921 renderType = MobHeadBlockRenderer.getRenderType(model.model(), tickCount);
            MobHeadBlockRenderer.renderSkull(shape, guiOffset, direction, rotationSegmentDegrees, animation, poseStack, bufferSource, model.blockLight().map(blockLight -> class_765.method_23687((int)blockLight, (int)class_765.method_24187((int)packedLight))).orElse(packedLight), skullModelBase, renderType, model.color().map(color -> color.getColor(tickCount)).orElse(-1));
        }
    }

    private static void renderSkull(Shape shape, boolean guiOffset, @Nullable class_2350 direction, float yRot, float mouthAnimation, class_4587 poseStack, class_4597 bufferSource, int packedLight, class_5598 model, class_1921 renderType, int color) {
        poseStack.method_22903();
        double offsetY = (16.0 - shape.sizeY()) / 2.0;
        if (direction != null) {
            double offsetX = 8.0 - (double)direction.method_10148() * (16.0 - shape.sizeX(direction)) / 2.0;
            double offsetZ = 8.0 - (double)direction.method_10165() * (16.0 - shape.sizeZ(direction)) / 2.0;
            poseStack.method_22904(offsetX / 16.0, offsetY / 16.0, offsetZ / 16.0);
        } else {
            poseStack.method_46416(0.5f, guiOffset ? ((float)offsetY - 3.3333333f) / 16.0f : 0.0f, 0.5f);
        }
        poseStack.method_22905((float)(-shape.scale()), (float)(-shape.scale()), (float)shape.scale());
        class_4588 vertexConsumer = bufferSource.getBuffer(renderType);
        model.method_2821(mouthAnimation, yRot, 0.0f);
        model.method_62100(poseStack, vertexConsumer, packedLight, class_4608.field_21444, color);
        poseStack.method_22909();
    }

    private static List<Model> getModels(class_6880<HeadType> headType) {
        return headType != null ? ((HeadType)headType.comp_349()).models() : DEFAULT_MODELS;
    }

    private static Shape getShape(class_6880<HeadType> headType) {
        return headType != null ? ((HeadType)headType.comp_349()).shape() : DEFAULT_SHAPE;
    }

    private static class_1921 getRenderType(class_10693<ModelType> modelAndTexture, float tickCount) {
        BiFunction<class_2960, Float, class_1921> renderTypeGetter = RENDER_TYPES.getOrDefault(modelAndTexture.comp_3572(), (resourceLocation, tickCountX) -> class_1921.method_28116((class_2960)resourceLocation));
        return renderTypeGetter.apply(modelAndTexture.comp_3573().comp_3627(), Float.valueOf(tickCount));
    }
}

