/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.alltheheads.init.ModRegistry;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record BeePredicate(Optional<Boolean> angry, Optional<Boolean> nectar) implements EntitySubPredicate
{
    public static final MapCodec<BeePredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("angry").forGetter(BeePredicate::angry), (App)Codec.BOOL.optionalFieldOf("has_nectar").forGetter(BeePredicate::nectar)).apply((Applicative)instance, BeePredicate::new));

    public MapCodec<BeePredicate> codec() {
        return (MapCodec)ModRegistry.BEE_ENTITY_SUB_PREDICATE_TYPE.value();
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof Bee)) {
            return false;
        }
        Bee bee = (Bee)entity;
        if (this.angry.isPresent() && bee.isAngry() != this.angry.get().booleanValue()) {
            return false;
        }
        return !this.nectar.isPresent() || bee.hasNectar() == this.nectar.get().booleanValue();
    }

    public static BeePredicate isAngry() {
        return new BeePredicate(Optional.of(true), Optional.empty());
    }

    public static BeePredicate hasNectar() {
        return new BeePredicate(Optional.empty(), Optional.of(true));
    }
}

