/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.alltheheads.init.ModRegistry;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.coppergolem.CopperGolem;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record CopperGolemPredicate(Optional<WeatheringCopper.WeatherState> state) implements EntitySubPredicate
{
    public static final MapCodec<CopperGolemPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WeatheringCopper.WeatherState.CODEC.optionalFieldOf("state").forGetter(CopperGolemPredicate::state)).apply((Applicative)instance, CopperGolemPredicate::new));

    public MapCodec<CopperGolemPredicate> codec() {
        return (MapCodec)ModRegistry.COPPER_GOLEM_ENTITY_SUB_PREDICATE_TYPE.value();
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof CopperGolem)) {
            return false;
        }
        CopperGolem copperGolem = (CopperGolem)entity;
        return !this.state.isPresent() || copperGolem.getWeatherState() == this.state.get();
    }

    public static CopperGolemPredicate hasState(WeatheringCopper.WeatherState state) {
        return new CopperGolemPredicate(Optional.of(state));
    }
}

