/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.alltheheads.init.ModRegistry;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record TropicalFishPredicate(Optional<TropicalFish.Pattern> pattern, Optional<DyeColor> baseColor, Optional<DyeColor> patternColor) implements EntitySubPredicate
{
    public static final MapCodec<TropicalFishPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TropicalFish.Pattern.CODEC.optionalFieldOf("pattern").forGetter(TropicalFishPredicate::pattern), (App)DyeColor.CODEC.optionalFieldOf("base_color").forGetter(TropicalFishPredicate::baseColor), (App)DyeColor.CODEC.optionalFieldOf("pattern_color").forGetter(TropicalFishPredicate::patternColor)).apply((Applicative)instance, TropicalFishPredicate::new));

    public MapCodec<TropicalFishPredicate> codec() {
        return (MapCodec)ModRegistry.TROPICAL_FISH_ENTITY_SUB_PREDICATE_TYPE.value();
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof TropicalFish)) {
            return false;
        }
        TropicalFish tropicalFish = (TropicalFish)entity;
        if (this.pattern.isPresent() && tropicalFish.getPattern() != this.pattern.get()) {
            return false;
        }
        if (this.baseColor.isPresent() && tropicalFish.getBaseColor() != this.baseColor.get()) {
            return false;
        }
        return !this.patternColor.isPresent() || tropicalFish.getPatternColor() == this.patternColor.get();
    }

    public static TropicalFishPredicate hasVariant(TropicalFish.Variant variant) {
        return TropicalFishPredicate.hasVariant(variant.pattern(), variant.baseColor(), variant.patternColor());
    }

    public static TropicalFishPredicate hasVariant(TropicalFish.Pattern pattern, DyeColor baseColor, DyeColor patternColor) {
        return new TropicalFishPredicate(Optional.of(pattern), Optional.of(baseColor), Optional.of(patternColor));
    }
}

