/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.alltheheads.init.ModRegistry;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record VillagerDataPredicate(Optional<Holder<VillagerType>> type, Optional<Holder<VillagerProfession>> profession, Optional<Integer> level) implements EntitySubPredicate
{
    public static final MapCodec<VillagerDataPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.VILLAGER_TYPE.holderByNameCodec().optionalFieldOf("villager_type").forGetter(VillagerDataPredicate::type), (App)BuiltInRegistries.VILLAGER_PROFESSION.holderByNameCodec().optionalFieldOf("villager_profession").forGetter(VillagerDataPredicate::profession), (App)Codec.intRange((int)1, (int)5).optionalFieldOf("level").forGetter(VillagerDataPredicate::level)).apply((Applicative)instance, VillagerDataPredicate::new));

    public MapCodec<VillagerDataPredicate> codec() {
        return (MapCodec)ModRegistry.VILLAGER_DATA_ENTITY_SUB_PREDICATE_TYPE.value();
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof VillagerDataHolder)) {
            return false;
        }
        VillagerDataHolder dataHolder = (VillagerDataHolder)entity;
        if (this.type.isPresent() && !dataHolder.getVillagerData().type().is(this.type.get())) {
            return false;
        }
        if (this.profession.isPresent() && !dataHolder.getVillagerData().profession().is(this.profession.get())) {
            return false;
        }
        return !this.level.isPresent() || dataHolder.getVillagerData().level() == this.level.get().intValue();
    }

    public static VillagerDataPredicate hasData(Holder<VillagerType> type, Holder<VillagerProfession> profession) {
        return new VillagerDataPredicate(Optional.of(type), Optional.of(profession), Optional.empty());
    }
}

