/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.alltheheads.client.renderer.blockentity.state.MobHeadRenderState;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.Model;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.alltheheads.world.item.component.headtype.Shape;
import fuzs.alltheheads.world.level.block.entity.MobHeadBlockEntity;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.model.PiglinHeadModel;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.blockentity.state.SkullBlockRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MobHeadRenderer
extends SkullBlockRenderer {
    private static final List<Model> DEFAULT_MODELS = List.of(new Model((ModelAndTexture<ModelType>)new ModelAndTexture((Object)ModelType.DEFAULT, new ClientAsset.ResourceTexture(DefaultPlayerSkin.getDefaultTexture(), DefaultPlayerSkin.getDefaultTexture())), Optional.empty(), Optional.empty()));
    private static final Shape DEFAULT_SHAPE = new Shape(8.0, 8.0, 8.0);
    private static final Map<ModelType, Function<ModelPart, SkullModelBase>> SKULL_MODELS = Collections.unmodifiableMap((Map)Util.make(new IdentityHashMap(), map -> map.put(ModelType.PIGLIN, PiglinHeadModel::new)));
    private static final Map<ModelType, BiFunction<ResourceLocation, Float, RenderType>> RENDER_TYPES = Collections.unmodifiableMap((Map)Util.make(new IdentityHashMap(), map -> {
        MobHeadRenderer.putRenderType(ModelType.ALLAY, RenderType::entityTranslucent, map::put);
        MobHeadRenderer.putRenderType(ModelType.BAT, RenderType::entityCutout, map::put);
        MobHeadRenderer.putEyesRenderType(ModelType.BREEZE, ModelType.BREEZE_EYES, map::put);
        MobHeadRenderer.putEyesRenderType(ModelType.COPPER_GOLEM, ModelType.COPPER_GOLEM_EYES, map::put);
        MobHeadRenderer.putEyesRenderType(ModelType.CREAKING, ModelType.CREAKING_EYES, map::put);
        map.put(ModelType.CREEPER_CHARGE, (resourceLocation, tickCount) -> RenderType.energySwirl((ResourceLocation)resourceLocation, (float)(tickCount.floatValue() * 0.01f % 1.0f), (float)(tickCount.floatValue() * 0.01f % 1.0f)));
        MobHeadRenderer.putEyesRenderType(ModelType.ENDERMAN, ModelType.ENDERMAN_EYES, map::put);
        MobHeadRenderer.putRenderType(ModelType.HORSE, RenderType::entityCutoutNoCull, map::put);
        MobHeadRenderer.putRenderType(ModelType.HORSE_MARKINGS, RenderType::entityTranslucent, map::put);
        MobHeadRenderer.putEyesRenderType(ModelType.PHANTOM, ModelType.PHANTOM_EYES, map::put);
        MobHeadRenderer.putRenderType(ModelType.SLIME_GEL, RenderType::entityTranslucent, map::put);
        MobHeadRenderer.putEyesRenderType(ModelType.SPIDER, ModelType.SPIDER_EYES, map::put);
        MobHeadRenderer.putRenderType(ModelType.TROPICAL_FISH_LARGE, RenderType::entityCutoutNoCull, map::put);
        MobHeadRenderer.putRenderType(ModelType.TROPICAL_FISH_SMALL, RenderType::entityCutoutNoCull, map::put);
        MobHeadRenderer.putRenderType(ModelType.VEX, RenderType::entityTranslucent, map::put);
        map.put(ModelType.WITHER_SHIELD, (resourceLocation, tickCount) -> RenderType.energySwirl((ResourceLocation)resourceLocation, (float)(Mth.cos((float)(tickCount.floatValue() * 0.02f)) * 3.0f % 1.0f), (float)(tickCount.floatValue() * 0.01f % 1.0f)));
    }));
    private final Function<ModelType, SkullModelBase> skullModelGetter;

    public MobHeadRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.skullModelGetter = MobHeadRenderer.createSkullModels(context.entityModelSet());
    }

    private static void putEyesRenderType(ModelType modelType, ModelType eyesModelType, BiConsumer<ModelType, BiFunction<ResourceLocation, Float, RenderType>> consumer) {
        MobHeadRenderer.putRenderType(modelType, RenderType::entityCutoutNoCull, consumer);
        MobHeadRenderer.putRenderType(eyesModelType, RenderType::eyes, consumer);
    }

    private static void putRenderType(ModelType modelType, Function<ResourceLocation, RenderType> renderTypeGetter, BiConsumer<ModelType, BiFunction<ResourceLocation, Float, RenderType>> consumer) {
        consumer.accept(modelType, (resourceLocation, tickCount) -> (RenderType)renderTypeGetter.apply((ResourceLocation)resourceLocation));
    }

    public static Function<ModelType, SkullModelBase> createSkullModels(EntityModelSet entityModelSet) {
        return Util.memoize(modelType -> {
            Function<ModelPart, SkullModelBase> skullModelGetter = SKULL_MODELS.getOrDefault(modelType, SkullModel::new);
            ModelLayerLocation modelLayerLocation = MobHeadRenderer.createModelLayer(modelType);
            ModelPart modelPart = entityModelSet.bakeLayer(modelLayerLocation);
            return skullModelGetter.apply(modelPart);
        });
    }

    public static ModelLayerLocation createModelLayer(ModelType modelType) {
        return new ModelLayerLocation(modelType.model(), modelType.layer());
    }

    public MobHeadRenderState createRenderState() {
        return new MobHeadRenderState();
    }

    public void extractRenderState(SkullBlockEntity blockEntity, SkullBlockRenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPosition, breakProgress);
        ((MobHeadRenderState)renderState).headType = ((MobHeadBlockEntity)blockEntity).getHeadType();
        ((MobHeadRenderState)renderState).time = (float)((MobHeadBlockEntity)blockEntity).tickCount + partialTick;
    }

    public void submit(SkullBlockRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        MobHeadRenderer.submitSkull((MobHeadRenderState)renderState, poseStack, nodeCollector, this.skullModelGetter);
    }

    public static void submitSkull(MobHeadRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, Function<ModelType, SkullModelBase> skullModelGetter) {
        Shape shape = MobHeadRenderer.getShape(renderState.headType);
        for (Model model : MobHeadRenderer.getModels(renderState.headType)) {
            SkullModelBase skullModelBase = skullModelGetter.apply((ModelType)model.model().model());
            RenderType renderType = MobHeadRenderer.getRenderType(model.model(), renderState.time);
            MobHeadRenderer.submitSkull(renderState, poseStack, nodeCollector, skullModelBase, renderType, model.blockLight().map(blockLight -> LightTexture.pack((int)blockLight, (int)LightTexture.sky((int)renderState.lightCoords))).orElse(renderState.lightCoords), model.color().map(tintColor -> tintColor.getColor(renderState.time)).orElse(-1), shape);
        }
    }

    private static void submitSkull(MobHeadRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, SkullModelBase model, RenderType renderType, int packedLight, int tintColor, Shape shape) {
        poseStack.pushPose();
        double offsetY = (16.0 - shape.sizeY()) / 2.0;
        if (renderState.direction != null) {
            double offsetX = 8.0 - (double)renderState.direction.getStepX() * (16.0 - shape.sizeX(renderState.direction)) / 2.0;
            double offsetZ = 8.0 - (double)renderState.direction.getStepZ() * (16.0 - shape.sizeZ(renderState.direction)) / 2.0;
            poseStack.translate(offsetX / 16.0, offsetY / 16.0, offsetZ / 16.0);
        } else {
            poseStack.translate(0.5f, renderState.guiOffset ? ((float)offsetY - 3.3333333f) / 16.0f : 0.0f, 0.5f);
        }
        poseStack.scale((float)(-shape.scale()), (float)(-shape.scale()), (float)shape.scale());
        SkullModelBase.State state = new SkullModelBase.State();
        state.animationPos = renderState.animationProgress;
        state.yRot = renderState.rotationDegrees;
        nodeCollector.submitModel((net.minecraft.client.model.Model)model, (Object)state, poseStack, renderType, packedLight, OverlayTexture.NO_OVERLAY, tintColor, null, renderState.outlineColor, renderState.breakProgress);
        poseStack.popPose();
    }

    private static List<Model> getModels(Holder<HeadType> headType) {
        return headType != null ? ((HeadType)headType.value()).models() : DEFAULT_MODELS;
    }

    private static Shape getShape(Holder<HeadType> headType) {
        return headType != null ? ((HeadType)headType.value()).shape() : DEFAULT_SHAPE;
    }

    private static RenderType getRenderType(ModelAndTexture<ModelType> modelAndTexture, float tickCount) {
        BiFunction<ResourceLocation, Float, RenderType> renderTypeGetter = RENDER_TYPES.getOrDefault(modelAndTexture.model(), (resourceLocation, tickCountX) -> RenderType.entityCutoutNoCullZOffset((ResourceLocation)resourceLocation));
        return renderTypeGetter.apply(modelAndTexture.asset().texturePath(), Float.valueOf(tickCount));
    }
}

