/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.client.renderer.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.alltheheads.client.renderer.blockentity.MobHeadRenderer;
import fuzs.alltheheads.client.renderer.blockentity.state.MobHeadRenderState;
import fuzs.alltheheads.init.ModRegistry;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class MobHeadSpecialRenderer
implements SpecialModelRenderer<Holder<HeadType>> {
    private final Function<ModelType, SkullModelBase> skullModelGetter;
    private final float animation;

    public MobHeadSpecialRenderer(Function<ModelType, SkullModelBase> skullModelGetter, float animation) {
        this.skullModelGetter = skullModelGetter;
        this.animation = animation;
    }

    public void submit(@Nullable Holder<HeadType> headType, ItemDisplayContext displayContext, PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, int packedOverlay, boolean hasFoil, int outlineColor) {
        MobHeadRenderState mobHeadRenderState = MobHeadRenderState.create(packedLight, 180.0f, this.animation, headType, 0.0f, outlineColor, true);
        MobHeadRenderer.submitSkull(mobHeadRenderState, poseStack, nodeCollector, this.skullModelGetter);
    }

    public void getExtents(Set<Vector3f> output) {
        PoseStack poseStack = new PoseStack();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        SkullModelBase skullModelBase = this.skullModelGetter.apply(ModelType.DEFAULT);
        SkullModelBase.State state = new SkullModelBase.State();
        state.animationPos = this.animation;
        state.yRot = 180.0f;
        skullModelBase.setupAnim((Object)state);
        skullModelBase.root().getExtentsForGui(poseStack, output);
    }

    @Nullable
    public Holder<HeadType> extractArgument(ItemStack itemStack) {
        return (Holder)itemStack.get((DataComponentType)ModRegistry.HEAD_TYPE_DATA_COMPONENT_TYPE.value());
    }

    public record Unbaked(float animation) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("animation", (Object)Float.valueOf(0.0f)).forGetter(Unbaked::animation)).apply((Applicative)instance, Unbaked::new));

        public Unbaked() {
            this(0.0f);
        }

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }

        public SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext context) {
            return new MobHeadSpecialRenderer(MobHeadRenderer.createSkullModels(context.entityModelSet()), this.animation);
        }
    }
}

