/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.init;

import fuzs.alltheheads.AllTheHeads;
import fuzs.alltheheads.config.CommonConfig;
import fuzs.alltheheads.init.ModRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ModLootTables {
    private static final Map<ResourceLocation, ResourceKey<LootTable>> LOOT_TABLE_INJECTIONS = new HashMap<ResourceLocation, ResourceKey<LootTable>>();
    public static final ResourceKey<LootTable> ZOMBIE_INJECTION = ModLootTables.registerLootTableInjection(EntityType.ZOMBIE);
    public static final ResourceKey<LootTable> SKELETON_INJECTION = ModLootTables.registerLootTableInjection(EntityType.SKELETON);
    public static final ResourceKey<LootTable> CREEPER_INJECTION = ModLootTables.registerLootTableInjection(EntityType.CREEPER);
    public static final ResourceKey<LootTable> PIGLIN_INJECTION = ModLootTables.registerLootTableInjection(EntityType.PIGLIN);
    public static final ResourceKey<LootTable> ENDER_DRAGON_INJECTION = ModLootTables.registerLootTableInjection(EntityType.ENDER_DRAGON);

    public static void bootstrap() {
    }

    private static ResourceKey<LootTable> registerLootTableInjection(EntityType<?> entityType) {
        return ModLootTables.registerLootTableInjection((ResourceKey<LootTable>)((ResourceKey)entityType.getDefaultLootTable().orElseThrow()));
    }

    private static ResourceKey<LootTable> registerLootTableInjection(ResourceKey<LootTable> resourceKey) {
        ResourceKey newResourceKey = ModRegistry.REGISTRIES.makeResourceKey(Registries.LOOT_TABLE, "injections/" + resourceKey.location().toString().replace(':', '/'));
        LOOT_TABLE_INJECTIONS.put(resourceKey.location(), (ResourceKey<LootTable>)newResourceKey);
        return newResourceKey;
    }

    public static void onLootTableLoad(ResourceLocation resourceLocation, LootTable.Builder lootTable, HolderLookup.Provider registries) {
        if (!((CommonConfig)AllTheHeads.CONFIG.get(CommonConfig.class)).vanillaHeadDrops) {
            return;
        }
        if (LOOT_TABLE_INJECTIONS.containsKey(resourceLocation)) {
            lootTable.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(LOOT_TABLE_INJECTIONS.get(resourceLocation))));
        }
    }
}

