/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.init.headtype;

import fuzs.alltheheads.init.HeadTypes;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.ChickenVariants;
import net.minecraft.world.item.EitherHolder;

public class ChickenHeadType {
    public static final ResourceKey<HeadType> TEMPERATE_CHICKEN = HeadTypes.register("chicken/temperate");
    public static final ResourceKey<HeadType> WARM_CHICKEN = HeadTypes.register("chicken/warm");
    public static final ResourceKey<HeadType> COLD_CHICKEN = HeadTypes.register("chicken/cold");

    public static void bootstrap(BootstrapContext<HeadType> context) {
        ChickenHeadType.bootstrapChicken(context, (ResourceKey<ChickenVariant>)ChickenVariants.TEMPERATE, TEMPERATE_CHICKEN, ModelType.CHICKEN, "entity/chicken/temperate_chicken");
        ChickenHeadType.bootstrapChicken(context, (ResourceKey<ChickenVariant>)ChickenVariants.WARM, WARM_CHICKEN, ModelType.CHICKEN, "entity/chicken/warm_chicken");
        ChickenHeadType.bootstrapChicken(context, (ResourceKey<ChickenVariant>)ChickenVariants.COLD, COLD_CHICKEN, ModelType.COLD_CHICKEN, "entity/chicken/cold_chicken");
    }

    private static void bootstrapChicken(BootstrapContext<HeadType> context, ResourceKey<ChickenVariant> variant, ResourceKey<HeadType> resourceKey, ModelType modelType, String textureLocation) {
        HeadType.builder(EntityType.CHICKEN).entityPredicate(builder -> builder.components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect((DataComponentType)DataComponents.CHICKEN_VARIANT, (Object)new EitherHolder((Holder)context.lookup(Registries.CHICKEN_VARIANT).getOrThrow(variant)))).build())).shape(4.0, 6.0, 3.0).scale(1.5).model(modelType, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).noteBlockSound(SoundEvents.CHICKEN_AMBIENT).build(context, resourceKey);
    }

    public static void registerTranslations(BiConsumer<ResourceKey<HeadType>, String> translationConsumer) {
        translationConsumer.accept(TEMPERATE_CHICKEN, "Temperate Chicken Head");
        translationConsumer.accept(WARM_CHICKEN, "Warm Chicken Head");
        translationConsumer.accept(COLD_CHICKEN, "Cold Chicken Head");
    }
}

