/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.init.headtype;

import fuzs.alltheheads.init.HeadTypes;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Fox;

public class FoxHeadType {
    public static final ResourceKey<HeadType> FOX = HeadTypes.register("fox");
    public static final ResourceKey<HeadType> SNOW_FOX = HeadTypes.register("fox/snow");

    public static void bootstrap(BootstrapContext<HeadType> context) {
        FoxHeadType.bootstrapFox(context, Fox.Variant.RED, FOX, "entity/fox/fox");
        FoxHeadType.bootstrapFox(context, Fox.Variant.SNOW, SNOW_FOX, "entity/fox/snow_fox");
    }

    private static void bootstrapFox(BootstrapContext<HeadType> context, Fox.Variant variant, ResourceKey<HeadType> resourceKey, String textureLocation) {
        HeadType.builder(EntityType.FOX).entityPredicate(builder -> builder.components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect((DataComponentType)DataComponents.FOX_VARIANT, (Object)variant)).build())).shape(8.0, 6.0, 6.0).model(ModelType.FOX, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).noteBlockSound(SoundEvents.FOX_AMBIENT).build(context, resourceKey);
    }

    public static void registerTranslations(BiConsumer<ResourceKey<HeadType>, String> translationConsumer) {
        translationConsumer.accept(FOX, "Fox Head");
        translationConsumer.accept(SNOW_FOX, "Snow Fox Head");
    }
}

