/*
 * Decompiled with CFR 0.152.
 */
package com.wzz.unparalleled;

import com.wzz.unparalleled.SkinManagerMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AfterImageData {
    private final Vec3 position;
    private final float yRot;
    private final float xRot;
    private final long createTime;
    private final String playerUUID;
    private final int maxLifetime = 40;
    private int age = 0;
    public ItemStack mainHandItem;
    public ItemStack offHandItem;
    public ItemStack helmet;
    public ItemStack chestplate;
    public ItemStack leggings;
    public ItemStack boots;
    public HumanoidModel.ArmPose leftArmPose;
    public HumanoidModel.ArmPose rightArmPose;
    private ModelPoseData poseData;
    private ResourceLocation skinTexture;
    private boolean slimModel;

    public AfterImageData(Player player) {
        this.position = player.m_20182_();
        this.yRot = player.m_146908_();
        this.xRot = player.m_146909_();
        this.createTime = System.currentTimeMillis();
        this.playerUUID = player.m_20149_();
        this.mainHandItem = player.m_21205_().m_41777_();
        this.offHandItem = player.m_21206_().m_41777_();
        this.helmet = player.m_150109_().m_36052_(3).m_41777_();
        this.chestplate = player.m_150109_().m_36052_(2).m_41777_();
        this.leggings = player.m_150109_().m_36052_(1).m_41777_();
        this.boots = player.m_150109_().m_36052_(0).m_41777_();
        if (player instanceof AbstractClientPlayer) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)player;
            PlayerRenderer renderer = (PlayerRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)clientPlayer);
            PlayerModel model = (PlayerModel)renderer.m_7200_();
            this.leftArmPose = model.f_102815_;
            this.rightArmPose = model.f_102816_;
        } else {
            this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
            this.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        }
        this.poseData = this.copyPlayerPose(player);
        this.skinTexture = SkinManagerMod.getPlayerSkin(player);
        this.slimModel = SkinManagerMod.isSlimModel(player);
    }

    public ItemStack getMainHandItem() {
        return this.mainHandItem;
    }

    public ItemStack getOffHandItem() {
        return this.offHandItem;
    }

    public ItemStack getHelmet() {
        return this.helmet;
    }

    public ItemStack getChestplate() {
        return this.chestplate;
    }

    public ItemStack getLeggings() {
        return this.leggings;
    }

    public ItemStack getBoots() {
        return this.boots;
    }

    public HumanoidModel.ArmPose getLeftArmPose() {
        return this.leftArmPose;
    }

    public HumanoidModel.ArmPose getRightArmPose() {
        return this.rightArmPose;
    }

    public String getPlayerUUID() {
        return this.playerUUID;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getXRot() {
        return this.xRot;
    }

    public void tick() {
        ++this.age;
    }

    public boolean isExpired() {
        return this.age >= 40;
    }

    public float getAlpha() {
        return Math.max(0.0f, 0.8f * (1.0f - (float)this.age / 40.0f));
    }

    private ModelPoseData copyPlayerPose(Player player) {
        ModelPoseData pose = new ModelPoseData();
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher dispatcher = mc.m_91290_();
        EntityRenderer renderer = dispatcher.m_114382_((Entity)player);
        if (renderer instanceof PlayerRenderer) {
            PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
            PlayerModel model = (PlayerModel)playerRenderer.m_7200_();
            ModelPart head = model.f_102808_;
            pose.headXRot = head.f_104203_;
            pose.headYRot = head.f_104204_;
            pose.headZRot = head.f_104205_;
            ModelPart body = model.f_102810_;
            pose.bodyXRot = body.f_104203_;
            pose.bodyYRot = body.f_104204_;
            pose.bodyZRot = body.f_104205_;
            ModelPart leftArm = model.f_102812_;
            pose.leftArmXRot = leftArm.f_104203_;
            pose.leftArmYRot = leftArm.f_104204_;
            pose.leftArmZRot = leftArm.f_104205_;
            pose.leftArmX = leftArm.f_104200_;
            pose.leftArmY = leftArm.f_104201_;
            pose.leftArmZ = leftArm.f_104202_;
            ModelPart rightArm = model.f_102811_;
            pose.rightArmXRot = rightArm.f_104203_;
            pose.rightArmYRot = rightArm.f_104204_;
            pose.rightArmZRot = rightArm.f_104205_;
            pose.rightArmX = rightArm.f_104200_;
            pose.rightArmY = rightArm.f_104201_;
            pose.rightArmZ = rightArm.f_104202_;
            ModelPart leftLeg = model.f_102814_;
            pose.leftLegXRot = leftLeg.f_104203_;
            pose.leftLegYRot = leftLeg.f_104204_;
            pose.leftLegZRot = leftLeg.f_104205_;
            pose.leftLegX = leftLeg.f_104200_;
            pose.leftLegY = leftLeg.f_104201_;
            pose.leftLegZ = leftLeg.f_104202_;
            ModelPart rightLeg = model.f_102813_;
            pose.rightLegXRot = rightLeg.f_104203_;
            pose.rightLegYRot = rightLeg.f_104204_;
            pose.rightLegZRot = rightLeg.f_104205_;
            pose.rightLegX = rightLeg.f_104200_;
            pose.rightLegY = rightLeg.f_104201_;
            pose.rightLegZ = rightLeg.f_104202_;
            pose.swimAmount = model.f_102818_;
            pose.crouching = model.f_102817_;
            pose.sleeping = player.m_5803_();
        }
        return pose;
    }

    public ResourceLocation getSkinTexture() {
        return this.skinTexture;
    }

    public boolean isSlimModel() {
        return this.slimModel;
    }

    public void applyPoseToModel(PlayerModel<AbstractClientPlayer> model) {
        if (this.poseData == null) {
            return;
        }
        model.f_102808_.f_104203_ = this.poseData.headXRot;
        model.f_102808_.f_104204_ = this.poseData.headYRot;
        model.f_102808_.f_104205_ = this.poseData.headZRot;
        model.f_102810_.f_104203_ = this.poseData.bodyXRot;
        model.f_102810_.f_104204_ = this.poseData.bodyYRot;
        model.f_102810_.f_104205_ = this.poseData.bodyZRot;
        model.f_102812_.f_104203_ = this.poseData.leftArmXRot;
        model.f_102812_.f_104204_ = this.poseData.leftArmYRot;
        model.f_102812_.f_104205_ = this.poseData.leftArmZRot;
        model.f_102812_.f_104200_ = this.poseData.leftArmX;
        model.f_102812_.f_104201_ = this.poseData.leftArmY;
        model.f_102812_.f_104202_ = this.poseData.leftArmZ;
        model.f_102811_.f_104203_ = this.poseData.rightArmXRot;
        model.f_102811_.f_104204_ = this.poseData.rightArmYRot;
        model.f_102811_.f_104205_ = this.poseData.rightArmZRot;
        model.f_102811_.f_104200_ = this.poseData.rightArmX;
        model.f_102811_.f_104201_ = this.poseData.rightArmY;
        model.f_102811_.f_104202_ = this.poseData.rightArmZ;
        model.f_102814_.f_104203_ = this.poseData.leftLegXRot;
        model.f_102814_.f_104204_ = this.poseData.leftLegYRot;
        model.f_102814_.f_104205_ = this.poseData.leftLegZRot;
        model.f_102814_.f_104200_ = this.poseData.leftLegX;
        model.f_102814_.f_104201_ = this.poseData.leftLegY;
        model.f_102814_.f_104202_ = this.poseData.leftLegZ;
        model.f_102813_.f_104203_ = this.poseData.rightLegXRot;
        model.f_102813_.f_104204_ = this.poseData.rightLegYRot;
        model.f_102813_.f_104205_ = this.poseData.rightLegZRot;
        model.f_102813_.f_104200_ = this.poseData.rightLegX;
        model.f_102813_.f_104201_ = this.poseData.rightLegY;
        model.f_102813_.f_104202_ = this.poseData.rightLegZ;
        model.f_102818_ = this.poseData.swimAmount;
        model.f_102817_ = this.poseData.crouching;
    }

    public static class ModelPoseData {
        public float headXRot;
        public float headYRot;
        public float headZRot;
        public float bodyXRot;
        public float bodyYRot;
        public float bodyZRot;
        public float leftArmXRot;
        public float leftArmYRot;
        public float leftArmZRot;
        public float rightArmXRot;
        public float rightArmYRot;
        public float rightArmZRot;
        public float leftLegXRot;
        public float leftLegYRot;
        public float leftLegZRot;
        public float rightLegXRot;
        public float rightLegYRot;
        public float rightLegZRot;
        public float leftArmX;
        public float leftArmY;
        public float leftArmZ;
        public float rightArmX;
        public float rightArmY;
        public float rightArmZ;
        public float leftLegX;
        public float leftLegY;
        public float leftLegZ;
        public float rightLegX;
        public float rightLegY;
        public float rightLegZ;
        public float swimAmount;
        public boolean crouching;
        public boolean sleeping;
    }
}

