/*
 * Decompiled with CFR 0.152.
 */
package com.wzz.unparalleled;

import com.wzz.unparalleled.AfterImageData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AfterImageManager {
    private static final List<AfterImageData> afterImages = new ArrayList<AfterImageData>();
    private static final Map<String, Vec3> lastPlayerPositions = new HashMap<String, Vec3>();
    private static final int MAX_AFTER_IMAGES = 10;
    private static final double MIN_DISTANCE = 0.2;

    public static void tick() {
        afterImages.forEach(AfterImageData::tick);
        afterImages.removeIf(AfterImageData::isExpired);
        AfterImageManager.checkPlayerMovement();
    }

    private static void checkPlayerMovement() {
        double distance;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer == null) {
            return;
        }
        String uuid = localPlayer.m_20149_();
        Vec3 currentPos = localPlayer.m_20182_();
        Vec3 lastPos = lastPlayerPositions.get(uuid);
        if (lastPos != null && (distance = currentPos.m_82554_(lastPos)) > 0.2 && localPlayer.m_20184_().m_82553_() > 0.2) {
            AfterImageManager.createAfterImage((Player)localPlayer);
        }
        lastPlayerPositions.put(uuid, currentPos);
    }

    public static void createAfterImage(Player player) {
        if (afterImages.size() >= 10) {
            afterImages.remove(0);
        }
        afterImages.add(new AfterImageData(player));
    }

    public static List<AfterImageData> getAfterImages() {
        return afterImages;
    }

    public static void clear() {
        afterImages.clear();
        lastPlayerPositions.clear();
    }
}

