/*
 * Decompiled with CFR 0.152.
 */
package com.wzz.unparalleled;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.wzz.unparalleled.AfterImageData;
import com.wzz.unparalleled.AfterImageManager;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AfterImageRenderer {
    private static PlayerRenderer playerRenderer;

    public static void renderAfterImages(PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, float partialTick) {
        if (playerRenderer == null) {
            Minecraft mc = Minecraft.m_91087_();
            EntityRendererProvider.Context context = new EntityRendererProvider.Context(mc.m_91290_(), mc.m_91291_(), mc.m_91289_(), mc.f_91063_.f_109055_, mc.m_91098_(), mc.m_167973_(), mc.f_91062_);
            playerRenderer = new PlayerRenderer(context, false);
        }
        Vec3 cameraPos = camera.m_90583_();
        for (AfterImageData afterImage : AfterImageManager.getAfterImages()) {
            AfterImageRenderer.renderSingleAfterImage(poseStack, bufferSource, afterImage, cameraPos, partialTick);
        }
    }

    private static void renderSingleAfterImage(PoseStack poseStack, MultiBufferSource bufferSource, AfterImageData afterImage, Vec3 cameraPos, float partialTick) {
        poseStack.m_85836_();
        Vec3 originalPos = afterImage.getPosition();
        float yRot = afterImage.getYRot();
        Vec3 backwardPos = AfterImageRenderer.calculateBackwardPosition(originalPos, yRot, 1.0);
        poseStack.m_85837_(backwardPos.f_82479_ - cameraPos.f_82479_, backwardPos.f_82480_ - cameraPos.f_82480_, backwardPos.f_82481_ - cameraPos.f_82481_);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-yRot + 180.0f));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_85837_(0.0, (double)-1.501f, 0.0);
        AfterImageRenderer.renderTransparentPlayerModel(poseStack, bufferSource, afterImage);
        poseStack.m_85849_();
    }

    private static void renderTransparentPlayerModel(PoseStack poseStack, MultiBufferSource bufferSource, AfterImageData afterImage) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        Player originalPlayer = level.m_46003_(UUID.fromString(afterImage.getPlayerUUID()));
        if (originalPlayer instanceof AbstractClientPlayer) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)originalPlayer;
            PlayerRenderer playerRenderer = (PlayerRenderer)mc.m_91290_().m_114382_((Entity)clientPlayer);
            PlayerModel model = (PlayerModel)playerRenderer.m_7200_();
            afterImage.applyPoseToModel((PlayerModel<AbstractClientPlayer>)model);
            ResourceLocation skinTexture = afterImage.getSkinTexture();
            RenderType renderType = RenderType.m_110470_((ResourceLocation)skinTexture);
            VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
            model.f_102815_ = afterImage.getLeftArmPose();
            model.f_102816_ = afterImage.getRightArmPose();
            float alpha = afterImage.getAlpha();
            model.m_7695_(poseStack, vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
            AfterImageRenderer.renderPlayerSkin(poseStack, bufferSource, (PlayerModel<AbstractClientPlayer>)model, afterImage, alpha);
            AfterImageRenderer.renderPlayerArmor(poseStack, bufferSource, (PlayerModel<AbstractClientPlayer>)model, afterImage, alpha);
            AfterImageRenderer.renderHeldItems(poseStack, bufferSource, (PlayerModel<AbstractClientPlayer>)model, afterImage, alpha);
            AfterImageRenderer.renderPlayerLayers(poseStack, bufferSource, (PlayerModel<AbstractClientPlayer>)model, afterImage.getSkinTexture(), alpha, 0xF000F0, OverlayTexture.f_118083_);
        }
    }

    private static Vec3 calculateBackwardPosition(Vec3 originalPos, float yRotationDegrees, double distance) {
        double yRotRad = Math.toRadians(yRotationDegrees);
        double facingX = -Math.sin(yRotRad);
        double facingZ = Math.cos(yRotRad);
        double backwardX = originalPos.f_82479_ - facingX * distance;
        double backwardZ = originalPos.f_82481_ - facingZ * distance;
        return new Vec3(backwardX, originalPos.f_82480_, backwardZ);
    }

    private static void renderPlayerSkin(PoseStack poseStack, MultiBufferSource bufferSource, PlayerModel<AbstractClientPlayer> model, AfterImageData afterImage, float alpha) {
        ResourceLocation skinTexture = afterImage.getSkinTexture();
        RenderType renderType = RenderType.m_110470_((ResourceLocation)skinTexture);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
        model.m_7695_(poseStack, vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
    }

    private static void renderPlayerLayers(PoseStack poseStack, MultiBufferSource bufferSource, PlayerModel<AbstractClientPlayer> model, ResourceLocation skinTexture, float alpha, int packedLight, int packedOverlay) {
        RenderType hatRenderType = RenderType.m_110470_((ResourceLocation)skinTexture);
        VertexConsumer hatConsumer = bufferSource.m_6299_(hatRenderType);
        model.f_102809_.m_104306_(poseStack, hatConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, alpha * 0.8f);
        model.f_103378_.m_104306_(poseStack, hatConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, alpha * 0.8f);
        model.f_103374_.m_104306_(poseStack, hatConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, alpha * 0.8f);
        model.f_103375_.m_104306_(poseStack, hatConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, alpha * 0.8f);
        model.f_103376_.m_104306_(poseStack, hatConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, alpha * 0.8f);
        model.f_103377_.m_104306_(poseStack, hatConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, alpha * 0.8f);
    }

    private static void renderPlayerArmor(PoseStack poseStack, MultiBufferSource bufferSource, PlayerModel<AbstractClientPlayer> model, AfterImageData afterImage, float alpha) {
        Minecraft mc = Minecraft.m_91087_();
        EntityModelSet entityModels = mc.m_167973_();
        AfterImageRenderer.renderArmorPiece(poseStack, bufferSource, entityModels, model, afterImage.getHelmet(), EquipmentSlot.HEAD, alpha);
        AfterImageRenderer.renderArmorPiece(poseStack, bufferSource, entityModels, model, afterImage.getChestplate(), EquipmentSlot.CHEST, alpha);
        AfterImageRenderer.renderArmorPiece(poseStack, bufferSource, entityModels, model, afterImage.getLeggings(), EquipmentSlot.LEGS, alpha);
        AfterImageRenderer.renderArmorPiece(poseStack, bufferSource, entityModels, model, afterImage.getBoots(), EquipmentSlot.FEET, alpha);
    }

    private static ResourceLocation getArmorTextureSimple(ArmorMaterial material, EquipmentSlot slot, ItemStack stack) {
        String layer;
        String materialName;
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem) {
            String type;
            String customTexture;
            ArmorItem armorItem = (ArmorItem)item;
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer entity = mc.f_91074_;
            if (entity != null && (customTexture = armorItem.getArmorTexture(stack, (Entity)entity, slot, type = slot == EquipmentSlot.LEGS ? "layer_2" : "layer_1")) != null && !customTexture.isEmpty()) {
                return new ResourceLocation(customTexture);
            }
        }
        String cleanMaterialName = (materialName = material.m_6082_()).contains(":") ? materialName.substring(materialName.indexOf(":") + 1) : materialName;
        String string = layer = slot == EquipmentSlot.LEGS ? "layer_2" : "layer_1";
        if ("gem_armor".contains(cleanMaterialName)) {
            return new ResourceLocation("projecte", "textures/models/armor/gem_armor_" + layer + ".png");
        }
        return new ResourceLocation("textures/models/armor/" + cleanMaterialName + "_" + layer + ".png");
    }

    private static void renderArmorPiece(PoseStack poseStack, MultiBufferSource bufferSource, EntityModelSet entityModels, PlayerModel<AbstractClientPlayer> playerModel, ItemStack armorStack, EquipmentSlot slot, float alpha) {
        if (armorStack.m_41619_()) {
            return;
        }
        Item item = armorStack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem armorItem = (ArmorItem)item;
        ArmorMaterial armorMaterial = armorItem.m_40401_();
        ResourceLocation armorTexture = AfterImageRenderer.getArmorTextureSimple(armorMaterial, slot, armorStack);
        HumanoidModel<LivingEntity> armorModel = AfterImageRenderer.getArmorModel(entityModels, slot, armorStack);
        if (armorModel == null) {
            return;
        }
        AfterImageRenderer.copyHumanoidProps(playerModel, armorModel);
        armorModel.m_8009_(false);
        switch (slot) {
            case HEAD: {
                armorModel.f_102808_.f_104207_ = true;
                break;
            }
            case CHEST: {
                armorModel.f_102810_.f_104207_ = true;
                armorModel.f_102811_.f_104207_ = true;
                armorModel.f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                armorModel.f_102810_.f_104207_ = true;
                armorModel.f_102813_.f_104207_ = true;
                armorModel.f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                armorModel.f_102813_.f_104207_ = true;
                armorModel.f_102814_.f_104207_ = true;
            }
        }
        RenderType renderType = RenderType.m_110470_((ResourceLocation)armorTexture);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
        armorModel.m_7695_(poseStack, vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha * 0.9f);
    }

    public static void copyHumanoidProps(HumanoidModel<?> from, HumanoidModel<?> to) {
        from.m_102624_(to);
        to.f_102815_ = from.f_102815_;
        to.f_102816_ = from.f_102816_;
        to.f_102817_ = from.f_102817_;
        to.f_102808_.m_104315_(from.f_102808_);
        to.f_102809_.m_104315_(from.f_102809_);
        to.f_102810_.m_104315_(from.f_102810_);
        to.f_102811_.m_104315_(from.f_102811_);
        to.f_102812_.m_104315_(from.f_102812_);
        to.f_102813_.m_104315_(from.f_102813_);
        to.f_102814_.m_104315_(from.f_102814_);
    }

    private static HumanoidModel<LivingEntity> getArmorModel(EntityModelSet entityModels, EquipmentSlot slot, ItemStack armorStack) {
        boolean innerArmor = slot == EquipmentSlot.LEGS;
        ModelLayerLocation modelLayer = innerArmor ? ModelLayers.f_171164_ : ModelLayers.f_171165_;
        return new HumanoidModel(entityModels.m_171103_(modelLayer));
    }

    private static void renderHeldItems(PoseStack poseStack, MultiBufferSource bufferSource, PlayerModel<AbstractClientPlayer> model, AfterImageData afterImage, float alpha) {
        poseStack.m_85836_();
        if (!afterImage.getMainHandItem().m_41619_()) {
            poseStack.m_85836_();
            model.f_102811_.m_104299_(poseStack);
            poseStack.m_85837_(-0.0625, 0.4375, 0.0625);
            AfterImageRenderer.adjustItemForArmPose(poseStack, afterImage.getRightArmPose(), true);
            AfterImageRenderer.renderItemWithAlpha(poseStack, bufferSource, afterImage.getMainHandItem(), alpha);
            poseStack.m_85849_();
        }
        if (!afterImage.getOffHandItem().m_41619_()) {
            poseStack.m_85836_();
            model.f_102812_.m_104299_(poseStack);
            poseStack.m_85837_(0.0625, 0.4375, 0.0625);
            AfterImageRenderer.adjustItemForArmPose(poseStack, afterImage.getLeftArmPose(), false);
            AfterImageRenderer.renderItemWithAlpha(poseStack, bufferSource, afterImage.getOffHandItem(), alpha);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private static void adjustItemForArmPose(PoseStack poseStack, HumanoidModel.ArmPose armPose, boolean rightHand) {
        switch (armPose) {
            case ITEM: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                if (!rightHand) break;
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case BLOCK: {
                poseStack.m_85837_(rightHand ? -0.25 : 0.25, 0.1875, 0.0);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-20.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rightHand ? -60.0f : 60.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(rightHand ? -20.0f : 20.0f));
                break;
            }
            case BOW_AND_ARROW: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rightHand ? -60.0f : 60.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(rightHand ? -90.0f : 90.0f));
                break;
            }
            case CROSSBOW_CHARGE: 
            case CROSSBOW_HOLD: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(rightHand ? -60.0f : 60.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                break;
            }
            case SPYGLASS: {
                poseStack.m_85837_(rightHand ? -0.125 : 0.125, 0.125, 0.0);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-45.0f));
            }
        }
    }

    private static void renderItemWithAlpha(PoseStack poseStack, MultiBufferSource bufferSource, ItemStack itemStack, float alpha) {
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer itemRenderer = mc.m_91291_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        itemRenderer.m_269128_(itemStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, 0xF000F0, OverlayTexture.f_118083_, poseStack, bufferSource, (Level)mc.f_91073_, 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }
}

