/*
 * Decompiled with CFR 0.152.
 */
package com.wzz.unparalleled;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SkinManagerMod {
    private static final Map<String, ResourceLocation> skinCache = new ConcurrentHashMap<String, ResourceLocation>();
    private static final Map<String, Boolean> slimModelCache = new ConcurrentHashMap<String, Boolean>();

    public static ResourceLocation getPlayerSkin(Player player) {
        if (!(player instanceof AbstractClientPlayer)) {
            return DefaultPlayerSkin.m_118626_();
        }
        AbstractClientPlayer clientPlayer = (AbstractClientPlayer)player;
        String uuid = player.m_20149_();
        if (skinCache.containsKey(uuid)) {
            return skinCache.get(uuid);
        }
        ResourceLocation skinLocation = clientPlayer.m_108560_();
        skinCache.put(uuid, skinLocation);
        return skinLocation;
    }

    public static boolean isSlimModel(Player player) {
        if (!(player instanceof AbstractClientPlayer)) {
            return false;
        }
        AbstractClientPlayer clientPlayer = (AbstractClientPlayer)player;
        String uuid = player.m_20149_();
        if (slimModelCache.containsKey(uuid)) {
            return slimModelCache.get(uuid);
        }
        String skinModel = clientPlayer.m_108564_();
        boolean isSlim = "slim".equals(skinModel);
        slimModelCache.put(uuid, isSlim);
        return isSlim;
    }

    public static void loadPlayerSkinAsync(String playerName, String uuid, Consumer<ResourceLocation> callback) {
        CompletableFuture.runAsync(() -> {
            try {
                ResourceLocation skinLocation;
                GameProfile gameProfile = new GameProfile(UUID.fromString(uuid), playerName);
                Minecraft mc = Minecraft.m_91087_();
                SkinManager skinManager = mc.m_91109_();
                Map textures = skinManager.m_118815_(gameProfile);
                if (textures.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    MinecraftProfileTexture skinTexture = (MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN);
                    skinLocation = skinManager.m_118825_(skinTexture, MinecraftProfileTexture.Type.SKIN);
                } else {
                    skinLocation = DefaultPlayerSkin.m_118627_((UUID)gameProfile.getId());
                }
                skinCache.put(uuid, skinLocation);
                callback.accept(skinLocation);
            }
            catch (Exception e) {
                ResourceLocation defaultSkin = DefaultPlayerSkin.m_118626_();
                skinCache.put(uuid, defaultSkin);
                callback.accept(defaultSkin);
            }
        });
    }

    public static void clearCache() {
        skinCache.clear();
        slimModelCache.clear();
    }
}

