/*
 * Decompiled with CFR 0.152.
 */
package com.wzz.unparalleled;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public abstract class TimerEntry {
    private final Map<UUID, ScheduledFuture<?>> timerMap = new ConcurrentHashMap();
    private int executions;
    private static final Map<Class<? extends TimerEntry>, Map<UUID, TimerEntry>> globalEntityEntryMap = new ConcurrentHashMap<Class<? extends TimerEntry>, Map<UUID, TimerEntry>>();
    private static final Map<Class<?>, Map<UUID, Boolean>> GLOBAL_CLASS_ENTITY_LOCK = new ConcurrentHashMap();
    private static volatile ScheduledExecutorService scheduler = TimerEntry.createScheduler();

    private static ScheduledExecutorService createScheduler() {
        return Executors.newScheduledThreadPool(Math.max(6, Runtime.getRuntime().availableProcessors()), r -> {
            Thread thread = new Thread(r, "SkillTimerThread");
            thread.setDaemon(true);
            return thread;
        });
    }

    private static synchronized ScheduledExecutorService getScheduler() {
        if (scheduler == null || scheduler.isShutdown()) {
            scheduler = TimerEntry.createScheduler();
        }
        return scheduler;
    }

    public boolean addSkillTimer(LivingEntity living, int delay, int duration, int executionsPerSecond, boolean refresh) {
        if (living == null) {
            return false;
        }
        UUID uuid = living.m_20148_();
        if (refresh && this.timerMap.containsKey(uuid)) {
            this.removeTimer(uuid);
            if (this.timerMap.containsKey(uuid)) {
                return false;
            }
        }
        return this.addSkillTimer(living, delay, duration, executionsPerSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSkillTimer(LivingEntity living, int delay, int duration, int executionsPerSecond) {
        if (living == null) {
            return false;
        }
        UUID uuid = living.m_20148_();
        Class<?> timerClass = this.getClass();
        Map classLock = GLOBAL_CLASS_ENTITY_LOCK.computeIfAbsent(timerClass, k -> new ConcurrentHashMap());
        if (classLock.putIfAbsent(uuid, true) != null) {
            return false;
        }
        if (this.timerMap.containsKey(uuid)) {
            classLock.remove(uuid);
            return false;
        }
        if (delay < 0 || duration <= 0 || executionsPerSecond <= 0) {
            return false;
        }
        ScheduledExecutorService currentScheduler = TimerEntry.getScheduler();
        Class<?> entryClass = this.getClass();
        globalEntityEntryMap.computeIfAbsent(entryClass, k -> new ConcurrentHashMap());
        Map<UUID, TimerEntry> entryMap = globalEntityEntryMap.get(entryClass);
        TimerEntry timerEntry = this;
        synchronized (timerEntry) {
            if (entryMap.containsKey(uuid) || this.timerMap.containsKey(uuid)) {
                return false;
            }
            entryMap.put(uuid, this);
        }
        this.onSkillStart(living);
        try {
            long period = Math.max(1L, 1000L / (long)executionsPerSecond);
            ScheduledFuture<?> skillTask = currentScheduler.scheduleAtFixedRate(() -> this.executeTaskSafely(living, uuid), delay, period, TimeUnit.MILLISECONDS);
            currentScheduler.schedule(() -> this.stopTimerSafely(living, uuid), (long)(delay + duration), TimeUnit.MILLISECONDS);
            this.timerMap.put(uuid, skillTask);
            return true;
        }
        catch (RejectedExecutionException e) {
            entryMap.remove(uuid);
            classLock.remove(uuid);
            return false;
        }
        catch (Exception e) {
            entryMap.remove(uuid);
            classLock.remove(uuid);
            return false;
        }
    }

    public int getExecutions() {
        return this.executions;
    }

    private void executeTaskSafely(LivingEntity living, UUID entityId) {
        try {
            if (this.isEntityValid(living)) {
                ++this.executions;
                this.onTaskRunning(living);
            } else {
                this.removeTimer(entityId);
            }
        }
        catch (Exception e) {
            this.removeTimer(entityId);
        }
    }

    private boolean isEntityValid(@Nullable LivingEntity entity) {
        return entity != null && entity.m_6084_() && !entity.m_213877_();
    }

    public void stopTimerSafely(LivingEntity living, UUID entityId) {
        try {
            if (this.isEntityValid(living)) {
                this.onSkillEnd(living);
            }
        }
        finally {
            this.removeTimer(entityId);
        }
    }

    public synchronized void removeTimer(UUID livingId) {
        Map<UUID, TimerEntry> entryMap;
        ScheduledFuture<?> task = this.timerMap.remove(livingId);
        if (task != null) {
            task.cancel(false);
        }
        if ((entryMap = globalEntityEntryMap.get(this.getClass())) != null) {
            entryMap.remove(livingId);
            GLOBAL_CLASS_ENTITY_LOCK.getOrDefault(this.getClass(), Collections.emptyMap()).remove(livingId);
        }
    }

    public static void shutdown(LivingEntity living) {
        if (living == null) {
            return;
        }
        UUID uuid = living.m_20148_();
        for (Map<UUID, TimerEntry> timers : globalEntityEntryMap.values()) {
            TimerEntry timer = timers.get(uuid);
            if (timer == null) continue;
            timer.stopTimerSafely(living, uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownAll() {
        Class<TimerEntry> clazz = TimerEntry.class;
        synchronized (TimerEntry.class) {
            if (scheduler != null && !scheduler.isShutdown()) {
                scheduler.shutdown();
                try {
                    if (!scheduler.awaitTermination(3L, TimeUnit.SECONDS)) {
                        scheduler.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    scheduler.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            }
            for (Map<UUID, TimerEntry> timers : globalEntityEntryMap.values()) {
                for (TimerEntry timer : timers.values()) {
                    for (UUID uuid : new ArrayList<UUID>(timer.timerMap.keySet())) {
                        timer.removeTimer(uuid);
                    }
                }
            }
            globalEntityEntryMap.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void reinitializeScheduler() {
        if (scheduler != null && !scheduler.isShutdown()) {
            return;
        }
        scheduler = TimerEntry.createScheduler();
    }

    public static boolean isSchedulerRunning() {
        return scheduler != null && !scheduler.isShutdown();
    }

    public abstract void onSkillStart(LivingEntity var1);

    public abstract void onTaskRunning(LivingEntity var1);

    public abstract void onSkillEnd(LivingEntity var1);
}

