/*
 * Decompiled with CFR 0.152.
 */
package com.wzz.unparalleled;

import com.wzz.unparalleled.ClientEventHandler;
import com.wzz.unparalleled.EnvironmentUtil;
import com.wzz.unparalleled.TimerEntry;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod(value="unparalleled")
public class Unparalleled {
    public static final String MODID = "unparalleled";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("unparalleled", "unparalleled"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;

    public Unparalleled() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        if (EnvironmentUtil.isClient()) {
            modEventBus.addListener(this::onClientSetup);
        }
        modEventBus.addListener(this::onCommonSetup);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        Unparalleled.registerForgeEvent(Unparalleled::onServerStop);
        Unparalleled.registerForgeEvent(Unparalleled::onLivingHurt);
        Unparalleled.registerForgeEvent(Unparalleled::onLivingFall);
        Unparalleled.registerForgeEvent(Unparalleled::onLivingHeal);
        Unparalleled.registerForgeEvent(Unparalleled::onPlayerLoggedOut);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        Unparalleled.registerForgeEvent(ClientEventHandler::onClientTick);
        Unparalleled.registerForgeEvent(ClientEventHandler::onWorldUnload);
        Unparalleled.registerForgeEvent(ClientEventHandler::onRenderLevelStage);
        Unparalleled.registerForgeEvent(ClientEventHandler::onKeyInput);
    }

    public static void onServerStop(ServerStoppingEvent event) {
        TimerEntry.shutdownAll();
    }

    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        e.getEntity().getPersistentData().m_128379_("isSuperPower", false);
        e.getEntity().getPersistentData().m_128405_("jumpCount", 0);
    }

    public static void onLivingHurt(LivingHurtEvent event) {
        Player player;
        Entity entity;
        if (event.getSource() != null && (entity = event.getSource().m_7639_()) instanceof Player && (player = (Player)entity).getPersistentData().m_128471_("isSuperPower")) {
            event.setAmount(event.getAmount() * 4.0f);
        }
    }

    public static void onLivingFall(LivingFallEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).getPersistentData().m_128471_("isSuperPower")) {
            player.getPersistentData().m_128405_("jumpCount", 0);
            event.setCanceled(true);
        }
    }

    public static void onLivingHeal(LivingHealEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).getPersistentData().m_128471_("isSuperPower")) {
            event.setAmount(event.getAmount() * 2.0f);
        }
    }

    public static <T extends Event> void registerForgeEvent(Consumer<T> eventConsumer) {
        MinecraftForge.EVENT_BUS.addListener(eventConsumer);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }
}

