/*
 * Decompiled with CFR 0.152.
 */
package com.wzz.unparalleled;

import com.wzz.unparalleled.TimerEntry;
import com.wzz.unparalleled.Unparalleled;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class UnparalleledMessage {
    int type;
    int pressedms;

    public UnparalleledMessage(int type, int pressedms) {
        this.type = type;
        this.pressedms = pressedms;
    }

    public UnparalleledMessage(FriendlyByteBuf buffer) {
        this.type = buffer.readInt();
        this.pressedms = buffer.readInt();
    }

    public static void buffer(UnparalleledMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
        buffer.writeInt(message.pressedms);
    }

    public static void handler(UnparalleledMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> UnparalleledMessage.pressAction((Player)context.getSender(), message.type, message.pressedms));
        context.setPacketHandled(true);
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.m_9236_();
        if (!world.m_46805_(entity.m_20183_())) {
            return;
        }
        if (type == 0) {
            long lastUseTime;
            long cooldownTime = 60000L;
            long currentTime = System.currentTimeMillis();
            long timeDiff = currentTime - (lastUseTime = entity.getPersistentData().m_128454_("lastSkillUseTime"));
            long remainingCooldown = cooldownTime - timeDiff;
            if (remainingCooldown > 0L) {
                int remainingSeconds = (int)(remainingCooldown / 1000L) + 1;
                entity.m_5661_((Component)Component.m_237113_((String)("\u00a7c\u6280\u80fd\u6b63\u5728\u51b7\u5374\u4e2d\uff01\u5269\u4f59\u65f6\u95f4\uff1a" + remainingSeconds + "\u79d2")), true);
                return;
            }
            entity.getPersistentData().m_128356_("lastSkillUseTime", currentTime);
            TimerEntry timerEntry = new TimerEntry(){

                @Override
                public void onSkillStart(LivingEntity living) {
                    living.getPersistentData().m_128379_("isSuperPower", true);
                }

                @Override
                public void onTaskRunning(LivingEntity living) {
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 40, 3));
                }

                @Override
                public void onSkillEnd(LivingEntity living) {
                    living.getPersistentData().m_128379_("isSuperPower", false);
                }
            };
            timerEntry.addSkillTimer((LivingEntity)entity, 0, 10000, 1);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        Unparalleled.addNetworkMessage(UnparalleledMessage.class, UnparalleledMessage::buffer, UnparalleledMessage::new, UnparalleledMessage::handler);
    }
}

