/*
 * Decompiled with CFR 0.152.
 */
package gakusei.mini;

import gakusei.mini.GakuminiFeatures;
import gakusei.mini.GakuminiGamerules;
import gakusei.mini.GakuminiSounds;
import gakusei.mini.GakuminiStats;
import gakusei.mini.GakuminiTags;
import gakusei.mini.block.GakuminiBlocks;
import gakusei.mini.effect.GenericEffect;
import gakusei.mini.item.CoinItem;
import gakusei.mini.recipe.BrandRecipeSerializer;
import gakusei.mini.recipe.BrandingRecipe;
import gakusei.mini.screen.BrandingScreenHandler;
import gakusei.mini.util.ColorUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4081;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_77;
import net.minecraft.class_7701;
import net.minecraft.class_7706;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gakumini
implements ModInitializer {
    public static final String MOD_ID = "gakumini";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"gakumini");
    public static Map<class_1792, String> coinBrandMap = new HashMap<class_1792, String>();
    public static Map<class_1792, String> coinMaterialMap = new HashMap<class_1792, String>();
    public static final class_1291 TOTEM_SICKNESS = (class_1291)class_2378.method_10230((class_2378)class_7923.field_41174, (class_2960)Gakumini.identifier("totem_sickness"), (Object)((Object)new GenericEffect(class_4081.field_18272, ColorUtil.IntFromHex("15247b"))));
    public static final class_1792 SALTPETER = Gakumini.makeBoringItem("saltpeter");
    public static final class_1792 WITHERBONE = Gakumini.makeBoringItem("witherbone");
    public static final class_1792 CIRCLE_BRAND = Gakumini.makeBrandItem("circle_brand", "circle");
    public static final class_1792 PLUS_BRAND = Gakumini.makeBrandItem("plus_brand", "plus");
    public static final class_1792 RING_BRAND = Gakumini.makeBrandItem("ring_brand", "ring");
    public static final class_1792 CORNERS_BRAND = Gakumini.makeBrandItem("corners_brand", "corners");
    public static final class_1792 FACE_BRAND = Gakumini.makeBrandItem("face_brand", "face");
    public static final class_1792 CREEPER_BRAND = Gakumini.makeBrandItem("creeper_brand", "creeper");
    public static final class_1792 COPPER_COIN = Gakumini.makeCoinItem("copper_coin", "copper");
    public static final class_1792 DIAMOND_COIN = Gakumini.makeCoinItem("diamond_coin", "diamond");
    public static final class_1792 EMERALD_COIN = Gakumini.makeCoinItem("emerald_coin", "emerald");
    public static final class_1792 GOLD_COIN = Gakumini.makeCoinItem("gold_coin", "gold");
    public static final class_1792 IRON_COIN = Gakumini.makeCoinItem("iron_coin", "iron");
    public static final class_1792 NETHERITE_COIN = Gakumini.makeCoinItem("netherite_coin", "netherite");
    public static class_55.class_56 coinsLootPool = Gakumini.coinBrandEntries();
    public static final class_3917<BrandingScreenHandler> BRANDING_SCREEN_HANDLER_TYPE = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)Gakumini.identifier("branding_sht"), (Object)new class_3917(BrandingScreenHandler::new, class_7701.field_40182));
    public static final class_3956<BrandingRecipe> BRANDING_RECIPE_TYPE = (class_3956)class_2378.method_10230((class_2378)class_7923.field_41188, (class_2960)Gakumini.identifier("branding"), (Object)new class_3956<BrandingRecipe>(){

        public String toString() {
            return "branding";
        }
    });

    public static class_2960 identifier(String path) {
        if (path.contains(":")) {
            return new class_2960(path);
        }
        return class_2960.method_43902((String)MOD_ID, (String)path);
    }

    public static class_1792 makeCoinItem(String path, String material) {
        class_1792 i = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Gakumini.identifier(path), (Object)((Object)new CoinItem((class_1792.class_1793)new FabricItemSettings())));
        coinMaterialMap.put(i, material);
        return i;
    }

    public static class_1792 makeBoringItem(String path) {
        return (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Gakumini.identifier(path), (Object)new class_1792((class_1792.class_1793)new FabricItemSettings()));
    }

    public static class_1792 makeBrandItem(String path, String brand) {
        class_1792 item = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)Gakumini.identifier(path), (Object)new class_1792((class_1792.class_1793)new FabricItemSettings().rarity(class_1814.field_8907).maxCount(1)));
        coinBrandMap.put(item, brand);
        return item;
    }

    public void onInitialize() {
        GakuminiBlocks.init();
        GakuminiFeatures.init();
        GakuminiGamerules.init();
        GakuminiStats.init();
        GakuminiTags.init();
        GakuminiSounds.init();
        class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)BrandRecipeSerializer.ID, (Object)BrandRecipeSerializer.INSTANCE);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInOverworld(), (class_2893.class_2895)class_2893.class_2895.field_13176, GakuminiFeatures.SALTPETER_DEPOSIT_FEATURE);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInTheNether(), (class_2893.class_2895)class_2893.class_2895.field_13176, GakuminiFeatures.NETHER_SALTPETER_DEPOSIT_FEATURE);
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41062).register(itemGroup -> {
            itemGroup.addAfter((class_1935)class_1802.field_33402, new class_1935[]{SALTPETER});
            itemGroup.addAfter((class_1935)class_1802.field_8606, new class_1935[]{WITHERBONE});
            for (class_1792 item : coinMaterialMap.keySet()) {
                itemGroup.method_45421((class_1935)item);
            }
            for (class_1792 item : coinBrandMap.keySet()) {
                itemGroup.method_45421((class_1935)item);
            }
        });
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40743).register(itemGroup -> {
            itemGroup.addAfter((class_1935)class_1802.field_29019, new class_1935[]{GakuminiBlocks.SALTPETER_DEPOSIT.item});
            itemGroup.addAfter((class_1935)GakuminiBlocks.SALTPETER_DEPOSIT.item, new class_1935[]{GakuminiBlocks.NETHERRACK_SALTPETER_DEPO.item});
        });
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(itemGroup -> itemGroup.addAfter((class_1935)class_1802.field_8732, new class_1935[]{GakuminiBlocks.BRANDING_BLOCK.item}));
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            if (!source.isBuiltin()) {
                return;
            }
            if (Gakumini.isValidForBrandLoot(id)) {
                tableBuilder.method_336(coinsLootPool).method_336(coinsLootPool);
            }
        });
    }

    public static class_55.class_56 coinBrandEntries() {
        class_55.class_56 f = class_55.method_347();
        int i = 0;
        for (class_1792 item : coinBrandMap.keySet()) {
            ++i;
            f = f.method_351((class_79.class_80)class_77.method_411((class_1935)item).method_437(7).method_436(3));
        }
        f.method_351((class_79.class_80)class_77.method_411((class_1935)COPPER_COIN).method_437(i * 4).method_436(-1));
        f.method_351((class_79.class_80)class_77.method_411((class_1935)IRON_COIN).method_437(i * 2).method_436(0));
        f.method_351((class_79.class_80)class_77.method_411((class_1935)GOLD_COIN).method_437(i).method_436(1));
        f.method_351((class_79.class_80)class_77.method_411((class_1935)EMERALD_COIN).method_437(i / 2).method_436(2));
        return f.method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8162).method_437(i * 3).method_436(-3));
    }

    public static boolean isValidForBrandLoot(class_2960 id) {
        List<class_2960> lootTables = List.of(class_39.field_665, class_39.field_251, class_39.field_885, class_39.field_803, class_39.field_751, class_39.field_472, class_39.field_24050, class_39.field_356, class_39.field_17107, class_39.field_854, class_39.field_22402, class_39.field_24047);
        for (class_2960 i : lootTables) {
            if (!id.equals((Object)i)) continue;
            return true;
        }
        return false;
    }
}

