/*
 * Decompiled with CFR 0.152.
 */
package gakusei.mini.screen;

import gakusei.mini.Gakumini;
import gakusei.mini.GakuminiSounds;
import gakusei.mini.GakuminiTags;
import gakusei.mini.recipe.BrandingRecipe;
import gakusei.mini.util.NBTUtil;
import java.util.Optional;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3914;
import net.minecraft.class_8786;

public class BrandingScreenHandler
extends class_1703 {
    private final class_1277 input = new class_1277(3);
    private final class_1277 output = new class_1277(1);
    class_1657 player;
    class_3914 context;

    public BrandingScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public BrandingScreenHandler(int syncId, class_1661 playerInventory, class_3914 ctx) {
        super(Gakumini.BRANDING_SCREEN_HANDLER_TYPE, syncId);
        int i;
        this.context = ctx;
        this.player = playerInventory.field_7546;
        class_1735 coinSlot = this.method_7621(new BrandingInputSlot((class_1263)this.input, 0, 65, 17));
        class_1735 brandSlot = this.method_7621(new BrandingInputSlot((class_1263)this.input, 1, 30, 35));
        class_1735 materialSlot = this.method_7621(new BrandingInputSlot((class_1263)this.input, 2, 65, 53));
        class_1735 outputSlot = this.method_7621(new BrandingOutputSlot(playerInventory.field_7546, (class_1263)this.output, 0, 124, 35));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 142));
        }
    }

    protected static void updateResult(class_1703 handler, class_1937 world, class_1657 player, class_1263 in, class_1263 out) {
        if (!world.field_9236) {
            class_3222 serverPlayerEntity = (class_3222)player;
            class_1799 itemStack = class_1799.field_8037;
            Optional optional = world.method_8503().method_3772().method_8132(Gakumini.BRANDING_RECIPE_TYPE, in, world);
            if (optional.isPresent()) {
                class_8786 recipe = (class_8786)optional.get();
                class_1799 itemStack2 = ((BrandingRecipe)recipe.comp_1933()).method_8116(in, world.method_30349());
                if (itemStack2.method_45435(world.method_45162())) {
                    itemStack = itemStack2;
                }
            } else if (in.method_5438(0).method_31573(GakuminiTags.GAKUMINI_COINS) && in.method_5438(1).method_31573(GakuminiTags.BRANDING_BRANDS) && in.method_5438(2).method_31573(GakuminiTags.BRANDING_MATERIALS)) {
                itemStack = in.method_5438(0).method_46651(1);
                class_1799 brandStack = in.method_5438(1).method_7972();
                class_1799 materialStack = in.method_5438(2).method_7972();
                Object putString = "";
                if (materialStack.method_31574(class_1802.field_27022)) {
                    putString = "copper";
                }
                if (materialStack.method_31574(class_1802.field_8477)) {
                    putString = "diamond";
                }
                if (materialStack.method_31574(class_1802.field_8687)) {
                    putString = "emerald";
                }
                if (materialStack.method_31574(class_1802.field_8695)) {
                    putString = "gold";
                }
                if (materialStack.method_31574(class_1802.field_8620)) {
                    putString = "iron";
                }
                if (materialStack.method_31574(class_1802.field_22020)) {
                    putString = "netherite";
                }
                if (brandStack.method_31573(GakuminiTags.BRANDING_BRANDS)) {
                    putString = (String)putString + "_" + Gakumini.coinBrandMap.get(brandStack.method_7909());
                }
                itemStack.method_7948().method_10582("coin_brands", NBTUtil.addToStringlist(itemStack.method_7969().method_10558("coin_brands"), (String)putString, true));
            }
            if (itemStack.method_31573(GakuminiTags.GAKUMINI_COINS)) {
                itemStack.method_7948().method_10582("signer", player.method_5477().getString());
            }
            out.method_5447(0, itemStack);
            handler.method_34245(3, itemStack);
            serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(handler.field_7763, handler.method_37422(), 3, itemStack));
        }
    }

    public void method_7609(class_1263 inventory) {
        this.context.method_17393((world, blockPos) -> BrandingScreenHandler.updateResult(this, world, this.player, (class_1263)this.input, (class_1263)this.output));
    }

    public class_1799 method_7601(class_1657 player, int slot) {
        class_1735 theSlotInQuestion = (class_1735)this.field_7761.get(slot);
        if (theSlotInQuestion.method_7681()) {
            class_1799 itemStack = theSlotInQuestion.method_7677().method_7972();
            if (slot <= 2) {
                this.tryPutInInventory(itemStack, theSlotInQuestion);
            } else if (slot != 3) {
                if (itemStack.method_31573(GakuminiTags.BRANDING_MATERIALS)) {
                    this.tryPutInSlot(itemStack, (class_1735)this.field_7761.get(2), theSlotInQuestion);
                } else if (itemStack.method_31573(GakuminiTags.GAKUMINI_COINS)) {
                    this.tryPutInSlot(itemStack, (class_1735)this.field_7761.get(0), theSlotInQuestion);
                } else if (itemStack.method_31573(GakuminiTags.BRANDING_BRANDS)) {
                    this.tryPutInSlot(itemStack, (class_1735)this.field_7761.get(1), theSlotInQuestion);
                }
            } else {
                itemStack.method_7939(this.getSmallestInputStack());
                this.tryPutInInventory(itemStack, theSlotInQuestion);
                this.decrementInput(this.getSmallestInputStack() - 1);
            }
            BrandingScreenHandler.updateResult(this, player.method_37908(), player, (class_1263)this.input, (class_1263)this.output);
            theSlotInQuestion.method_7667(player, itemStack);
        }
        return class_1799.field_8037;
    }

    public void tryPutInSlot(class_1799 itemStack, class_1735 slotToPutIn, class_1735 original) {
        if (slotToPutIn.method_7677().method_41406(itemStack.method_41409()) && slotToPutIn.method_7677().method_7969() == itemStack.method_7969() || slotToPutIn.method_7677().method_7960()) {
            int total = slotToPutIn.method_7677().method_7947() + itemStack.method_7947();
            class_1799 stack2 = itemStack.method_7972();
            stack2.method_7939(Math.min(64, total));
            slotToPutIn.method_53512(stack2);
            int leftover = total - 64;
            itemStack.method_7939(Math.max(0, leftover));
            original.method_7677().method_7939(Math.max(0, leftover));
        }
    }

    public void tryPutInInventory(class_1799 itemStack, class_1735 theSlotInQuestion) {
        int j = 39;
        boolean lookingForMatchingItemSlots = true;
        while (j > 3) {
            class_1735 s = (class_1735)this.field_7761.get(j);
            if (!lookingForMatchingItemSlots && s.method_7677().method_7960()) {
                s.method_53512(itemStack);
                theSlotInQuestion.method_53512(class_1799.field_8037);
                j = -1;
            } else if (lookingForMatchingItemSlots && s.method_7677().method_41406(itemStack.method_41409()) && s.method_7677().method_7969() == itemStack.method_7969()) {
                int total = s.method_7677().method_7947() + itemStack.method_7947();
                s.method_7677().method_7939(Math.min(64, total));
                int leftover = total - 64;
                class_1799 stack2 = itemStack.method_7972();
                stack2.method_7939(Math.min(64, total));
                s.method_53512(stack2);
                itemStack.method_7939(Math.max(0, leftover));
            }
            if (itemStack.method_7960()) {
                j = -1;
            }
            if (!lookingForMatchingItemSlots || --j != 3) continue;
            j = 39;
            lookingForMatchingItemSlots = false;
        }
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public int getSmallestInputStack() {
        int i = this.input.method_5438(0).method_7947();
        if (i > this.input.method_5438(2).method_7947()) {
            i = this.input.method_5438(2).method_7947();
        }
        return i;
    }

    public void decrementInput(int i) {
        this.input.method_5434(0, i);
        this.input.method_5434(2, i);
        this.context.method_17393((world, blockPos) -> BrandingScreenHandler.updateResult(this, world, this.player, (class_1263)this.input, (class_1263)this.output));
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, (class_1263)this.input));
    }

    public class BrandingInputSlot
    extends class_1735 {
        public BrandingInputSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public void method_7668() {
            super.method_7668();
            BrandingScreenHandler.this.method_7609(this.field_7871);
        }
    }

    public class BrandingOutputSlot
    extends class_1735 {
        private final class_1657 player;

        public BrandingOutputSlot(class_1657 player, class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            this.player = player;
        }

        public void method_7667(class_1657 player, class_1799 stack) {
            super.method_7667(player, stack);
            BrandingScreenHandler.this.decrementInput(1);
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)GakuminiSounds.CRAFT_BRANDING, (float)1.0f, (float)4.0f));
        }

        public boolean method_7680(class_1799 stack) {
            return false;
        }
    }
}

