/*
 * Decompiled with CFR 0.152.
 */
package com.kaplandev.level.player;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kaplandev.level.player.PlayerLevel;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;

public class PlayerLevelSaveHandler {
    private static final Gson GSON = new Gson();
    private static final Type TYPE = new TypeToken<Map<UUID, PlayerLevel>>(){}.getType();
    private static final Map<UUID, PlayerLevel> DATA = new HashMap<UUID, PlayerLevel>();
    private static File saveFile;

    public static void init(MinecraftServer server) {
        File dataDir = new File(server.method_27728().method_150(), "player_levels");
        if (!dataDir.exists() && !dataDir.mkdirs()) {
            System.err.println("\u00a7cKlas\u00f6r olu\u015fturulamad\u0131: " + dataDir.getAbsolutePath());
        }
        if ((saveFile = new File(dataDir, "levels.json")).exists()) {
            try (FileReader reader = new FileReader(saveFile);){
                Map loaded = (Map)GSON.fromJson((Reader)reader, TYPE);
                if (loaded != null) {
                    DATA.clear();
                    DATA.putAll(loaded);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        if (saveFile == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(saveFile);){
            GSON.toJson(DATA, TYPE, (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static PlayerLevel get(UUID uuid) {
        PlayerLevel levelData = DATA.computeIfAbsent(uuid, k -> new PlayerLevel());
        if (levelData.level > 120) {
            throw new RuntimeException("\u00a7cHile tespit edildi: Oyuncunun seviyesi 120'yi ge\u00e7ti: " + levelData.level);
        }
        return levelData;
    }

    public static void set(UUID uuid, PlayerLevel level) {
        if (level.level > 120) {
            throw new RuntimeException("Oyuncunun level'i 120'den b\u00fcy\u00fck olamaz! (" + level.level + ")");
        }
        DATA.put(uuid, level);
    }
}

