/*
 * Decompiled with CFR 0.152.
 */
package com.kaplandev.mixin.client;

import com.kaplandev.bouncingelf10.animatedLogo.DarkLoadingScreenCompat;
import com.kaplanlib.util.path.Paths;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4011;
import net.minecraft.class_425;
import net.minecraft.class_5253;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_425.class})
public class SplashOverlayMixin {
    @Mutable
    @Shadow
    @Final
    private class_4011 field_17767;
    @Shadow
    private float field_17770;
    @Unique
    private int count = 0;
    @Unique
    private class_2960[] frames;
    @Unique
    private boolean inited = false;
    @Unique
    private static final int FRAMES = 12;
    @Unique
    private static final int IMAGE_PER_FRAME = 4;
    @Unique
    private static final int FRAMES_PER_FRAME = 2;
    @Unique
    private static final long TEXT_FADE_IN_DURATION_MS = 800L;
    @Unique
    private static final long TEXT_VISIBLE_DURATION_MS = 1400L;
    @Unique
    private static final long TEXT_FADE_OUT_DURATION_MS = 800L;
    @Unique
    private long animationDelayStartTime2 = System.currentTimeMillis();
    @Unique
    private float f = 0.0f;
    @Unique
    private boolean animationDone = false;
    @Shadow
    @Final
    private static IntSupplier field_25041;
    @Unique
    private static int whiteARGB;
    @Unique
    private static IntSupplier LOADING_FILL;
    @Unique
    private static IntSupplier LOADING_BORDER;
    @Unique
    private static IntSupplier TEXT_COLOR;
    @Unique
    private boolean soundPlayed = false;
    @Unique
    private boolean animationReady = false;
    @Unique
    private boolean isFadingOut = false;
    @Unique
    private boolean isFadingFinished = false;
    @Unique
    private long animationStartTime = -1L;
    @Unique
    private static final float TOTAL_ANIMATION_DURATION = 3.0f;
    @Unique
    private long animationDelayStartTime = -1L;
    @Unique
    private static final long ANIMATION_DELAY_MS = 1L;
    @Unique
    private long fadeOutStartTime = -1L;
    @Unique
    private static final long FADE_OUT_DURATION_MS = 1000L;
    @Unique
    private static float loadingBarProgress;
    @Unique
    private static boolean HAS_LOADED_ONCE;
    @Unique
    private static final int LOGO_TEXTURE_WIDTH = 640;
    @Unique
    private static final int LOGO_TEXTURE_HEIGHT = 57;

    @Unique
    private void drawLoadingBar(class_332 context, float opacity, float progress) {
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        int centerX = screenWidth / 2;
        int progressBarY = (int)((double)screenHeight * 0.8325);
        double logoHeight = Math.min((double)screenWidth * 0.75, (double)screenHeight) * 0.25;
        double logoWidth = logoHeight * 4.0;
        int halfLogoWidth = (int)(logoWidth * 0.5);
        int progressBarHeight = 4;
        int progressBarWidth = (int)((double)screenWidth * 0.3);
        int minX = centerX - progressBarWidth / 2;
        int maxX = centerX + progressBarWidth / 2;
        int minY = progressBarY - progressBarHeight / 2;
        int maxY = progressBarY + progressBarHeight / 2;
        int filled = class_3532.method_15386((float)((float)(maxX - minX - 2) * progress));
        int colorFilled = SplashOverlayMixin.applyAlphaToColor(LOADING_FILL.getAsInt(), opacity);
        int colorOutline = SplashOverlayMixin.applyAlphaToColor(LOADING_BORDER.getAsInt(), opacity);
        context.method_25294(minX + 2, minY + 1, minX + filled, maxY - 1, colorFilled);
        context.method_25294(minX, minY, maxX, minY + 1, colorOutline);
        context.method_25294(minX, maxY - 1, maxX, maxY, colorOutline);
        context.method_25294(minX, minY, minX + 1, maxY, colorOutline);
        context.method_25294(maxX - 1, minY, maxX, maxY, colorOutline);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(class_310 client, class_4011 monitor, Consumer<Throwable> exceptionHandler, boolean reloading, CallbackInfo ci) {
        if (HAS_LOADED_ONCE) {
            Paths.LOGGER.warn("Animated Mojang Logo has already been loaded once, skipping initialization.");
            return;
        }
        this.animationDelayStartTime = System.currentTimeMillis();
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;setShaderColor(FFFF)V", ordinal=0), index=3)
    private float removeText(float red) {
        return HAS_LOADED_ONCE ? red : 0.0f;
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/SplashOverlay;renderProgressBar(Lnet/minecraft/client/gui/DrawContext;IIIIF)V", ordinal=0), index=5)
    private float removeBar(float opacity) {
        return HAS_LOADED_ONCE ? opacity : 0.0f;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void preRender(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (HAS_LOADED_ONCE) {
            return;
        }
        long elapsed = System.currentTimeMillis() - this.animationDelayStartTime;
        if (elapsed < 1L) {
            context.method_51739(class_1921.method_51785(), 0, 0, context.method_51421(), context.method_51443(), class_5253.class_8045.method_48343((int)((int)(elapsed * 255L / 1L / 10L)), (int)SplashOverlayMixin.applyAlphaToColor(field_25041.getAsInt(), 1.0f)));
            ci.cancel();
            return;
        }
        if (!this.animationDone) {
            this.drawAnimatedIntro(context);
            ci.cancel();
        }
    }

    @Unique
    private void drawAnimatedIntro(class_332 context) {
        if (!(this.field_17767.method_18787() || this.isFadingOut || this.isFadingFinished)) {
            context.method_51739(class_1921.method_51785(), 0, 0, context.method_51421(), context.method_51443(), SplashOverlayMixin.applyAlphaToColor(field_25041.getAsInt(), 1.0f));
            this.drawLoadingBar(context, 1.0f, Math.max(loadingBarProgress, this.field_17767.method_18229()));
            loadingBarProgress = this.field_17767.method_18229();
            this.animationDelayStartTime2 = System.currentTimeMillis();
            this.drawKaplanBedwarsImage(context);
            return;
        }
        if (this.field_17767.method_18787() && !this.isFadingOut && !this.isFadingFinished) {
            this.isFadingOut = true;
            this.fadeOutStartTime = System.currentTimeMillis();
        }
        if (this.isFadingOut && !this.isFadingFinished) {
            long elapsedFade = System.currentTimeMillis() - this.fadeOutStartTime;
            float fadeFactor = 1.0f - class_3532.method_15363((float)((float)elapsedFade / 1000.0f), (float)0.0f, (float)1.0f);
            context.method_51739(class_1921.method_51785(), 0, 0, context.method_51421(), context.method_51443(), SplashOverlayMixin.applyAlphaToColor(field_25041.getAsInt(), 1.0f));
            this.drawLoadingBar(context, fadeFactor, 1.0f);
            loadingBarProgress = this.field_17767.method_18229();
            if ((double)fadeFactor <= 0.0) {
                this.isFadingFinished = true;
            }
            return;
        }
        if (this.isFadingFinished && !this.animationReady) {
            this.animationReady = true;
            this.animationStartTime = System.nanoTime();
            if (!this.soundPlayed) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)Paths.STARTUP_SOUND_EVENT, (float)1.0f));
                Paths.LOGGER.info("Playing startup sound");
                this.soundPlayed = true;
            }
            if (!this.inited) {
                this.frames = new class_2960[12];
                for (int i = 0; i < 12; ++i) {
                    this.frames[i] = class_2960.method_60655((String)"mobpvp", (String)("textures/gui/frame_" + i + ".png"));
                }
                this.inited = true;
            }
        }
        if (this.animationReady) {
            double elapsedSeconds = (double)(System.nanoTime() - this.animationStartTime) / 1.0E9;
            double animationProgress = Math.min(elapsedSeconds / 3.0, 1.0);
            int totalFrameCount = 96;
            this.count = (int)(animationProgress * (double)totalFrameCount);
            if (animationProgress >= 1.0) {
                this.animationDone = true;
                this.count = totalFrameCount - 1;
            }
            int screenWidth = context.method_51421();
            int screenHeight = context.method_51443();
            int width = screenWidth / 2;
            int height = width * 256 / 1024;
            int x = (screenWidth - width) / 2;
            int y = (screenHeight - height) / 2;
            int frameIndex = this.count / 4 / 2;
            int subFrameY = 256 * (this.count % 8 / 2);
            context.method_51739(class_1921.method_51785(), 0, 0, context.method_51421(), context.method_51443(), SplashOverlayMixin.applyAlphaToColor(field_25041.getAsInt(), 1.0f));
            SplashOverlayMixin.setShaderColor(TEXT_COLOR.getAsInt(), 1.0f);
            context.method_25293(this.frames[frameIndex], x, y, width, height, 0.0f, (float)subFrameY, 1024, 256, 1024, 1024);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Unique
    private void drawKaplanBedwarsImage(class_332 context) {
        float alpha;
        long totalDuration;
        long elapsed = System.currentTimeMillis() - this.animationDelayStartTime;
        if (elapsed > (totalDuration = 3000L)) {
            return;
        }
        if (elapsed < 800L) {
            alpha = (float)elapsed / 800.0f;
        } else if (elapsed < 2200L) {
            alpha = 1.0f;
        } else {
            long fadeOutElapsed = elapsed - 800L - 1400L;
            alpha = 1.0f - (float)fadeOutElapsed / 800.0f;
        }
        class_2960 texture = class_2960.method_60655((String)"mobpvp", (String)"textures/gui/klogo5.png");
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        int drawWidth = 220;
        int drawHeight = 168;
        int x = (screenWidth - drawWidth) / 2;
        int y = (screenHeight - drawHeight) / 2;
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        context.method_25290(texture, x, y, 0.0f, 0.0f, drawWidth, drawHeight, drawWidth, drawHeight);
        RenderSystem.disableBlend();
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIFFIIII)V", ordinal=1, shift=At.Shift.AFTER)})
    private void onAfterRenderLogo(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci, @Local(ordinal=2) int scaledWidth, @Local(ordinal=3) int scaledHeight, @Local(ordinal=3) float alpha, @Local(ordinal=4) int x, @Local(ordinal=5) int y, @Local(ordinal=0) double height, @Local(ordinal=6) int halfHeight, @Local(ordinal=1) double width, @Local(ordinal=7) int halfWidth) {
        if (!this.animationDone || HAS_LOADED_ONCE) {
            return;
        }
        float progress = class_3532.method_15363((float)(this.field_17770 * 0.95f + this.field_17767.method_18229() * 0.050000012f), (float)0.0f, (float)1.0f);
        if ((double)progress >= 0.8) {
            this.f = Math.min(alpha, this.f + 0.2f);
            int sw = (int)(width * 0.45);
            SplashOverlayMixin.setShaderColor(TEXT_COLOR.getAsInt(), this.f);
            context.method_25293(class_2960.method_60655((String)"mobpvp", (String)"textures/gui/studios.png"), x - sw / 2, (int)((double)(y - halfHeight) + height - height / 12.0), sw, (int)(height / 5.0), 0.0f, 0.0f, 450, 50, 512, 512);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        int finalFrameScreenWidth = context.method_51421();
        int finalFrameScreenHeight = context.method_51443();
        int finalFrameWidth = finalFrameScreenWidth / 2;
        int finalFrameHeight = finalFrameWidth * 256 / 1024;
        int finalFrameX = (finalFrameScreenWidth - finalFrameWidth) / 2;
        int finalFrameY = (finalFrameScreenHeight - finalFrameHeight) / 2;
        int finalSubFrameY = 256 * (this.count % 8 / 2);
        class_2960 finalFrame = this.frames[11];
        SplashOverlayMixin.setShaderColor(TEXT_COLOR.getAsInt(), alpha);
        context.method_25293(finalFrame, finalFrameX, finalFrameY, finalFrameWidth, finalFrameHeight, 0.0f, (float)finalSubFrameY, 1024, 256, 1024, 1024);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (alpha <= 0.0f) {
            HAS_LOADED_ONCE = true;
        }
    }

    @Unique
    private static void setShaderColor(int color, float alpha) {
        RenderSystem.setShaderColor((float)((float)(SplashOverlayMixin.applyAlphaToColor(color, alpha) >> 16 & 0xFF) / 255.0f), (float)((float)(SplashOverlayMixin.applyAlphaToColor(color, alpha) >> 8 & 0xFF) / 255.0f), (float)((float)(SplashOverlayMixin.applyAlphaToColor(color, alpha) & 0xFF) / 255.0f), (float)((float)(SplashOverlayMixin.applyAlphaToColor(color, alpha) >> 24 & 0xFF) / 255.0f));
    }

    @Unique
    private static int applyAlphaToColor(int color, float alpha) {
        int rgb = color & 0xFFFFFF;
        int a = class_3532.method_15340((int)((int)(alpha * 255.0f)), (int)0, (int)255);
        return a << 24 | rgb;
    }

    static {
        whiteARGB = class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255);
        LOADING_FILL = () -> DarkLoadingScreenCompat.getBarColor(whiteARGB);
        LOADING_BORDER = () -> DarkLoadingScreenCompat.getBorderColor(whiteARGB);
        TEXT_COLOR = () -> SplashOverlayMixin.applyAlphaToColor(DarkLoadingScreenCompat.getLogoColor(whiteARGB), 1.0f);
        loadingBarProgress = 0.0f;
        HAS_LOADED_ONCE = false;
    }
}

