/*
 * Decompiled with CFR 0.152.
 */
package mc.garakrral.entity.block;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import mc.garakrral.block.BlockType;
import mc.garakrral.entity.EntityType;
import mc.garakrral.entity.mob.MadSkeletonEntity;
import mc.garakrral.entity.mob.MadZombieEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1642;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class PvpSpawnerBlockEntity
extends class_2586 {
    private static final int SPAWN_RADIUS = 5;
    private static final int WAVE_SIZE = 5;
    private static final int MAX_WAVES = 3;
    private int waveCount = 0;
    private final Set<UUID> aliveEntities = new HashSet<UUID>();

    public PvpSpawnerBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityType.PVP_SPAWNER, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, PvpSpawnerBlockEntity blockEntity) {
        if (world.field_9236 || !(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        List playersNearby = serverWorld.method_18766(p -> p.method_24515().method_19771((class_2382)pos, 5.0));
        Optional<class_3222> nearest = serverWorld.method_18456().stream().min(Comparator.comparingDouble(p -> p.method_5707(class_243.method_24953((class_2382)pos))));
        if (nearest.isEmpty() || nearest.get().method_5707(class_243.method_24953((class_2382)pos)) > 2304.0) {
            if (blockEntity.waveCount > 0 || !blockEntity.aliveEntities.isEmpty()) {
                blockEntity.waveCount = 0;
                blockEntity.aliveEntities.clear();
                serverWorld.method_8501(pos, BlockType.PVP_SPAWNER.method_9564());
            }
            return;
        }
        blockEntity.aliveEntities.removeIf(uuid -> {
            class_1297 e = serverWorld.method_14190(uuid);
            return e == null || !e.method_5805();
        });
        if (!blockEntity.aliveEntities.isEmpty()) {
            return;
        }
        if (blockEntity.waveCount >= 3) {
            serverWorld.method_8501(pos, BlockType.DAMAGED_PVP_SPAWNER.method_9564());
            return;
        }
        for (int i = 0; i < 5; ++i) {
            Object mob;
            class_2338 spawnPos = pos.method_10069(world.method_8409().method_39332(-2, 2), 1, world.method_8409().method_39332(-2, 2));
            switch (world.method_8409().method_43048(3)) {
                case 0: {
                    Object object = new MadZombieEntity(EntityType.MAD_ZOMBIE, (class_1937)serverWorld);
                    break;
                }
                case 1: {
                    Object object = new MadSkeletonEntity(EntityType.MAD_SKELETON, (class_1937)serverWorld);
                    break;
                }
                default: {
                    Object object = mob = new class_1642(class_1299.field_6051, (class_1937)serverWorld);
                }
            }
            if (mob == null) continue;
            mob.method_60949(class_243.method_24953((class_2382)spawnPos), 0.0f, 0.0f);
            serverWorld.method_8649((class_1297)mob);
            blockEntity.aliveEntities.add(mob.method_5667());
        }
        ++blockEntity.waveCount;
    }
}

