/*
 * Decompiled with CFR 0.152.
 */
package mc.garakrral.event.totem.machine;

import java.util.Map;
import mc.garakrral.block.BlockType;
import mc.garakrral.data.OvenData;
import mc.garakrral.event.totem.machine.recipe.IndustrialOvenRecipes;
import mc.garakrral.scheduler.ServerScheduler;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2561;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_7923;

public class INDUSTRIAL_OVEN {
    private static final OvenData ovenData = (OvenData)AutoConfig.getConfigHolder(OvenData.class).getConfig();

    public static class_1269 onUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
        if (world.method_8608()) {
            return class_1269.field_5811;
        }
        class_2338 clickedPos = hit.method_17777();
        class_2680 state = world.method_8320(clickedPos);
        if (!state.method_27852(BlockType.INDUSTRIAL_OVEN)) {
            return class_1269.field_5811;
        }
        class_2338 ovenKey = clickedPos.method_10062();
        IndustrialOvenRecipes.loadRecipes();
        class_2338 chestPos = clickedPos.method_10093(player.method_5735().method_10153());
        class_2680 chestState = world.method_8320(chestPos);
        if (!chestState.method_27852(class_2246.field_10034)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You need a chest behind the oven!"), true);
            return class_1269.field_5811;
        }
        class_2595 chest = (class_2595)world.method_8321(chestPos);
        if (chest == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Chest not found!"), true);
            return class_1269.field_5811;
        }
        IndustrialOvenRecipes.loadRecipes();
        IndustrialOvenRecipes.RecipeData recipe = IndustrialOvenRecipes.matchRecipe(chest);
        if (recipe == null) {
            INDUSTRIAL_OVEN.spawnParticles((class_3218)world, chestPos, false, 40, 3.0);
            world.method_8396(null, clickedPos, class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
            player.method_7353((class_2561)class_2561.method_43470((String)"No valid recipe found."), true);
            return class_1269.field_5812;
        }
        String recipeFileNameOrId = null;
        for (Map.Entry<String, IndustrialOvenRecipes.RecipeData> entry : IndustrialOvenRecipes.getAllRecipes().entrySet()) {
            if (entry.getValue() != recipe) continue;
            recipeFileNameOrId = entry.getKey();
            break;
        }
        if (recipeFileNameOrId == null) {
            recipeFileNameOrId = "unknown_recipe";
        }
        if (!ovenData.activate(ovenKey.method_23854(), recipeFileNameOrId, recipe.time)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"This oven is already running."), true);
            return class_1269.field_5812;
        }
        AutoConfig.getConfigHolder(OvenData.class).save();
        class_3218 serverWorld = (class_3218)world;
        if (!INDUSTRIAL_OVEN.isStructureValid(serverWorld, clickedPos, chestPos)) {
            ovenData.deactivate(ovenKey.method_23854());
            AutoConfig.getConfigHolder(OvenData.class).save();
            return class_1269.field_5811;
        }
        world.method_8396(null, clickedPos, class_3417.field_17605, class_3419.field_15245, 1.0f, 1.0f);
        int duration = recipe.time;
        for (int i = 0; i < duration; i += 5) {
            int delay = i;
            ServerScheduler.schedule(delay, () -> INDUSTRIAL_OVEN.spawnParticles(serverWorld, clickedPos, true, 20, 5.0));
        }
        try {
            ServerScheduler.schedule(duration, () -> {
                int i;
                boolean hasSpace = false;
                for (int i2 = 0; i2 < chest.method_5439(); ++i2) {
                    if (!chest.method_5438(i2).method_7960()) continue;
                    hasSpace = true;
                    break;
                }
                if (!hasSpace) {
                    INDUSTRIAL_OVEN.spawnParticles(serverWorld, chestPos, false, 40, 3.0);
                    world.method_8396(null, clickedPos, (class_3414)class_3417.field_14624.comp_349(), class_3419.field_15245, 1.0f, 0.8f);
                    player.method_7353((class_2561)class_2561.method_43470((String)"The oven did not run because the chest is full!"), true);
                    ovenData.deactivate(ovenKey.method_23854());
                    AutoConfig.getConfigHolder(OvenData.class).save();
                    return;
                }
                block1: for (IndustrialOvenRecipes.Input input : recipe.inputs) {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)input.item));
                    int remaining = input.count;
                    for (int i3 = 0; i3 < chest.method_5439(); ++i3) {
                        class_1799 stack = chest.method_5438(i3);
                        if (!stack.method_31574(item)) continue;
                        int remove = Math.min(remaining, stack.method_7947());
                        stack.method_7934(remove);
                        if ((remaining -= remove) <= 0) continue block1;
                    }
                }
                class_1799 result = IndustrialOvenRecipes.getOutput(recipe);
                boolean added = false;
                for (i = 0; i < chest.method_5439(); ++i) {
                    int transferable;
                    class_1799 stack = chest.method_5438(i);
                    if (!INDUSTRIAL_OVEN.canCombine(stack, result) || (transferable = Math.min(stack.method_7914() - stack.method_7947(), result.method_7947())) <= 0) continue;
                    stack.method_7933(transferable);
                    result.method_7934(transferable);
                    if (!result.method_7960()) continue;
                    added = true;
                    break;
                }
                if (!added && !result.method_7960()) {
                    for (i = 0; i < chest.method_5439(); ++i) {
                        if (!chest.method_5438(i).method_7960()) continue;
                        chest.method_5447(i, result.method_7972());
                        result.method_7934(result.method_7947());
                        added = true;
                        break;
                    }
                }
                if (!added && !result.method_7960()) {
                    class_1542 drop = new class_1542(world, (double)chestPos.method_10263() + 0.5, (double)chestPos.method_10264() + 1.0, (double)chestPos.method_10260() + 0.5, result);
                    world.method_8649((class_1297)drop);
                    player.method_7353((class_2561)class_2561.method_43470((String)"The chest was full, product dropped on the ground."), true);
                }
                chest.method_5431();
                INDUSTRIAL_OVEN.spawnParticles(serverWorld, clickedPos, false, 50, 6.0);
                world.method_8396(null, clickedPos, class_3417.field_14627, class_3419.field_15245, 1.0f, 1.2f);
                ovenData.deactivate(ovenKey.method_23854());
                AutoConfig.getConfigHolder(OvenData.class).save();
            });
        }
        catch (Exception e) {
            ovenData.deactivate(ovenKey.method_23854());
            AutoConfig.getConfigHolder(OvenData.class).save();
            e.printStackTrace();
        }
        return class_1269.field_5812;
    }

    private static boolean isStructureValid(class_3218 world, class_2338 headPos, class_2338 chestPos) {
        for (class_2350 dir : class_2350.values()) {
            class_2680 checkState;
            class_2338 checkPos = headPos.method_10093(dir);
            if (checkPos.equals((Object)chestPos) || (checkState = world.method_8320(checkPos)).method_27852(BlockType.INDUSTRIAL_OVEN_BLOCK)) continue;
            return false;
        }
        return true;
    }

    private static boolean canCombine(class_1799 a, class_1799 b) {
        return !a.method_7960() && !b.method_7960() && a.method_31574(b.method_7909()) && class_1799.method_7973((class_1799)a, (class_1799)b);
    }

    public static void finishProcess(class_3218 world, class_2338 ovenPos, IndustrialOvenRecipes.RecipeData recipe) {
        for (class_2350 dir : class_2350.values()) {
            int i;
            class_2338 chestPos = ovenPos.method_10093(dir);
            class_2680 state = world.method_8320(chestPos);
            if (!state.method_27852(class_2246.field_10034)) continue;
            class_2595 chest = (class_2595)world.method_8321(chestPos);
            if (chest == null) {
                return;
            }
            boolean hasSpace = false;
            for (int i2 = 0; i2 < chest.method_5439(); ++i2) {
                if (!chest.method_5438(i2).method_7960()) continue;
                hasSpace = true;
                break;
            }
            if (!hasSpace) {
                INDUSTRIAL_OVEN.spawnParticles(world, chestPos, false, 40, 3.0);
                world.method_8396(null, ovenPos, (class_3414)class_3417.field_14624.comp_349(), class_3419.field_15245, 1.0f, 0.8f);
                return;
            }
            block2: for (IndustrialOvenRecipes.Input input : recipe.inputs) {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)input.item));
                int remaining = input.count;
                for (int i3 = 0; i3 < chest.method_5439(); ++i3) {
                    class_1799 stack = chest.method_5438(i3);
                    if (!stack.method_31574(item)) continue;
                    int remove = Math.min(remaining, stack.method_7947());
                    stack.method_7934(remove);
                    if ((remaining -= remove) <= 0) continue block2;
                }
            }
            class_1799 result = IndustrialOvenRecipes.getOutput(recipe);
            boolean added = false;
            for (i = 0; i < chest.method_5439(); ++i) {
                int transferable;
                class_1799 stack = chest.method_5438(i);
                if (!INDUSTRIAL_OVEN.canCombine(stack, result) || (transferable = Math.min(stack.method_7914() - stack.method_7947(), result.method_7947())) <= 0) continue;
                stack.method_7933(transferable);
                result.method_7934(transferable);
                if (!result.method_7960()) continue;
                added = true;
                break;
            }
            if (!added && !result.method_7960()) {
                for (i = 0; i < chest.method_5439(); ++i) {
                    if (!chest.method_5438(i).method_7960()) continue;
                    chest.method_5447(i, result.method_7972());
                    result.method_7934(result.method_7947());
                    added = true;
                    break;
                }
            }
            if (!added && !result.method_7960()) {
                class_1542 drop = new class_1542((class_1937)world, (double)chestPos.method_10263() + 0.5, (double)chestPos.method_10264() + 1.0, (double)chestPos.method_10260() + 0.5, result);
                world.method_8649((class_1297)drop);
            }
            chest.method_5431();
            INDUSTRIAL_OVEN.spawnParticles(world, ovenPos, false, 50, 6.0);
            world.method_8396(null, ovenPos, class_3417.field_14627, class_3419.field_15245, 1.0f, 1.2f);
            return;
        }
    }

    private static void spawnParticles(class_3218 world, class_2338 pos, boolean fire, int count, double spread) {
        class_2400 type = fire ? class_2398.field_11240 : class_2398.field_11251;
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.method_10263() + 0.5 + (Math.random() - 0.5) * spread;
            double y = (double)pos.method_10264() + 0.5 + (Math.random() - 0.5) * spread;
            double z = (double)pos.method_10260() + 0.5 + (Math.random() - 0.5) * spread;
            world.method_14199((class_2394)type, x, y, z, 40, 0.1, 0.1, 0.1, 0.02);
        }
    }
}

