/*
 * Decompiled with CFR 0.152.
 */
package mc.garakrral.gen.structure.generator;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_39;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class RuinedVillageGenerator {
    public void generate(class_5281 world, class_5138 accessor, class_2794 generator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
        int radius = 50;
        this.buildPlaza(world, pivot);
        int houseCount = 18;
        for (int i = 0; i < houseCount; ++i) {
            double angle = Math.PI * 2 / (double)houseCount * (double)i;
            int dist = 25 + random.method_43048(15);
            int dx = (int)(Math.cos(angle) * (double)dist);
            int dz = (int)(Math.sin(angle) * (double)dist);
            class_2338 center = pivot.method_10069(dx, 0, dz);
            int y = world.method_8624(class_2902.class_2903.field_13194, center.method_10263(), center.method_10260());
            center = new class_2338(center.method_10263(), y, center.method_10260());
            if (i % 5 == 0) {
                this.buildBlacksmithRuins(world, center, random);
            } else if (i % 3 == 0) {
                this.buildTwoStoryHouse(world, center, random);
            } else {
                this.buildNormalHouse(world, center, random);
            }
            this.scatterDebrisAroundHouse(world, center, random);
        }
        this.createPaths(world, pivot, houseCount, radius, random);
        this.scatterVillageDebris(world, pivot, radius, random);
        int villagerCount = 2 + random.method_43048(5);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            for (int i = 0; i < villagerCount; ++i) {
                class_2338 p = pivot.method_10069(random.method_43048(radius * 2) - radius, 0, random.method_43048(radius * 2) - radius);
                int y = world.method_8624(class_2902.class_2903.field_13194, p.method_10263(), p.method_10260());
                class_1646 villager = new class_1646(class_1299.field_6077, (class_1937)serverWorld);
                villager.method_5725(new class_2338(p.method_10263(), y, p.method_10260()), 0.0f, 0.0f);
                serverWorld.method_8649((class_1297)villager);
            }
        }
    }

    private void buildPlaza(class_5281 world, class_2338 pivot) {
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                int y = world.method_8624(class_2902.class_2903.field_13194, pivot.method_10263() + x, pivot.method_10260() + z);
                class_2338 pos = new class_2338(pivot.method_10263() + x, y, pivot.method_10260() + z);
                world.method_8652(pos, class_2246.field_10255.method_9564(), 3);
            }
        }
    }

    private void buildNormalHouse(class_5281 world, class_2338 center, class_5819 random) {
        int w = 5;
        int l = 7;
        int h = 3;
        for (int x = -w / 2; x <= w / 2; ++x) {
            for (int z = -l / 2; z <= l / 2; ++z) {
                int y = world.method_8624(class_2902.class_2903.field_13194, center.method_10263() + x, center.method_10260() + z);
                class_2338 floor = new class_2338(center.method_10263() + x, y, center.method_10260() + z);
                world.method_8652(floor, class_2246.field_10445.method_9564(), 3);
                for (int dy = 1; dy <= h; ++dy) {
                    if (x != -w / 2 && x != w / 2 && z != -l / 2 && z != l / 2) continue;
                    class_2338 wall = floor.method_10086(dy);
                    world.method_8652(wall, class_2246.field_10161.method_9564(), 3);
                }
            }
        }
        int roofY = world.method_8624(class_2902.class_2903.field_13194, center.method_10263(), center.method_10260()) + h + 1;
        for (int x = -w / 2; x <= w / 2; ++x) {
            for (int z = -l / 2; z <= l / 2; ++z) {
                class_2338 p = new class_2338(center.method_10263() + x, roofY, center.method_10260() + z);
                world.method_8652(p, class_2246.field_10161.method_9564(), 3);
            }
        }
        if (random.method_43048(100) < 30) {
            class_2338 chestPos = center.method_10069(0, 1, 0);
            world.method_8652(chestPos, class_2246.field_10034.method_9564(), 3);
            class_2586 chestBE = world.method_8321(chestPos);
            if (chestBE instanceof class_2595) {
                class_2595 chest = (class_2595)chestBE;
                chest.method_54867(class_39.field_17009, random.method_43055());
            }
        }
    }

    private void buildTwoStoryHouse(class_5281 world, class_2338 center, class_5819 random) {
        this.buildNormalHouse(world, center, random);
        int h = 3;
        for (int x = -2; x <= 2; ++x) {
            for (int z = -3; z <= 3; ++z) {
                class_2338 floor = center.method_10069(x, h + 1, z);
                world.method_8652(floor, class_2246.field_10161.method_9564(), 3);
            }
        }
        int roofY = world.method_8624(class_2902.class_2903.field_13194, center.method_10263(), center.method_10260()) + h + 2;
        for (int x = -2; x <= 2; ++x) {
            for (int z = -3; z <= 3; ++z) {
                world.method_8652(center.method_10069(x, roofY, z), class_2246.field_10161.method_9564(), 3);
            }
        }
        if (random.method_43048(100) < 50) {
            class_2338 chestPos = center.method_10069(0, 2, 0);
            world.method_8652(chestPos, class_2246.field_10034.method_9564(), 3);
            class_2586 chestBE = world.method_8321(chestPos);
            if (chestBE instanceof class_2595) {
                class_2595 chest = (class_2595)chestBE;
                chest.method_54867(class_39.field_17109, random.method_43055());
            }
        }
    }

    private void buildBlacksmithRuins(class_5281 world, class_2338 center, class_5819 random) {
        int z;
        int x;
        int w = 7;
        int l = 9;
        int h = 3;
        for (x = -w / 2; x <= w / 2; ++x) {
            for (z = -l / 2; z <= l / 2; ++z) {
                int y = world.method_8624(class_2902.class_2903.field_13194, center.method_10263() + x, center.method_10260() + z);
                world.method_8652(new class_2338(center.method_10263() + x, y, center.method_10260() + z), class_2246.field_10445.method_9564(), 3);
            }
        }
        for (x = -w / 2; x <= w / 2; ++x) {
            for (z = -l / 2; z <= l / 2; ++z) {
                if (x != -w / 2 && x != w / 2 && z != -l / 2 && z != l / 2 || random.method_43048(100) >= 70) continue;
                class_2338 p = new class_2338(center.method_10263() + x, world.method_8624(class_2902.class_2903.field_13194, center.method_10263() + x, center.method_10260() + z) + 1, center.method_10260() + z);
                world.method_8652(p, class_2246.field_10445.method_9564(), 3);
            }
        }
        class_2338 chestPos = center.method_10069(0, 1, 0);
        world.method_8652(chestPos, class_2246.field_10034.method_9564(), 3);
        class_2586 chestBE = world.method_8321(chestPos);
        if (chestBE instanceof class_2595) {
            class_2595 chest = (class_2595)chestBE;
            chest.method_54867(class_39.field_434, random.method_43055());
        }
    }

    private void scatterDebrisAroundHouse(class_5281 world, class_2338 center, class_5819 random) {
        for (int i = 0; i < 6; ++i) {
            int rx = center.method_10263() + random.method_43048(6) - 3;
            int rz = center.method_10260() + random.method_43048(6) - 3;
            int y = world.method_8624(class_2902.class_2903.field_13194, rx, rz);
            class_2338 p = new class_2338(rx, y, rz);
            world.method_8652(p, class_2246.field_10445.method_9564(), 3);
        }
    }

    private void createPaths(class_5281 world, class_2338 pivot, int houseCount, int radius, class_5819 random) {
        for (int i = 0; i < houseCount; ++i) {
            double angle = Math.PI * 2 / (double)houseCount * (double)i;
            int dist = 25 + random.method_43048(15);
            int dx = (int)(Math.cos(angle) * (double)dist);
            int dz = (int)(Math.sin(angle) * (double)dist);
            class_2338 houseCenter = pivot.method_10069(dx, 0, dz);
            int steps = Math.max(Math.abs(dx), Math.abs(dz));
            for (int s = 0; s <= steps; ++s) {
                int x = pivot.method_10263() + (int)((double)(dx * s) / (double)steps);
                int z = pivot.method_10260() + (int)((double)(dz * s) / (double)steps);
                int y = world.method_8624(class_2902.class_2903.field_13194, x, z);
                world.method_8652(new class_2338(x, y, z), class_2246.field_10255.method_9564(), 3);
            }
        }
    }

    private void scatterVillageDebris(class_5281 world, class_2338 pivot, int radius, class_5819 random) {
        for (int i = 0; i < radius * 2; ++i) {
            int rx = pivot.method_10263() + random.method_43048(radius * 2) - radius;
            int rz = pivot.method_10260() + random.method_43048(radius * 2) - radius;
            int y = world.method_8624(class_2902.class_2903.field_13194, rx, rz);
            class_2338 p = new class_2338(rx, y, rz);
            if (random.method_43048(100) < 15) {
                world.method_8652(p, class_2246.field_10445.method_9564(), 3);
            } else if (random.method_43048(100) < 10) {
                world.method_8652(p, class_2246.field_9989.method_9564(), 3);
            } else if (random.method_43048(100) < 8) {
                world.method_8652(p, class_2246.field_10161.method_9564(), 3);
            }
            if (random.method_43048(100) >= 20) continue;
            world.method_8652(p.method_10084(), class_2246.field_10214.method_9564(), 3);
        }
    }
}

