/*
 * Decompiled with CFR 0.152.
 */
package mc.garakrral.event.totem.machine.recipe;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2595;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class IndustrialOvenRecipes {
    private static final Gson GSON = new Gson();
    private static final Map<String, RecipeData> RECIPES = new HashMap<String, RecipeData>();

    public static void loadRecipes() {
        RECIPES.clear();
        try {
            String[] recipeFiles;
            ClassLoader loader = IndustrialOvenRecipes.class.getClassLoader();
            String basePath = "data/mobpvp/totem_machine/industrial_oven/";
            for (String file : recipeFiles = new String[]{"iron_to_golden_apple.json", "test.json"}) {
                try (InputStream stream = loader.getResourceAsStream(basePath + file);){
                    if (stream == null) continue;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                        RecipeData recipe = (RecipeData)GSON.fromJson((Reader)reader, RecipeData.class);
                        RECIPES.put(file, recipe);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static RecipeData matchRecipe(class_2595 chest) {
        ArrayList<class_1799> chestItems = new ArrayList<class_1799>();
        for (int i = 0; i < chest.method_5439(); ++i) {
            chestItems.add(chest.method_5438(i));
        }
        for (RecipeData recipe : RECIPES.values()) {
            boolean matches = true;
            for (Input input : recipe.inputs) {
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)input.item));
                int totalCount = 0;
                for (class_1799 stack : chestItems) {
                    if (!stack.method_31574(item)) continue;
                    totalCount += stack.method_7947();
                }
                if (totalCount >= input.count) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return recipe;
        }
        return null;
    }

    public static class_1799 getOutput(RecipeData recipe) {
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)recipe.output.item));
        return new class_1799((class_1935)item, recipe.output.count);
    }

    public static RecipeData getRecipeById(String id) {
        return RECIPES.get(id);
    }

    public static Map<String, RecipeData> getAllRecipes() {
        return RECIPES;
    }

    public static class RecipeData {
        public int time;
        public List<Input> inputs;
        public Output output;
    }

    public static class Input {
        public String item;
        public int count;
    }

    public static class Output {
        public String item;
        public int count;
    }
}

