/*
 * Decompiled with CFR 0.152.
 */
package com.kaplandev.build;

import com.kaplandev.block.BlockType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1613;
import net.minecraft.class_1642;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class ArenaFeature
extends class_3031<class_3111> {
    private static final int ROOM_W = 9;
    private static final int ROOM_H = 7;
    private static final int ROOM_D = 9;
    private static final int HALL_LEN = 5;
    private static final int FLOOR_Y_OFFSET = 0;

    public ArenaFeature() {
        super(class_3111.field_24893);
    }

    public boolean method_13151(class_5821<class_3111> ctx) {
        class_5281 world = ctx.method_33652();
        class_5819 rand = ctx.method_33654();
        class_2338 origin = ctx.method_33655().method_33096(ctx.method_33655().method_10264() + 0);
        class_2350 facing = rand.method_43056() ? class_2350.field_11034 : class_2350.field_11039;
        class_2338 centerMin = origin.method_10069(-4, 0, -4);
        class_3341 centerBox = new class_3341(centerMin.method_10263(), centerMin.method_10264(), centerMin.method_10260(), centerMin.method_10263() + 9 - 1, centerMin.method_10264() + 7 - 1, centerMin.method_10260() + 9 - 1);
        ArrayList<class_2338> trapMarkers = new ArrayList<class_2338>();
        this.buildRoom((class_1936)world, rand, centerBox, true, trapMarkers);
        int dx = facing == class_2350.field_11034 ? -18 : -18;
        class_3341 leftHall = this.translate(centerBox, -9, 0, 0);
        this.carveHall((class_1936)world, rand, leftHall, class_2350.field_11039);
        class_3341 leftRoom = this.translate(centerBox, dx, 0, 0);
        this.buildRoom((class_1936)world, rand, leftRoom, false, trapMarkers);
        int sx = facing == class_2350.field_11034 ? 9 : 9;
        class_3341 rightHall = this.translate(centerBox, sx, 0, 0);
        this.carveHall((class_1936)world, rand, rightHall, class_2350.field_11034);
        class_3341 rightRoom = this.translate(centerBox, 18, 0, 0);
        this.buildRoom((class_1936)world, rand, rightRoom, false, trapMarkers);
        class_3341 backHall = this.translate(centerBox, 0, 0, 9);
        this.carveHall((class_1936)world, rand, backHall, class_2350.field_11035);
        class_3341 backRoom = this.translate(centerBox, 0, 0, 18);
        this.buildRoom((class_1936)world, rand, backRoom, false, trapMarkers);
        this.buildBossPlatform((class_1936)world, rand, centerBox, trapMarkers);
        this.decayPass((class_1936)world, rand, centerBox);
        this.decayPass((class_1936)world, rand, leftRoom);
        this.decayPass((class_1936)world, rand, rightRoom);
        this.decayPass((class_1936)world, rand, backRoom);
        if (world instanceof class_3218) {
            class_3218 sw = (class_3218)world;
            this.spawnMobs(sw, centerBox, rand, class_1299.field_6051, 3);
            this.spawnMobs(sw, leftRoom, rand, class_1299.field_6137, 2);
            this.spawnMobs(sw, rightRoom, rand, class_1299.field_6051, 2);
            this.spawnMobs(sw, backRoom, rand, class_1299.field_6137, 2);
        }
        return true;
    }

    private void buildRoom(class_1936 world, class_5819 rand, class_3341 box, boolean isCenter, List<class_2338> traps) {
        this.fill(world, box, class_2246.field_10124);
        this.forXY(box, (x, z) -> {
            class_2338 p = new class_2338(x, box.method_35416(), z);
            this.setPalette(world, rand, p, true);
        });
        this.forXY(box, (x, z) -> {
            class_2338 p = new class_2338(x, box.method_35419(), z);
            this.setPalette(world, rand, p, false);
        });
        this.forYZ(box, (y, z) -> {
            this.setPalette(world, rand, new class_2338(box.method_35415(), y, z), false);
            this.setPalette(world, rand, new class_2338(box.method_35418(), y, z), false);
        });
        this.forXYVertical(box, (x, y) -> {
            this.setPalette(world, rand, new class_2338(x, y, box.method_35417()), false);
            this.setPalette(world, rand, new class_2338(x, y, box.method_35420()), false);
        });
        this.cornerPillar(world, rand, new class_2338(box.method_35415() + 1, box.method_35416() + 1, box.method_35417() + 1), box.method_35419() - 1);
        this.cornerPillar(world, rand, new class_2338(box.method_35418() - 1, box.method_35416() + 1, box.method_35417() + 1), box.method_35419() - 1);
        this.cornerPillar(world, rand, new class_2338(box.method_35415() + 1, box.method_35416() + 1, box.method_35420() - 1), box.method_35419() - 1);
        this.cornerPillar(world, rand, new class_2338(box.method_35418() - 1, box.method_35416() + 1, box.method_35420() - 1), box.method_35419() - 1);
        this.carveDoor(world, box, class_2350.field_11034);
        this.carveDoor(world, box, class_2350.field_11039);
        this.carveDoor(world, box, class_2350.field_11043);
        this.carveDoor(world, box, class_2350.field_11035);
        this.internalDetails(world, rand, box);
        this.addTrapMarker(world, box, traps, box.method_22874().method_10069(0, 0, -2));
        this.addTrapMarker(world, box, traps, box.method_22874().method_10069(0, 0, 2));
        this.addTrapMarker(world, box, traps, box.method_22874().method_10069(3, 3, 0));
        this.addTrapMarker(world, box, traps, box.method_22874().method_10069(-3, 3, 0));
        if (isCenter) {
            class_2338 c = box.method_22874();
            this.ring(world, c.method_10069(0, 0, 0), 3, this.bState(class_2246.field_10093));
            this.set(world, c, this.bState(class_2246.field_10552));
        }
    }

    private void carveHall(class_1936 world, class_5819 rand, class_3341 hallBox, class_2350 dir) {
        this.fill(world, hallBox, class_2246.field_10124);
        this.forXY(hallBox, (x, z) -> this.setPalette(world, rand, new class_2338(x, hallBox.method_35416(), z), true));
        this.forXY(hallBox, (x, z) -> this.setPalette(world, rand, new class_2338(x, hallBox.method_35419(), z), false));
        this.forYZ(hallBox, (y, z) -> {
            this.setPalette(world, rand, new class_2338(hallBox.method_35415(), y, z), false);
            this.setPalette(world, rand, new class_2338(hallBox.method_35418(), y, z), false);
        });
        this.forXYVertical(hallBox, (x, y) -> {
            this.setPalette(world, rand, new class_2338(x, y, hallBox.method_35417()), false);
            this.setPalette(world, rand, new class_2338(x, y, hallBox.method_35420()), false);
        });
        class_2338 mid = hallBox.method_22874().method_10086(1);
        this.set(world, mid, this.bState(class_2246.field_10552));
    }

    private void buildBossPlatform(class_1936 world, class_5819 rand, class_3341 centerBox, List<class_2338> traps) {
        class_2338 c = centerBox.method_22874();
        int h = centerBox.method_35416();
        for (int i = 0; i < 2; ++i) {
            class_2338 p = c.method_10086(i);
            class_2680 s = switch (i) {
                case 0 -> class_2246.field_28900.method_9564();
                default -> class_2246.field_23876.method_9564();
            };
            this.set(world, p, s);
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0) continue;
                this.set(world, c.method_10086(2).method_10069(dx, 0, dz), class_2246.field_10093.method_9564());
            }
        }
        this.set(world, c.method_10086(3), BlockType.CRUDE_ACIDIC_ORE.method_9564());
        this.addTrapMarker(world, centerBox, traps, c.method_10086(3).method_10069(4, 0, 0));
        this.addTrapMarker(world, centerBox, traps, c.method_10086(3).method_10069(-4, 0, 0));
        this.addTrapMarker(world, centerBox, traps, c.method_10086(3).method_10069(0, 0, 4));
        this.addTrapMarker(world, centerBox, traps, c.method_10086(3).method_10069(0, 0, -4));
        for (class_2350 d : class_2350.class_2353.field_11062) {
            class_2338 stepBase = c.method_10069(d.method_10148() * 2, 0, d.method_10165() * 2);
            this.set(world, stepBase, class_2246.field_10131.method_9564());
            this.set(world, stepBase.method_10069(d.method_10148(), 0, d.method_10165()), (class_2680)class_2246.field_10392.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)d));
        }
    }

    private void internalDetails(class_1936 world, class_5819 rand, class_3341 box) {
        class_2338[] points;
        class_2338 c = box.method_22874();
        int topY = box.method_35416() + 3;
        for (class_2338 p : points = new class_2338[]{c.method_10069(2, 1, 2), c.method_10069(-2, 1, 2), c.method_10069(2, 1, -2), c.method_10069(-2, 1, -2)}) {
            this.set(world, p, class_2246.field_10056.method_9564());
            this.set(world, p.method_10086(1), class_2246.field_10416.method_9564());
            this.set(world, p.method_10086(2), class_2246.field_10552.method_9564());
            this.set(world, new class_2338(p.method_10263(), Math.min(topY, box.method_35419() - 1), p.method_10260()), class_2246.field_10252.method_9564());
        }
    }

    private void decayPass(class_1936 world, class_5819 rand, class_3341 box) {
        int tries = 40;
        for (int i = 0; i < tries; ++i) {
            int x = rand.method_39332(box.method_35415(), box.method_35418());
            int y = rand.method_39332(box.method_35416() + 1, box.method_35419() - 1);
            int z = rand.method_39332(box.method_35417(), box.method_35420());
            class_2338 p = new class_2338(x, y, z);
            if (rand.method_43057() < 0.12f && world.method_8320(p).method_26215() && world.method_8320(p.method_10074()).method_26225()) {
                class_2680 s = rand.method_43056() ? class_2246.field_28680.method_9564() : class_2246.field_10124.method_9564();
                this.set(world, p, s);
            }
            if (!(rand.method_43057() < 0.06f) || !this.isExposedWall(world, p)) continue;
            this.set(world, p, class_2246.field_10597.method_9564());
        }
    }

    private boolean isExposedWall(class_1936 world, class_2338 p) {
        class_2680 s = world.method_8320(p);
        if (!s.method_26215()) {
            return false;
        }
        for (class_2350 d : class_2350.values()) {
            if (!world.method_8320(p.method_10093(d)).method_26225()) continue;
            return true;
        }
        return false;
    }

    private void setPalette(class_1936 world, class_5819 rand, class_2338 p, boolean floor) {
        float r = rand.method_43057();
        class_2680 s = floor ? (r < 0.1f ? class_2246.field_28681.method_9564() : (r < 0.22f ? class_2246.field_9989.method_9564() : (r < 0.34f ? class_2246.field_10445.method_9564() : (r < 0.5f ? class_2246.field_10416.method_9564() : class_2246.field_10056.method_9564())))) : (r < 0.15f ? class_2246.field_10065.method_9564() : (r < 0.3f ? class_2246.field_10416.method_9564() : class_2246.field_10056.method_9564()));
        this.set(world, p, s);
    }

    private void ring(class_1936 world, class_2338 center, int radius, class_2680 state) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                if (dx * dx + dz * dz > radius * radius || dx * dx + dz * dz < (radius - 1) * (radius - 1)) continue;
                this.set(world, center.method_10069(dx, 0, dz), state);
            }
        }
    }

    private void cornerPillar(class_1936 world, class_5819 rand, class_2338 base, int topY) {
        for (int y = base.method_10264(); y <= topY; ++y) {
            class_2680 s = rand.method_43056() ? class_2246.field_10056.method_9564() : class_2246.field_10416.method_9564();
            this.set(world, new class_2338(base.method_10263(), y, base.method_10260()), s);
        }
        this.set(world, new class_2338(base.method_10263(), topY + 1, base.method_10260()), class_2246.field_10252.method_9564());
    }

    private void carveDoor(class_1936 world, class_3341 box, class_2350 dir) {
        int midX = (box.method_35415() + box.method_35418()) / 2;
        int midZ = (box.method_35417() + box.method_35420()) / 2;
        int y0 = box.method_35416() + 1;
        switch (dir) {
            case field_11034: {
                for (int y = y0; y < y0 + 3; ++y) {
                    for (int z = midZ - 1; z <= midZ + 1; ++z) {
                        this.set(world, new class_2338(box.method_35418(), y, z), class_2246.field_10124.method_9564());
                    }
                }
                break;
            }
            case field_11039: {
                for (int y = y0; y < y0 + 3; ++y) {
                    for (int z = midZ - 1; z <= midZ + 1; ++z) {
                        this.set(world, new class_2338(box.method_35415(), y, z), class_2246.field_10124.method_9564());
                    }
                }
                break;
            }
            case field_11035: {
                for (int y = y0; y < y0 + 3; ++y) {
                    for (int x = midX - 1; x <= midX + 1; ++x) {
                        this.set(world, new class_2338(x, y, box.method_35420()), class_2246.field_10124.method_9564());
                    }
                }
                break;
            }
            case field_11043: {
                for (int y = y0; y < y0 + 3; ++y) {
                    for (int x = midX - 1; x <= midX + 1; ++x) {
                        this.set(world, new class_2338(x, y, box.method_35417()), class_2246.field_10124.method_9564());
                    }
                }
                break;
            }
        }
    }

    private void addTrapMarker(class_1936 world, class_3341 scope, List<class_2338> out, class_2338 pos) {
        if (!scope.method_14662((class_2382)pos)) {
            return;
        }
        this.set(world, pos, BlockType.PVP_SPAWNER.method_9564());
        out.add(pos.method_10062());
    }

    private void spawnMobs(class_3218 sw, class_3341 box, class_5819 rand, class_1299<?> type, int count) {
        for (int i = 0; i < count; ++i) {
            class_1642 e;
            int x = rand.method_39332(box.method_35415() + 1, box.method_35418() - 1);
            int z = rand.method_39332(box.method_35417() + 1, box.method_35420() - 1);
            class_2338 p = new class_2338(x, box.method_35416() + 1, z);
            if (type == class_1299.field_6051) {
                e = new class_1642(class_1299.field_6051, (class_1937)sw);
                e.method_5725(p, 0.0f, 0.0f);
                sw.method_8649((class_1297)e);
                continue;
            }
            if (type != class_1299.field_6137) continue;
            e = new class_1613(class_1299.field_6137, (class_1937)sw);
            e.method_5725(p, 0.0f, 0.0f);
            sw.method_8649((class_1297)e);
        }
    }

    private void set(class_1936 world, class_2338 pos, class_2680 state) {
        world.method_8652(pos, state, 18);
    }

    private void fill(class_1936 world, class_3341 box, class_2248 block) {
        class_2680 s = block.method_9564();
        for (int x = box.method_35415(); x <= box.method_35418(); ++x) {
            for (int y = box.method_35416(); y <= box.method_35419(); ++y) {
                for (int z = box.method_35417(); z <= box.method_35420(); ++z) {
                    world.method_8652(new class_2338(x, y, z), s, 18);
                }
            }
        }
    }

    private void forXY(class_3341 box, XY consumer) {
        for (int x = box.method_35415(); x <= box.method_35418(); ++x) {
            for (int z = box.method_35417(); z <= box.method_35420(); ++z) {
                consumer.apply(x, z);
            }
        }
    }

    private void forYZ(class_3341 box, YZ consumer) {
        for (int y = box.method_35416(); y <= box.method_35419(); ++y) {
            for (int z = box.method_35417(); z <= box.method_35420(); ++z) {
                consumer.apply(y, z);
            }
        }
    }

    private void forXYVertical(class_3341 box, XY consumer) {
        for (int x = box.method_35415(); x <= box.method_35418(); ++x) {
            for (int y = box.method_35416(); y <= box.method_35419(); ++y) {
                consumer.apply(x, y);
            }
        }
    }

    private class_3341 translate(class_3341 src, int dx, int dy, int dz) {
        return new class_3341(src.method_35415() + dx, src.method_35416() + dy, src.method_35417() + dz, src.method_35418() + dx, src.method_35419() + dy, src.method_35420() + dz);
    }

    private class_2680 bState(class_2248 b) {
        return b.method_9564();
    }

    @FunctionalInterface
    private static interface XY {
        public void apply(int var1, int var2);
    }

    @FunctionalInterface
    private static interface YZ {
        public void apply(int var1, int var2);
    }
}

