/*
 * Decompiled with CFR 0.152.
 */
package com.kaplandev.mixin.client;

import com.kaplandev.client.config.ConfigManager;
import com.kaplandev.level.player.PlayerLevelData;
import java.util.UUID;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_329.class})
public class InGameHudMixin {
    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1690.field_1842) {
            return;
        }
        ConfigManager config = (ConfigManager)AutoConfig.getConfigHolder(ConfigManager.class).getConfig();
        if (!config.showLevelHud) {
            return;
        }
        UUID uuid = client.field_1724.method_5667();
        int level = PlayerLevelData.getLevel(uuid);
        int xp = PlayerLevelData.getXp(uuid);
        int xpToNext = Math.max(1, PlayerLevelData.getXpToLevelUp(level));
        class_327 textRenderer = client.field_1772;
        String levelText = "Lv " + level;
        String xpText = xp + " / " + xpToNext;
        int hudWidth = Math.max(textRenderer.method_1727(levelText), textRenderer.method_1727(xpText)) + 20;
        int hudHeight = 36;
        int x = client.method_22683().method_4486() - hudWidth - 8;
        int y = 8;
        int bgColor = -1441787884;
        context.method_25294(x, y, x + hudWidth, y + hudHeight, bgColor);
        context.method_25294(x, y, x + hudWidth, y + 1, 0x55000000);
        context.method_25294(x, y + hudHeight - 1, x + hudWidth, y + hudHeight, 0x55000000);
        context.method_25294(x, y, x + 1, y + hudHeight, 0x55000000);
        context.method_25294(x + hudWidth - 1, y, x + hudWidth, y + hudHeight, 0x55000000);
        context.method_25300(textRenderer, levelText, x + hudWidth / 2, y + 4, config.levelColor);
        int barW = hudWidth - 12;
        int barH = 8;
        int barX = x + 6;
        int barY = y + hudHeight - barH - 6;
        context.method_25294(barX, barY, barX + barW, barY + barH, -14671840);
        float progress = (float)xp / (float)xpToNext;
        int filled = (int)((float)barW * progress);
        if (filled > 0) {
            context.method_25296(barX, barY, barX + filled, barY + barH, config.xpColor, -11141121);
        }
        context.method_25300(textRenderer, xpText, x + hudWidth / 2, barY - 10, config.xpColor);
    }
}

