package mc.garakrral.block.crop.api;

import mc.garakrral.item.ItemType;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import com.kaplanlib.api.behavior.BlockBehavior;

import static mc.garakrral.mobpvp.MOD_ID;

public class CropBlockBuilder {
    private final String name;
    private final class_4970.class_2251 settings;
    private BlockBehavior behavior;


    private CropBlockBuilder(String name, class_4970.class_2251 settings) {
        this.name = name;
        this.settings = settings;
    }

    public static CropBlockBuilder createCrop(String name, class_4970.class_2251 settings) {
        return new CropBlockBuilder(name, settings);
    }

    public CropBlockBuilder behavior(BlockBehavior behavior) {
        this.behavior = behavior;
        return this;
    }

    public class_2248 register() {
        class_2248 block = new class_2302(settings) {
            @Override
            protected class_1935 method_9832() {

                return ItemType.RYE_SEED;
            }

            @Override
            protected void method_9565(class_2680 state, class_3218 world, class_2338 pos, class_1799 tool, boolean dropXp) {
                super.method_9565(state, world, pos, tool, dropXp);
                if (behavior != null) {
                    behavior.onStacksDropped(state, world, pos, tool, dropXp);
                }
            }
        };

        class_2960 id = class_2960.method_60655(MOD_ID, name);
        return class_2378.method_10230(class_7923.field_41175, id, block);
    }
}
