package mc.garakrral.build;

import mc.garakrral.block.BlockType;
import net.minecraft.class_1299;
import net.minecraft.class_1613;
import net.minecraft.class_1642;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import java.util.ArrayList;
import java.util.List;

/**
 * 3 odalı + koridorlu epik dungeon.
 * Kurgu:
 *  [Sol Oda]──[Merkez Salon / Sunak]──[Sağ Oda]
 *                 │
 *             [Arka Oda]
 *
 * Tuzak noktaları LOdestone ile işaretlidir (sen yerine kendi düzeneklerini koy).
 */
public class ArenaFeature extends class_3031<class_3111> {

    public ArenaFeature() {
        super(class_3111.field_24893);
    }

    // Oda boyutları
    private static final int ROOM_W = 9;  // x
    private static final int ROOM_H = 7;  // y
    private static final int ROOM_D = 9;  // z

    // Koridor uzunluğu
    private static final int HALL_LEN = 5;
    private static final int FLOOR_Y_OFFSET = 0; // origin Y katı

    @Override
    public boolean method_13151(class_5821<class_3111> ctx) {
        class_1936 world = ctx.method_33652();
        class_5819 rand = ctx.method_33654();
        class_2338 origin = ctx.method_33655().method_33096(ctx.method_33655().method_10264() + FLOOR_Y_OFFSET);


        // Dungeon yönünü rastgele seç (X ekseni boyunca solda/sağda odalar)
        class_2350 facing = rand.method_43056() ? class_2350.field_11034 :  class_2350.field_11039;

        // Merkez salonun sol-üst köşe pozunu hesapla (inşaat kolaylığı için)
        class_2338 centerMin = origin.method_10069(-ROOM_W / 2, 0, -ROOM_D / 2);
        class_3341 centerBox = new class_3341(
                centerMin.method_10263(), centerMin.method_10264(), centerMin.method_10260(),
                centerMin.method_10263() + ROOM_W - 1, centerMin.method_10264() + ROOM_H - 1, centerMin.method_10260() + ROOM_D - 1
        );

        List<class_2338> trapMarkers = new ArrayList<>();

        // 1) Merkez salon
        buildRoom(world, rand, centerBox, true, trapMarkers);

        // 2) Sol oda + koridor
        int dx = (facing == class_2350.field_11034 ? -(ROOM_W / 2 + HALL_LEN + ROOM_W) : -(ROOM_W / 2 + HALL_LEN + ROOM_W));
        class_3341 leftHall = translate(centerBox, -(ROOM_W / 2 + HALL_LEN), 0, 0);
        carveHall(world, rand, leftHall, class_2350.field_11039);
        class_3341 leftRoom = translate(centerBox, dx, 0, 0);
        buildRoom(world, rand, leftRoom, false, trapMarkers);

        // 3) Sağ oda + koridor
        int sx = (facing == class_2350.field_11034 ? (ROOM_W / 2 + HALL_LEN) : (ROOM_W / 2 + HALL_LEN));
        class_3341 rightHall = translate(centerBox, sx, 0, 0);
        carveHall(world, rand, rightHall, class_2350.field_11034);
        class_3341 rightRoom = translate(centerBox, ROOM_W / 2 + HALL_LEN + ROOM_W, 0, 0);
        buildRoom(world, rand, rightRoom, false, trapMarkers);

        // 4) Arka oda (merkez salonun arkasına)
        class_3341 backHall = translate(centerBox, 0, 0, ROOM_D / 2 + HALL_LEN);
        carveHall(world, rand, backHall, class_2350.field_11035);
        class_3341 backRoom = translate(centerBox, 0, 0, ROOM_D / 2 + HALL_LEN + ROOM_D);
        buildRoom(world, rand, backRoom, false, trapMarkers);

        // 5) Merkez sunak + sütunlar + özel cevher
        buildBossPlatform(world, rand, centerBox, trapMarkers);

        // 6) Dekoratif sarmaşık, yosun, tavan çökmesi efektleri
        decayPass(world, rand, centerBox);
        decayPass(world, rand, leftRoom);
        decayPass(world, rand, rightRoom);
        decayPass(world, rand, backRoom);

        // 7) Bazı yaratıklar (spawner yerine güvenli canlı spawn)
        if (world instanceof class_3218 sw) {
            spawnMobs(sw, centerBox, rand, class_1299.field_6051, 3);
            spawnMobs(sw, leftRoom, rand, class_1299.field_6137, 2);
            spawnMobs(sw, rightRoom, rand, class_1299.field_6051, 2);
            spawnMobs(sw, backRoom, rand, class_1299.field_6137, 2);
        }


        return true;
    }

    /* ---------- İnşa Yardımcıları ---------- */

    private void buildRoom(class_1936 world, class_5819 rand, class_3341 box, boolean isCenter, List<class_2338> traps) {
        // Temizle
        fill(world, box, class_2246.field_10124);

        // Zemin + tavan + duvarlar
        // Zemin
        forXY(box, (x, z) -> {
            class_2338 p = new class_2338(x, box.method_35416(), z);
            setPalette(world, rand, p, true);
        });
        // Tavan
        forXY(box, (x, z) -> {
            class_2338 p = new class_2338(x, box.method_35419(), z);
            setPalette(world, rand, p, false);
        });
        // Duvarlar
        forYZ(box, (y, z) -> {
            setPalette(world, rand, new class_2338(box.method_35415(), y, z), false);
            setPalette(world, rand, new class_2338(box.method_35418(), y, z), false);
        });
        forXYVertical(box, (x, y) -> {
            setPalette(world, rand, new class_2338(x, y, box.method_35417()), false);
            setPalette(world, rand, new class_2338(x, y, box.method_35420()), false);
        });

        // Köşe sütunları
        cornerPillar(world, rand, new class_2338(box.method_35415()+1, box.method_35416()+1, box.method_35417()+1), box.method_35419()-1);
        cornerPillar(world, rand, new class_2338(box.method_35418()-1, box.method_35416()+1, box.method_35417()+1), box.method_35419()-1);
        cornerPillar(world, rand, new class_2338(box.method_35415()+1, box.method_35416()+1, box.method_35420()-1), box.method_35419()-1);
        cornerPillar(world, rand, new class_2338(box.method_35418()-1, box.method_35416()+1, box.method_35420()-1), box.method_35419()-1);

        // Kapı boşlukları (merkez yönlere bakan duvarlarda)
        carveDoor(world, box, class_2350.field_11034);
        carveDoor(world, box, class_2350.field_11039);
        carveDoor(world, box, class_2350.field_11043);
        carveDoor(world, box, class_2350.field_11035);

        // Odaiçi sütunlar ve küçük merdivenler
        internalDetails(world, rand, box);

        // Tuzak markerları (LODESTONE)
        // - Zemin basınç plakası/ TNT/ok tuzağı için ideal noktalar
        addTrapMarker(world, box, traps, box.method_22874().method_10069(0, 0, -2));
        addTrapMarker(world, box, traps, box.method_22874().method_10069(0, 0, +2));
        // - Tavan düşürme/ok dispenser tuzağı ankrajı
        addTrapMarker(world, box, traps, box.method_22874().method_10069(+3, +3, 0));
        addTrapMarker(world, box, traps, box.method_22874().method_10069(-3, +3, 0));

        // Merkez salona küçük bir yükseltilmiş platform (estetik)
        if (isCenter) {
            class_2338 c = box.method_22874();
            ring(world, c.method_10069(0, 0, 0), 3, bState(class_2246.field_10093));
            set(world, c, bState(class_2246.field_10552));
        }
    }

    private void carveHall(class_1936 world, class_5819 rand, class_3341 hallBox, class_2350 dir) {
        // Hall: 3 genişlik x 3 yükseklik, solid duvar+tavan zemini
        // Önce hepsini doldur
        fill(world, hallBox, class_2246.field_10124);

        // Zemin / tavan / yan duvarlara palet uygula
        forXY(hallBox, (x, z) -> setPalette(world, rand, new class_2338(x, hallBox.method_35416(), z), true));
        forXY(hallBox, (x, z) -> setPalette(world, rand, new class_2338(x, hallBox.method_35419(), z), false));
        forYZ(hallBox, (y, z) -> {
            setPalette(world, rand, new class_2338(hallBox.method_35415(), y, z), false);
            setPalette(world, rand, new class_2338(hallBox.method_35418(), y, z), false);
        });
        forXYVertical(hallBox, (x, y) -> {
            setPalette(world, rand, new class_2338(x, y, hallBox.method_35417()), false);
            setPalette(world, rand, new class_2338(x, y, hallBox.method_35420()), false);
        });

        // Kemer efekti: tepe ortasına değişik doku
        class_2338 mid = hallBox.method_22874().method_10086(1);
        set(world, mid, bState(class_2246.field_10552));
    }

    private void buildBossPlatform(class_1936 world, class_5819 rand, class_3341 centerBox, List<class_2338> traps) {
        class_2338 c = centerBox.method_22874();
        int h = centerBox.method_35416();

        // Sunak sütunu (5 blok)
        for (int i = 0; i < 2; i++) {
            class_2338 p = c.method_10086(i);
            class_2680 s = switch (i) {
                case 0 -> class_2246.field_28900.method_9564();
                default -> class_2246.field_23876.method_9564();
            };
            set(world, p, s);
        }

        // Üst platform 3x3, ortası özel cevher
        for (int dx = -1; dx <= 1; dx++) {
            for (int dz = -1; dz <= 1; dz++) {
                if (dx == 0 && dz == 0) continue;
                set(world, c.method_10086(2).method_10069(dx, 0, dz), class_2246.field_10093.method_9564());
            }
        }
        // Senin özel cevherin
        set(world, c.method_10086(3), BlockType.CRUDE_ACIDIC_ORE.method_9564());

        // Platform çevresine ok tuzağı ankrajı (marker)
        addTrapMarker(world, centerBox, traps, c.method_10086(3).method_10069(+4, 0, 0));
        addTrapMarker(world, centerBox, traps, c.method_10086(3).method_10069(-4, 0, 0));
        addTrapMarker(world, centerBox, traps, c.method_10086(3).method_10069(0, 0, +4));
        addTrapMarker(world, centerBox, traps, c.method_10086(3).method_10069(0, 0, -4));

        // Merdiven (4 yönden)
        for (class_2350 d : class_2350.class_2353.field_11062) {
            class_2338 stepBase = c.method_10069(d.method_10148() * 2, 0, d.method_10165() * 2);
            set(world, stepBase, class_2246.field_10131.method_9564());
            set(world, stepBase.method_10069(d.method_10148(), 0, d.method_10165()), class_2246.field_10392.method_9564().method_11657(class_2741.field_12481, d));
        }
    }

    private void internalDetails(class_1936 world, class_5819 rand, class_3341 box) {
        // Oda içi 4 adet kısa sütun
        class_2338 c = box.method_22874();
        int topY = box.method_35416() + 3;
        class_2338[] points = new class_2338[]{
                c.method_10069(+2, 1, +2), c.method_10069(-2, 1, +2),
                c.method_10069(+2, 1, -2), c.method_10069(-2, 1, -2)
        };
        for (class_2338 p : points) {
            set(world, p, class_2246.field_10056.method_9564());
            set(world, p.method_10086(1), class_2246.field_10416.method_9564());
            set(world, p.method_10086(2), class_2246.field_10552.method_9564());
            // tavan bağlantısı
            set(world, new class_2338(p.method_10263(), Math.min(topY, box.method_35419()-1), p.method_10260()), class_2246.field_10252.method_9564());
        }
    }

    private void decayPass(class_1936 world, class_5819 rand, class_3341 box) {
        // Yosun, sarmaşık, bazı yerleri kırık gibi görünür yap
        int tries = (ROOM_W * ROOM_D) / 2;
        for (int i = 0; i < tries; i++) {
            int x = rand.method_39332(box.method_35415(), box.method_35418());
            int y = rand.method_39332(box.method_35416()+1, box.method_35419()-1);
            int z = rand.method_39332(box.method_35417(), box.method_35420());
            class_2338 p = new class_2338(x, y, z);

            if (rand.method_43057() < 0.12f && world.method_8320(p).method_26215() && world.method_8320(p.method_10074()).method_26225()) {
                // yer yer moss/fern
                class_2680 s = rand.method_43056() ? class_2246.field_28680.method_9564() : class_2246.field_10124.method_9564();
                set(world, p, s);
            }
            if (rand.method_43057() < 0.06f) {
                // dış duvar yüzeylerine vine
                if (isExposedWall(world, p)) {
                    set(world, p, class_2246.field_10597.method_9564());
                }
            }
        }
    }

    private boolean isExposedWall(class_1936 world, class_2338 p) {
        class_2680 s = world.method_8320(p);
        if (!s.method_26215()) return false;
        for (class_2350 d : class_2350.values()) {
            if (world.method_8320(p.method_10093(d)).method_26225()) return true;
        }
        return false;
    }

    /* ---------- Primitifler ---------- */

    private void setPalette(class_1936 world, class_5819 rand, class_2338 p, boolean floor) {
        float r = rand.method_43057();
        class_2680 s;
        if (floor) {
            if (r < 0.10f) s = class_2246.field_28681.method_9564();
            else if (r < 0.22f) s = class_2246.field_9989.method_9564();
            else if (r < 0.34f) s = class_2246.field_10445.method_9564();
            else if (r < 0.50f) s = class_2246.field_10416.method_9564();
            else s = class_2246.field_10056.method_9564();
        } else {
            if (r < 0.15f) s = class_2246.field_10065.method_9564();
            else if (r < 0.30f) s = class_2246.field_10416.method_9564();
            else s = class_2246.field_10056.method_9564();
        }
        set(world, p, s);
    }

    private void ring(class_1936 world, class_2338 center, int radius, class_2680 state) {
        for (int dx = -radius; dx <= radius; dx++) {
            for (int dz = -radius; dz <= radius; dz++) {
                if (dx * dx + dz * dz <= radius * radius && dx * dx + dz * dz >= (radius - 1) * (radius - 1)) {
                    set(world, center.method_10069(dx, 0, dz), state);
                }
            }
        }
    }

    private void cornerPillar(class_1936 world, class_5819 rand, class_2338 base, int topY) {
        for (int y = base.method_10264(); y <= topY; y++) {
            class_2680 s = rand.method_43056() ? class_2246.field_10056.method_9564() : class_2246.field_10416.method_9564();
            set(world, new class_2338(base.method_10263(), y, base.method_10260()), s);
        }
        set(world, new class_2338(base.method_10263(), topY + 1, base.method_10260()), class_2246.field_10252.method_9564());
    }

    private void carveDoor(class_1936 world, class_3341 box, class_2350 dir) {
        // Duvar ortasında 3x3 boşluk
        int midX = (box.method_35415() + box.method_35418()) / 2;
        int midZ = (box.method_35417() + box.method_35420()) / 2;
        int y0 = box.method_35416() + 1;
        switch (dir) {
            case field_11034 -> {
                for (int y = y0; y < y0 + 3; y++)
                    for (int z = midZ - 1; z <= midZ + 1; z++)
                        set(world, new class_2338(box.method_35418(), y, z), class_2246.field_10124.method_9564());
            }
            case field_11039 -> {
                for (int y = y0; y < y0 + 3; y++)
                    for (int z = midZ - 1; z <= midZ + 1; z++)
                        set(world, new class_2338(box.method_35415(), y, z), class_2246.field_10124.method_9564());
            }
            case field_11035 -> {
                for (int y = y0; y < y0 + 3; y++)
                    for (int x = midX - 1; x <= midX + 1; x++)
                        set(world, new class_2338(x, y, box.method_35420()), class_2246.field_10124.method_9564());
            }
            case field_11043 -> {
                for (int y = y0; y < y0 + 3; y++)
                    for (int x = midX - 1; x <= midX + 1; x++)
                        set(world, new class_2338(x, y, box.method_35417()), class_2246.field_10124.method_9564());
            }
        }
    }

    private void addTrapMarker(class_1936 world, class_3341 scope, List<class_2338> out, class_2338 pos) {
        if (!scope.method_14662(pos)) return;
        set(world, pos, BlockType.PVP_SPAWNER.method_9564()); // MARKER: burayı tuzak merkezi olarak kullan
        out.add(pos.method_10062());
    }

    private void spawnMobs(class_3218 sw, class_3341 box, class_5819 rand, class_1299<?> type, int count) {
        for (int i = 0; i < count; i++) {
            int x = rand.method_39332(box.method_35415() + 1, box.method_35418() - 1);
            int z = rand.method_39332(box.method_35417() + 1, box.method_35420() - 1);
            class_2338 p = new class_2338(x, box.method_35416() + 1, z);
            if (type == class_1299.field_6051) {
                class_1642 e = new class_1642(class_1299.field_6051, sw);
                e.method_5725(p, 0, 0);
                sw.method_8649(e);
            } else if (type == class_1299.field_6137) {
                class_1613 e = new class_1613(class_1299.field_6137, sw);
                e.method_5725(p, 0, 0);
                sw.method_8649(e);
            }
        }
    }

    /* ---------- Düşük seviye yardımcılar ---------- */

    private void set(class_1936 world, class_2338 pos, class_2680 state) {
        world.method_8652(pos, state, class_2248.field_31028 | class_2248.field_31031);
    }

    private void fill(class_1936 world, class_3341 box, class_2248 block) {
        class_2680 s = block.method_9564();
        for (int x = box.method_35415(); x <= box.method_35418(); x++) {
            for (int y = box.method_35416(); y <= box.method_35419(); y++) {
                for (int z = box.method_35417(); z <= box.method_35420(); z++) {
                    world.method_8652(new class_2338(x, y, z), s, class_2248.field_31028 | class_2248.field_31031);
                }
            }
        }
    }

    private void forXY(class_3341 box, XY consumer) {
        for (int x = box.method_35415(); x <= box.method_35418(); x++) {
            for (int z = box.method_35417(); z <= box.method_35420(); z++) {
                consumer.apply(x, z);
            }
        }
    }

    private void forYZ(class_3341 box, YZ consumer) {
        for (int y = box.method_35416(); y <= box.method_35419(); y++) {
            for (int z = box.method_35417(); z <= box.method_35420(); z++) {
                consumer.apply(y, z);
            }
        }
    }

    private void forXYVertical(class_3341 box, XY consumer) {
        for (int x = box.method_35415(); x <= box.method_35418(); x++) {
            for (int y = box.method_35416(); y <= box.method_35419(); y++) {
                consumer.apply(x, y);
            }
        }
    }

    private class_3341 translate(class_3341 src, int dx, int dy, int dz) {
        return new class_3341(
                src.method_35415() + dx, src.method_35416() + dy, src.method_35417() + dz,
                src.method_35418() + dx, src.method_35419() + dy, src.method_35420() + dz
        );
    }

    private class_2680 bState(class_2248 b) {
        return b.method_9564();
    }

    /* ---------- küçük functional arayüzler ---------- */
    @FunctionalInterface private interface XY { void apply(int x, int z); }
    @FunctionalInterface private interface YZ { void apply(int y, int z); }
}
