package mc.garakrral.client;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_3929;
import net.minecraft.class_3966;
import net.minecraft.class_442;
import net.minecraft.class_5616;
import net.minecraft.class_946;
import net.minecraft.class_953;
import mc.garakrral.block.BlockType;
import mc.garakrral.client.config.ConfigManager;
import mc.garakrral.client.gui.BetaNoticeScreen;
import mc.garakrral.client.gui.MobTableScreen;
import mc.garakrral.client.info.dink;
import mc.garakrral.client.renderer.entity.block.MobTableBlockRenderer;
import mc.garakrral.client.renderer.entity.block.PvpSpawnerBlockRenderer;
import mc.garakrral.client.renderer.entity.block.PvpSpawnerMaxBlockRenderer;
import mc.garakrral.client.renderer.entity.block.UpgradedHopperBlockRenderer;
import mc.garakrral.client.renderer.entity.boss.BulwarkRenderer;
import mc.garakrral.client.renderer.entity.mob.CustomZombieRenderer;
import mc.garakrral.client.renderer.entity.mob.GoblinHorseRenderer;
import mc.garakrral.client.renderer.entity.mob.GoblinRenderer;
import mc.garakrral.client.renderer.entity.mob.HunterRenderer;
import mc.garakrral.client.renderer.entity.mob.SuperZombieRenderer;
import mc.garakrral.client.renderer.entity.mobpvp.MiniCopperGolemRenderer;
import mc.garakrral.client.renderer.entity.mobpvp.MiniIronGolemRenderer;
import mc.garakrral.client.renderer.entity.mobpvp.SnotBallRenderer;
import mc.garakrral.client.renderer.entity.boss.TheGreatProtectorGolemRenderer;
import mc.garakrral.client.renderer.entity.model.SnotBallModel;
import mc.garakrral.client.renderer.entity.model.TheGreatProtectorGolemModel;
import mc.garakrral.client.renderer.entity.model.layer.EntityModelLayers;
import mc.garakrral.client.xpjump.XpJumpClient;
import mc.garakrral.entity.EntityType;
import mc.garakrral.handler.type.ScreenHandlerTypes;
import mc.garakrral.level.LevelAssigner;

import com.kaplanlib.api.version.BetaVersions;
import com.kaplanlib.api.version.VersionUtils;

public class mobpvpClient implements ClientModInitializer {
    private String title;
    private String message;

    @Override
    public void onInitializeClient() {
        XpJumpClient.init();
        AutoConfig.register(ConfigManager.class, GsonConfigSerializer::new);
        ConfigManager config = AutoConfig.getConfigHolder(ConfigManager.class).getConfig();


        class_5616.method_32144(EntityType.PVP_SPAWNER, PvpSpawnerBlockRenderer::new);
        class_5616.method_32144(EntityType.PVP_SPAWNER_MAX, PvpSpawnerMaxBlockRenderer::new);
        class_5616.method_32144(EntityType.MOB_TABLE, MobTableBlockRenderer::new);
        class_5616.method_32144(EntityType.UPGREADED_HOPPER, UpgradedHopperBlockRenderer::new);

        BlockRenderLayerMap.INSTANCE.putBlock(BlockType.PVP_SPAWNER, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockType.PVP_SPAWNER_MAX, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BlockType.RYE_CROP, class_1921.method_23581());

        EntityRendererRegistry.register(net.minecraft.class_1299.field_6051, CustomZombieRenderer::new);
        EntityRendererRegistry.register(EntityType.MAD_ZOMBIE, SuperZombieRenderer::new);
        EntityRendererRegistry.register(EntityType.MAD_SKELETON, class_946::new);
        EntityRendererRegistry.register(EntityType.BULWARK, BulwarkRenderer::new);
        EntityRendererRegistry.register(EntityType.MINIGOLEM, MiniIronGolemRenderer::new);
        EntityRendererRegistry.register(EntityType.MINIGOLEM_COPPER, MiniCopperGolemRenderer::new);
        EntityRendererRegistry.register(EntityType.IRON_REINFORCED_COPPER_BALL, class_953::new);
        EntityRendererRegistry.register(EntityType.GOBLIN, GoblinRenderer::new);
        EntityRendererRegistry.register(EntityType.GOBLIN_HORSE, GoblinHorseRenderer::new);
        EntityRendererRegistry.register(EntityType.HUNTER, HunterRenderer::new);
        EntityRendererRegistry.register(EntityType.THE_GREAT_PROTECTOR_GOLEM, TheGreatProtectorGolemRenderer::new);
        EntityRendererRegistry.register(EntityType.SNOT_BALL, SnotBallRenderer::new);

        EntityModelLayerRegistry.registerModelLayer(EntityModelLayers.SNOT_BALL_LAYER, SnotBallModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(EntityModelLayers.GOLEM_LAYER, TheGreatProtectorGolemModel::getTexturedModelData);

        class_3929.method_17542(ScreenHandlerTypes.MOB_TABLE, MobTableScreen::new);

        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (config.showAKOTOriginalMessage && client.field_1755 instanceof class_442 && !config.debugHasShownToast) {
                if (!config.hasOpenedBetaNotice && BetaVersions.IS_BETA) {
                    config.hasOpenedBetaNotice = true;
                    client.method_1507(new BetaNoticeScreen(client.field_1755));
                }
                dink.showToast(title, message);
                if (BetaVersions.IS_BETA) {
                    dink.showToast("Debug", VersionUtils.getBetaVersionNumber());
                }
                config.debugHasShownToast = true;
            }
            if (client == null || client.field_1687 == null) return;
        });

        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null) return;

            if (client.field_1765 instanceof class_3966 ehr && ehr.method_17782() instanceof class_1309 living) {
                if (LevelAssigner.hasLevel(living)) {
                    String newName = LevelAssigner.buildDisplayName(living);
                    String currentName = living.method_16914() ? living.method_5797().getString() : null;

                    if (currentName == null || !currentName.equals(newName)) {
                        living.method_5665(net.minecraft.class_2561.method_30163(newName));
                    }
                    living.method_5880(true);
                }
            } else {
                for (var e : client.field_1687.method_18112()) {
                    if (e instanceof class_1309 le && le.method_16914()) {
                        le.method_5880(false);
                    }
                }
            }
        });
    }
}
