package mc.garakrral.client.renderer.entity.block;

import mc.garakrral.block.BlockType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2669;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_776;
import net.minecraft.class_827;

@Environment(EnvType.CLIENT)
public class CustomPistonRenderer implements class_827<class_2669> {

    private final class_776 manager;

    public CustomPistonRenderer(class_776 manager) {
        this.manager = manager;
    }

    @Override
    public void render(class_2669 piston, float tickDelta, class_4587 matrices,
                       class_4597 vertexConsumers, int light, int overlay) {
        System.out.println("CustomPistonRenderer called for " + piston.method_11016());

        class_1937 world = piston.method_10997();
        if (world == null) return;

        class_2680 state = piston.method_11495();
        if (state.method_26215()) return;

        class_2350 dir = piston.method_11506();
        class_2338 pos = piston.method_11016().method_10093(dir.method_10153());
        class_2338 frontPos = piston.method_11016().method_10093(dir);

        boolean hasHeavyHead = world.method_8320(frontPos).method_27852(BlockType.HEAVY_CRUSHER_HEAD);

        matrices.method_22903();
        matrices.method_46416(
                piston.method_11494(tickDelta),
                piston.method_11511(tickDelta),
                piston.method_11507(tickDelta)
        );

        // Eğer önünde ağır başlık varsa pressed versiyonlarını kullan
        if (hasHeavyHead) {
            renderPressedPiston(world, state, pos, matrices, vertexConsumers, light, overlay);
        } else {
            renderNormalPiston(world, state, pos, matrices, vertexConsumers, light, overlay);
        }

        matrices.method_22909();
    }

    private void renderNormalPiston(class_1937 world, class_2680 state, class_2338 pos,
                                    class_4587 matrices, class_4597 vertexConsumers,
                                    int light, int overlay) {
        class_1921 layer = class_4696.method_29359(state);
        manager.method_3350().method_3374(
                world,
                manager.method_3349(state),
                state,
                pos,
                matrices,
                vertexConsumers.getBuffer(layer),
                false,
                class_5819.method_43047(),
                state.method_26190(pos),
                overlay
        );
    }

    private void renderPressedPiston(class_1937 world, class_2680 state, class_2338 pos,
                                     class_4587 matrices, class_4597 vertexConsumers,
                                     int light, int overlay) {
        // vanilla piston texture’larını çekiyoruz
        class_2960 texBase = class_2960.method_60655("minecraft", "block/piston_");
        class_2960 texPressedBase = class_2960.method_60655("mobpvp", "textures/block/piston/");

        // pressed piston modeli render (vanilla modelle aynı geometriyi kullanıyor)
        class_1921 layer = class_4696.method_29359(state);
        var buffer = vertexConsumers.getBuffer(layer);

        // Modeli çek
        var model = manager.method_3349(state);

        // 🔥 Texture override
        class_310.method_1551().method_1531().method_22813(
                class_2960.method_60655("mobpvp", "textures/block/piston/piston_top_pressed.png")
        );

        // Vanilla render
        manager.method_3350().method_3374(
                world,
                model,
                state,
                pos,
                matrices,
                buffer,
                false,
                class_5819.method_43047(),
                state.method_26190(pos),
                overlay
        );
    }

    @Override
    public int method_33893() {
        return 68;
    }
}
