package mc.garakrral.client.renderer.entity.model;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;
import mc.garakrral.entity.boss.TheGreatProtectorGolemEntity;

@Environment(EnvType.CLIENT)
public class TheGreatProtectorGolemModel extends class_583<TheGreatProtectorGolemEntity> {
    private final class_630 left_leg;
    private final class_630 right_leg;
    private final class_630 right_arm;
    private final class_630 right_arm2;
    private final class_630 left_arm;
    private final class_630 left_arm2;
    private final class_630 body;
    private final class_630 head;

    public TheGreatProtectorGolemModel(class_630 root) {
        this.left_leg = root.method_32086("left_leg");
        this.right_leg = root.method_32086("right_leg");
        this.right_arm = root.method_32086("right_arm");
        this.right_arm2 = root.method_32086("right_arm2");
        this.left_arm = root.method_32086("left_arm");
        this.left_arm2 = root.method_32086("left_arm2");
        this.body = root.method_32086("body");
        this.head = root.method_32086("head");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();

        class_5610 left_leg = modelPartData.method_32117("left_leg", class_5606.method_32108()
                        .method_32101(82, 127).method_32098(-17.0F, -35.0F, 21.0F, 20.0F, 35.0F, 24.0F, new class_5605(0.0F)),
                class_5603.method_32090(-9.0F, 24.0F, -33.0F));

        class_5610 right_leg = modelPartData.method_32117("right_leg", class_5606.method_32108()
                        .method_32101(170, 127).method_32098(-10.0F, -35.0F, 17.0F, 20.0F, 35.0F, 24.0F, new class_5605(0.0F)),
                class_5603.method_32090(16.0F, 24.0F, -29.0F));

        class_5610 right_arm = modelPartData.method_32117("right_arm", class_5606.method_32108()
                        .method_32101(82, 186).method_32098(-12.0F, -23.0F, 9.0F, 19.0F, 42.0F, 22.0F, new class_5605(0.0F))
                        .method_32101(230, 49).method_32098(-9.0F, -27.0F, 13.0F, 13.0F, 2.0F, 14.0F, new class_5605(0.0F))
                        .method_32101(196, 93).method_32098(-11.0F, -25.0F, 11.0F, 17.0F, 2.0F, 18.0F, new class_5605(0.0F)),
                class_5603.method_32090(43.0F, -44.0F, -20.0F));

        class_5610 right_arm2 = modelPartData.method_32117("right_arm2", class_5606.method_32108()
                        .method_32101(0, 174).method_32098(-19.0F, -39.0F, 12.0F, 19.0F, 42.0F, 22.0F, new class_5605(0.0F)),
                class_5603.method_32090(50.0F, 14.0F, -23.0F));

        class_5610 left_arm = modelPartData.method_32117("left_arm", class_5606.method_32108()
                        .method_32101(0, 67).method_32098(-2.0F, -36.0F, 18.0F, 19.0F, 43.0F, 22.0F, new class_5605(0.0F))
                        .method_32101(164, 186).method_32098(-1.0F, -38.0F, 20.0F, 17.0F, 2.0F, 18.0F, new class_5605(0.0F))
                        .method_32101(176, 49).method_32098(1.0F, -40.0F, 22.0F, 13.0F, 2.0F, 14.0F, new class_5605(0.0F)),
                class_5603.method_32090(-48.0F, -32.0F, -29.0F));

        class_5610 left_arm2 = modelPartData.method_32117("left_arm2", class_5606.method_32108()
                        .method_32101(0, 67).method_32098(-11.0F, -28.0F, 15.0F, 19.0F, 42.0F, 22.0F, new class_5605(0.0F)),
                class_5603.method_32090(-39.0F, 3.0F, -26.0F));

        class_5610 body = modelPartData.method_32117("body", class_5606.method_32108()
                        .method_32101(82, 93).method_32098(-17.0F, 5.0F, 24.0F, 35.0F, 12.0F, 22.0F, new class_5605(0.0F))
                        .method_32101(0, 0).method_32098(-31.0F, -35.0F, 22.0F, 62.0F, 41.0F, 26.0F, new class_5605(0.0F))
                        .method_32101(82, 67).method_32098(-27.0F, -39.0F, 24.0F, 54.0F, 4.0F, 22.0F, new class_5605(0.0F)),
                class_5603.method_32090(0.0F, -28.0F, -35.0F));

        class_5610 head = modelPartData.method_32117("head", class_5606.method_32108()
                        .method_32101(176, 0).method_32098(-13.0F, 4.0F, -11.0F, 26.0F, 26.0F, 23.0F, new class_5605(0.0F))
                        .method_32101(164, 206).method_32098(-4.0F, 1.0F, -10.0F, 8.0F, 3.0F, 22.0F, new class_5605(0.0F))
                        .method_32101(164, 231).method_32098(-17.0F, 10.0F, -4.0F, 4.0F, 19.0F, 15.0F, new class_5605(0.0F))
                        .method_32101(224, 206).method_32098(13.0F, 10.0F, -4.0F, 4.0F, 19.0F, 15.0F, new class_5605(0.0F)),
                class_5603.method_32090(0.0F, -78.0F, -25.0F));

        return class_5607.method_32110(modelData, 512, 512);
    }

    @Override
    public void method_2828(class_4587 matrices, class_4588 vertices, int light, int overlay, int color) {
        left_leg.method_22698(matrices, vertices, light, overlay);
        right_leg.method_22698(matrices, vertices, light, overlay);
        right_arm.method_22698(matrices, vertices, light, overlay);
        right_arm2.method_22698(matrices, vertices, light, overlay);
        left_arm.method_22698(matrices, vertices, light, overlay);
        left_arm2.method_22698(matrices, vertices, light, overlay);
        body.method_22698(matrices, vertices, light, overlay);
        head.method_22698(matrices, vertices, light, overlay);
    }

    @Override
    public void setAngles(TheGreatProtectorGolemEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        // Baş (derece -> radyan)
        this.head.field_3675 = (float) (headYaw * (Math.PI / 180.0F));
        this.head.field_3654 = (float) (headPitch * (Math.PI / 180.0F));

        // Animation parametreleri (daha 'ağır' bir yürüyüş için speed < 1)
        float speed = 0.8F;      // animasyon hızı
        float degree = 0.35F;    // genlik (küçültüldü)
        float swing = class_3532.method_15363(limbDistance, 0.0F, 0.9F); // aşırı değerleri kes

        // --- Bacak hedefleri (daha kontrollü, halay hissi yok) ---
        float rightLegTarget = (float) (Math.cos(limbAngle * speed) * degree * swing);
        float leftLegTarget = (float) (Math.cos(limbAngle * speed + Math.PI) * degree * swing);

        // Smooth (lerp) ile geçiş: 0.6F -> nispeten hızlı ama yumuşak uyum
        this.right_leg.field_3654 = class_3532.method_16439(0.6F, this.right_leg.field_3654, rightLegTarget);
        this.left_leg.field_3654 = class_3532.method_16439(0.6F, this.left_leg.field_3654, leftLegTarget);

        // Bacak yaw küçük ve limbAngle'e bağlı (dönme hissini kaldırıcak kadar küçük)
        float legYawTargetR = (float) (Math.sin(limbAngle * speed) * 0.02F * swing);
        float legYawTargetL = (float) (-Math.sin(limbAngle * speed) * 0.02F * swing);
        this.right_leg.field_3675 = class_3532.method_16439(0.6F, this.right_leg.field_3675, legYawTargetR);
        this.left_leg.field_3675 = class_3532.method_16439(0.6F, this.left_leg.field_3675, legYawTargetL);

        // --- Gövde: hafif öne eğilme, dönme çok küçük ---
        float bodyPitchTarget = (float) (Math.cos(limbAngle * speed * 0.5F) * 0.03F * swing);
        float bodyYawTarget = (float) (Math.sin(limbAngle * speed * 0.25F) * 0.01F * swing);
        this.body.field_3654 = class_3532.method_16439(0.5F, this.body.field_3654, bodyPitchTarget);
        this.body.field_3675 = class_3532.method_16439(0.5F, this.body.field_3675, bodyYawTarget);

        // --- Kollar: bacaklarla zıt faz, daha küçük genlik ---
        float armDegree = degree * 0.75F;
        float rightArmTarget = (float) (Math.cos(limbAngle * speed + Math.PI) * armDegree * swing) - 0.12F;
        float leftArmTarget = (float) (Math.cos(limbAngle * speed) * armDegree * swing) - 0.12F;

        // Kolları da yumuşat
        this.right_arm.field_3654 = class_3532.method_16439(0.55F, this.right_arm.field_3654, rightArmTarget);
        this.left_arm.field_3654 = class_3532.method_16439(0.55F, this.left_arm.field_3654, leftArmTarget);

        // Kol roll (çok küçük) -> animationProgress'e bağlı sürekli dönüş yok
        float rightArmRollTarget = (float) (Math.sin(limbAngle * speed) * 0.02F * swing);
        float leftArmRollTarget = (float) (-Math.sin(limbAngle * speed) * 0.02F * swing);
        this.right_arm.field_3674 = class_3532.method_16439(0.6F, this.right_arm.field_3674, rightArmRollTarget);
        this.left_arm.field_3674 = class_3532.method_16439(0.6F, this.left_arm.field_3674, leftArmRollTarget);

        // --- Alt kollar üst kola bağlı takipci (yüksek korelasyon) ---
        float rightArm2Target = this.right_arm.field_3654 * 0.92F + (float) (Math.cos(limbAngle * speed + 0.5F) * 0.02F * swing) - 0.06F;
        float leftArm2Target = this.left_arm.field_3654 * 0.92F + (float) (Math.cos(limbAngle * speed + 0.5F + Math.PI) * 0.02F * swing) - 0.06F;

        this.right_arm2.field_3654 = class_3532.method_16439(0.7F, this.right_arm2.field_3654, rightArm2Target);
        this.left_arm2.field_3654 = class_3532.method_16439(0.7F, this.left_arm2.field_3654, leftArm2Target);

        // Alt kol roll/yaw üst kolun küçük bir kesri olsun
        this.right_arm2.field_3674 = class_3532.method_16439(0.7F, this.right_arm2.field_3674, this.right_arm.field_3674 * 0.6F);
        this.left_arm2.field_3674 = class_3532.method_16439(0.7F, this.left_arm2.field_3674, this.left_arm.field_3674 * 0.6F);

        this.right_arm2.field_3675 = class_3532.method_16439(0.7F, this.right_arm2.field_3675, this.right_arm.field_3675 * 0.55F);
        this.left_arm2.field_3675 = class_3532.method_16439(0.7F, this.left_arm2.field_3675, this.left_arm.field_3675 * 0.55F);

        // --- Hız arttıkça (örneğin sprint tarzı) hafif artış ---
        if (swing > 0.85F) {
            float boost = (swing - 0.85F) * 3.0F;
            this.right_leg.field_3654 += 0.04F * boost;
            this.left_leg.field_3654 += 0.04F * boost;
            this.right_arm.field_3654 += 0.03F * boost;
            this.left_arm.field_3654 += 0.03F * boost;
        }

        // --- Son düzeltmeler: başın ve gövdenin aşırı dönmesini engelle ---
        this.head.field_3675 = class_3532.method_15363(this.head.field_3675, -1.2F, 1.2F);
        this.head.field_3654 = class_3532.method_15363(this.head.field_3654, -0.9F, 0.9F);
        this.body.field_3675 = class_3532.method_15363(this.body.field_3675, -0.25F, 0.25F);
    }
}
