package mc.garakrral.command;

import mc.garakrral.build.ArenaTracker;
import mc.garakrral.command.piece.DashCommandPiece;
import mc.garakrral.data.LevelData;
import com.mojang.brigadier.CommandDispatcher;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;
import java.util.HashSet;
import java.util.Set;

public class CommandManager {

    public static void register(CommandDispatcher<class_2168> dispatcher) {

        var mobpvp = net.minecraft.class_2170.method_9247("mobpvp");

        // /mobpvp LocateArena
        mobpvp.then(net.minecraft.class_2170.method_9247("LocateArena")
                .executes(context -> {
                    class_2338 playerPos = context.getSource().method_44023().method_24515();
                    class_2338 nearest = ArenaTracker.getNearest(playerPos);

                    if (nearest == null) {
                        context.getSource().method_9226(() -> class_2561.method_43470("No arenas have been created yet."), false);
                        return 0;
                    }

                    context.getSource().method_9226(() ->
                            class_2561.method_43470("Nearest arena: " + nearest.method_10263() + " " + nearest.method_10264() + " " + nearest.method_10260()), false);
                    return 1;
                })
        );

        // /mobpvp ClearMobLevelData
        mobpvp.then(net.minecraft.class_2170.method_9247("ClearMobLevelData")
                .requires(source -> true)
                .executes(context -> {
                    MinecraftServer server = context.getSource().method_9211();
                    LevelData data = AutoConfig.getConfigHolder(LevelData.class).getConfig();

                    Set<String> alive = new HashSet<>();

                    server.method_3738().forEach(world ->
                            world.method_27909().forEach(entity ->
                                    alive.add(entity.method_5667().toString()))
                    );

                    int before = data.levels.size();
                    data.levels.keySet().removeIf(uuid -> !alive.contains(uuid));
                    int after = data.levels.size();

                    AutoConfig.getConfigHolder(LevelData.class).save();

                    int removed = before - after;
                    context.getSource().method_9226(() ->
                            class_2561.method_43470("§a" + removed + " dead entity records have been cleared. §7(" + after + " remaining)"), false);
                    return 1;
                })
        );

        // /mobpvp dash
        mobpvp.then(net.minecraft.class_2170.method_9247("dash")
                .executes(DashCommandPiece::run)
        );

        // /mobpvp hi
        mobpvp.then(net.minecraft.class_2170.method_9247("hi")
                .executes(context -> {
                    context.getSource().method_9226(() -> class_2561.method_43470("Hello!"), true);
                    return 1;
                })
        );

        dispatcher.register(mobpvp);
    }
}
