package mc.garakrral.enchantment.effect;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_9699;
import net.minecraft.class_9704;
import net.minecraft.class_9721;

public record MagmatizationEffect(class_9704 amount)
        implements class_9721 {

    public static final MapCodec<MagmatizationEffect> CODEC =
            RecordCodecBuilder.mapCodec(instance ->
                    instance.group(
                            class_9704.field_51690.fieldOf("amount")
                                    .forGetter(MagmatizationEffect::amount)
                    ).apply(instance, MagmatizationEffect::new)
            );

    private static final Map<class_3218, Map<class_2338, Integer>> scheduledReverts = new HashMap<>();


    @Override
    public void method_60220(class_3218 world, int level, class_9699 context, class_1297 target, class_243 pos) {
        if (!(target instanceof class_1309 living)) return;
        if (!living.method_24828()) return;

        class_2338 basePos = class_2338.method_49637(pos.field_1352, pos.field_1351 - 1, pos.field_1350);

        // 4x4 alanı tara
        for (int dx = -2; dx <= 1; dx++) {
            for (int dz = -2; dz <= 1; dz++) {
                class_2338 blockPos = basePos.method_10069(dx, 0, dz);
                class_2680 state = world.method_8320(blockPos);

                if (state.method_27852(class_2246.field_10164)) {
                    world.method_8501(blockPos, class_2246.field_10092.method_9564());
                    scheduledReverts
                            .computeIfAbsent(world, w -> new HashMap<>())
                            .put(blockPos.method_10062(), 100);
                }
            }
        }
    }

    public static void tick(class_3218 world) {
        Map<class_2338, Integer> worldReverts = scheduledReverts.get(world);
        if (worldReverts == null) return;

        Iterator<Map.Entry<class_2338, Integer>> it = worldReverts.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<class_2338, Integer> entry = it.next();
            int remaining = entry.getValue() - 1;

            if (remaining <= 0) {
                class_2338 pos = entry.getKey();
                if (world.method_8320(pos).method_27852(class_2246.field_10092)) {
                    world.method_8501(pos, class_2246.field_10164.method_9564());
                }
                it.remove();
            } else {
                entry.setValue(remaining);
            }
        }
    }


    @Override
    public MapCodec<? extends class_9721> method_60219() {
        return CODEC;
    }

}
