package mc.garakrral.entity;

import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_2378;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_4048;
import net.minecraft.class_7923;
import mc.garakrral.block.BlockType;
import mc.garakrral.entity.block.MobTableBlockEntity;
import mc.garakrral.entity.block.PvpSpawnerBlockEntity;
import mc.garakrral.entity.block.PvpSpawnerMaxBlockEntity;
import mc.garakrral.entity.block.UpgradedHopperBlockEntity;
import mc.garakrral.entity.boss.BulwarkEntity;
import mc.garakrral.entity.item.IronReinforcedCopperBallEntity;
import mc.garakrral.entity.mob.GoblinEntity;
import mc.garakrral.entity.mob.GoblinHorseEntity;
import mc.garakrral.entity.mob.HunterEntity;
import mc.garakrral.entity.mob.MadSkeletonEntity;
import mc.garakrral.entity.mob.MadZombieEntity;
import mc.garakrral.entity.mob.MiniCopperGolemEntity;
import mc.garakrral.entity.passive.SnotBallEntity;
import mc.garakrral.entity.passive.MiniIronGolemEntity;
import mc.garakrral.entity.boss.TheGreatProtectorGolemEntity;

import com.kaplanlib.api.builder.EntityAttributeAndSpawnBuilder;
import com.kaplanlib.api.spawn.SpawnLocation;
import com.kaplanlib.util.path.Paths;

import static com.kaplanlib.util.path.Paths.MAD_SKELETON_KEY;
import static com.kaplanlib.util.path.Paths.MAD_ZOMBIE_KEY;
import static com.kaplanlib.util.path.Paths.MOB_TABLE_KEY;
import static com.kaplanlib.util.path.Paths.PVP_SPAWNER_KEY;
import static com.kaplanlib.util.path.Paths.PVP_SPAWNER_MAX_KEY;
import static com.kaplanlib.util.path.Paths.REINFORCED_COPPER_BALL_KEY;
import static mc.garakrral.entity.EntityType.BULWARK;
import static mc.garakrral.entity.EntityType.GOBLIN;
import static mc.garakrral.entity.EntityType.GOBLIN_HORSE;
import static mc.garakrral.entity.EntityType.HUNTER;
import static mc.garakrral.entity.EntityType.IRON_REINFORCED_COPPER_BALL;
import static mc.garakrral.entity.EntityType.MAD_SKELETON;
import static mc.garakrral.entity.EntityType.MAD_ZOMBIE;
import static mc.garakrral.entity.EntityType.MINIGOLEM;
import static mc.garakrral.entity.EntityType.MINIGOLEM_COPPER;
import static mc.garakrral.entity.EntityType.MOB_TABLE;
import static mc.garakrral.entity.EntityType.PVP_SPAWNER;
import static mc.garakrral.entity.EntityType.PVP_SPAWNER_MAX;
import static mc.garakrral.entity.EntityType.SNOT_BALL;
import static mc.garakrral.entity.EntityType.THE_GREAT_PROTECTOR_GOLEM;
import static mc.garakrral.entity.EntityType.UPGREADED_HOPPER;
import static mc.garakrral.mobpvp.MOD_ID;

public class EntityRegister {


    public static void register() {
        EntityAttributeAndSpawnBuilder.create(BULWARK).attributes(BulwarkEntity.createAttributes()).build();
        EntityAttributeAndSpawnBuilder.create(MINIGOLEM).attributes(MiniIronGolemEntity.createAttributes()).build();
        EntityAttributeAndSpawnBuilder.create(MINIGOLEM_COPPER).attributes(MiniCopperGolemEntity.createAttributes()).build();
        EntityAttributeAndSpawnBuilder.create(HUNTER).attributes(HunterEntity.createHunterAttributes()).build();
        EntityAttributeAndSpawnBuilder.create(SNOT_BALL).attributes(SnotBallEntity.createAttributes()).spawn(BiomeSelectors.all(), class_1311.field_6294, 25, 1, 2, SpawnLocation.ON_GROUND, class_2902.class_2903.field_13203, (type, world, reason, pos, random) -> random.method_43057() < 0.20f).build();
        EntityAttributeAndSpawnBuilder.create(GOBLIN).attributes(GoblinEntity.createGoblinAttributes()).spawn(BiomeSelectors.foundInOverworld(), class_1311.field_6302, 100, 2, 4, SpawnLocation.ON_GROUND, class_2902.class_2903.field_13203, (type, world, reason, pos, random) -> {
            long lunarTime = world.method_30271() % 24000;
            boolean isNight = lunarTime >= 12000 && lunarTime <= 24000;
            return isNight && world.method_22339(pos) < 8 && class_1308.method_20636(type, world, reason, pos, random);
        }).build();
        EntityAttributeAndSpawnBuilder.create(THE_GREAT_PROTECTOR_GOLEM).attributes(TheGreatProtectorGolemEntity.createAttributes()).build();
        EntityAttributeAndSpawnBuilder.create(GOBLIN_HORSE)
                .attributes(GoblinHorseEntity.createGoblinHorseAttributes())
                .spawn(
                        BiomeSelectors.foundInOverworld(),
                        class_1311.field_6302,
                        30, // sık değil, ama var
                        1, 1,
                        SpawnLocation.ON_GROUND,
                        class_2902.class_2903.field_13203,
                        (type, worldAccess, spawnReason, pos, random) -> {
                            if (!(worldAccess instanceof net.minecraft.class_3218 world)) return false;

                            if (world.method_8530()) return false;
                            boolean canSpawn = world.method_22339(pos) < 8 && class_1308.method_20636(type, world, spawnReason, pos, random);
                            if (!canSpawn) return false;

                            if (random.method_43057() < 0.8f) return true;

                            GoblinHorseEntity horse = new GoblinHorseEntity(GOBLIN_HORSE, world);
                            horse.method_5808(pos.method_10263() + 0.5, pos.method_10264(), pos.method_10260() + 0.5, random.method_43057() * 360F, 0);

                            GoblinEntity goblin = new GoblinEntity(GOBLIN, world);
                            goblin.method_5808(pos.method_10263() + 0.5, pos.method_10264(), pos.method_10260() + 0.5, random.method_43057() * 360F, 0);

                            world.method_8649(horse);
                            world.method_8649(goblin);
                            goblin.method_5804(horse);

                            return false; // elle spawn ettik
                        }
                )
                .build();

    }

    static {
        MAD_ZOMBIE = class_2378.method_10230(class_7923.field_41177, class_2960.method_60655(MOD_ID, MAD_ZOMBIE_KEY), FabricEntityTypeBuilder.createMob().entityFactory(MadZombieEntity::new).defaultAttributes(MadZombieEntity::createCustomZombieAttributes).spawnGroup(class_1311.field_6302).dimensions(class_4048.method_18385(0.6f, 1.95f)).build());
        MAD_SKELETON = class_2378.method_10230(class_7923.field_41177, class_2960.method_60655(MOD_ID, MAD_SKELETON_KEY), FabricEntityTypeBuilder.createMob().entityFactory(MadSkeletonEntity::new).defaultAttributes(MadSkeletonEntity::createCustomSkeletonAttributes).spawnGroup(class_1311.field_6302).dimensions(class_4048.method_18385(0.6f, 1.99f)).build());
        BULWARK = class_2378.method_10230(class_7923.field_41177, class_2960.method_60655(MOD_ID, Paths.BULWARK), FabricEntityTypeBuilder.createMob().entityFactory(BulwarkEntity::new).spawnGroup(class_1311.field_6302).dimensions(class_4048.method_18385(2.0f, 5.0f)).trackRangeBlocks(80).build());
        MINIGOLEM = class_2378.method_10230(class_7923.field_41177, class_2960.method_60655(MOD_ID, Paths.MINIGOLEM), FabricEntityTypeBuilder.createMob().entityFactory(MiniIronGolemEntity::new).spawnGroup(class_1311.field_6294).dimensions(class_4048.method_18385(0.8f, 1.0f)).trackRangeBlocks(80).build());
        MINIGOLEM_COPPER = class_2378.method_10230(class_7923.field_41177, class_2960.method_60655(MOD_ID, "mini_copper_golem"), FabricEntityTypeBuilder.createMob().entityFactory(MiniCopperGolemEntity::new).spawnGroup(class_1311.field_6294).dimensions(class_4048.method_18385(0.8f, 1.0f)).trackRangeBlocks(160).build());
        PVP_SPAWNER = class_2378.method_10230(class_7923.field_41181, class_2960.method_60655(MOD_ID, PVP_SPAWNER_KEY), FabricBlockEntityTypeBuilder.create(PvpSpawnerBlockEntity::new, BlockType.PVP_SPAWNER).build());
        PVP_SPAWNER_MAX = class_2378.method_10230(class_7923.field_41181, class_2960.method_60655(MOD_ID, PVP_SPAWNER_MAX_KEY), FabricBlockEntityTypeBuilder.create(PvpSpawnerMaxBlockEntity::new, BlockType.PVP_SPAWNER_MAX).build());
        UPGREADED_HOPPER = class_2378.method_10230(class_7923.field_41181, class_2960.method_60655(MOD_ID, "upgraded_hopper"), FabricBlockEntityTypeBuilder.create(UpgradedHopperBlockEntity::new, BlockType.UPGREADED_HOPPER).build());
        MOB_TABLE = class_2378.method_10230(class_7923.field_41181, class_2960.method_60655(MOD_ID, MOB_TABLE_KEY), FabricBlockEntityTypeBuilder.create(MobTableBlockEntity::new, BlockType.MOB_TABLE).build());
        IRON_REINFORCED_COPPER_BALL = class_2378.method_10226(class_7923.field_41177, MOD_ID, net.minecraft.class_1299.class_1300.<IronReinforcedCopperBallEntity>method_5903(IronReinforcedCopperBallEntity::new, class_1311.field_17715).method_17687(0.25f, 0.25f).method_27299(4).method_27300(10).method_5905(REINFORCED_COPPER_BALL_KEY));
        GOBLIN = class_2378.method_10230(class_7923.field_41177, class_2960.method_60655(MOD_ID, "goblin"), FabricEntityTypeBuilder.createMob().entityFactory(GoblinEntity::new).spawnGroup(class_1311.field_6302).dimensions(class_4048.method_18385(0.6f, 1.95f)).trackRangeBlocks(40).build());
        GOBLIN_HORSE = class_2378.method_10230(class_7923.field_41177, class_2960.method_60655(MOD_ID, "goblin_horse"), FabricEntityTypeBuilder.createMob().entityFactory(GoblinHorseEntity::new).spawnGroup(class_1311.field_6302).dimensions(class_4048.method_18385(1.3964844F, 1.4F)).trackRangeBlocks(20).build());
        HUNTER = class_2378.method_10230(class_7923.field_41177, class_2960.method_60655(MOD_ID, "hunter"), FabricEntityTypeBuilder.createMob().entityFactory(HunterEntity::new).spawnGroup(class_1311.field_6302).dimensions(class_4048.method_18385(0.6F, 1.95F)).trackRangeBlocks(20).build());
        THE_GREAT_PROTECTOR_GOLEM = class_2378.method_10230(class_7923.field_41177, class_2960.method_60655(MOD_ID, "the_great_protector"), FabricEntityTypeBuilder.createMob().entityFactory(TheGreatProtectorGolemEntity::new).spawnGroup(class_1311.field_6303).dimensions(class_4048.method_18385(12F, 12F)).trackRangeBlocks(15).build());
        SNOT_BALL = class_2378.method_10230(class_7923.field_41177, class_2960.method_60655(MOD_ID, "snot_ball"), FabricEntityTypeBuilder.createMob().entityFactory(SnotBallEntity::new).spawnGroup(class_1311.field_6294).dimensions(class_4048.method_18385(1F, 1F)).trackRangeBlocks(25).build());
    }
}