package mc.garakrral.entity.block;

import mc.garakrral.entity.EntityType;
import mc.garakrral.inventory.ImplementedInventory;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

public class MobTableBlockEntity extends class_2586 implements ImplementedInventory {
    private final class_2371<class_1799> items = class_2371.method_10213(1, class_1799.field_8037);
    private int ticksRemaining = 0;

    public MobTableBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityType.MOB_TABLE, pos, state);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return items;
    }

    public void startProcessing() {
        if (ticksRemaining <= 0) {
            ticksRemaining = 20 * 60; // 60 saniye
        }
    }

    public boolean isProcessing() {
        return ticksRemaining > 0;
    }

    public int getTicksRemaining() {
        return ticksRemaining;
    }

    public void tick() {
        if (ticksRemaining > 0) {
            ticksRemaining--;
            method_5431();
        }
    }

    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11014(nbt, lookup);
        class_1262.method_5429(nbt, items, lookup);
        ticksRemaining = nbt.method_10550("TicksRemaining");
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11007(nbt, lookup);
        class_1262.method_5426(nbt, items, lookup);
        nbt.method_10569("TicksRemaining", ticksRemaining);
    }
}
