package mc.garakrral.entity.block;

import mc.garakrral.block.BlockType;
import mc.garakrral.entity.EntityType;
import mc.garakrral.entity.mob.GoblinEntity;
import mc.garakrral.entity.mob.HunterEntity;
import mc.garakrral.entity.mob.MadSkeletonEntity;
import mc.garakrral.entity.mob.MadZombieEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1642;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import java.util.*;

public class PvpSpawnerBlockEntity extends class_2586 {
    private static final int SPAWN_RADIUS = 5;
    private static final int WAVE_SIZE = 5;
    private static final int MAX_WAVES = 3;

    private int waveCount = 0;
    private final Set<UUID> aliveEntities = new HashSet<>();

    public PvpSpawnerBlockEntity(class_2338 pos, class_2680 state) {
        super(EntityType.PVP_SPAWNER, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, PvpSpawnerBlockEntity blockEntity) {
        if (world.field_9236 || !(world instanceof class_3218 serverWorld)) return;

        // Yakındaki oyuncular
        List<class_3222> playersNearby = serverWorld.method_18766(p ->
                p.method_24515().method_19771(pos, SPAWN_RADIUS)
        );

        // Eğer hiç oyuncu yoksa veya herkes çok uzaksa → resetle
        Optional<class_3222> nearest = serverWorld.method_18456().stream()
                .min(Comparator.comparingDouble(p -> p.method_5707(class_243.method_24953(pos))));
        if (nearest.isEmpty() || nearest.get().method_5707(class_243.method_24953(pos)) > 48 * 48) {// 48 bloktan uzak
            if (blockEntity.waveCount > 0 || !blockEntity.aliveEntities.isEmpty()) {
                blockEntity.waveCount = 0;
                blockEntity.aliveEntities.clear();
                serverWorld.method_8501(pos, BlockType.PVP_SPAWNER.method_9564()); // geri eski haline dön
            }
            return;
        }

        // Ölüleri temizle
        blockEntity.aliveEntities.removeIf(uuid -> {
            class_1297 e = serverWorld.method_14190(uuid);
            return e == null || !e.method_5805();
        });

        if (!blockEntity.aliveEntities.isEmpty()) return;

        // Dalga sınırı dolduysa
        if (blockEntity.waveCount >= MAX_WAVES) {
            serverWorld.method_8501(pos, BlockType.DAMAGED_PVP_SPAWNER.method_9564());
            return;
        }

        for (int i = 0; i < WAVE_SIZE; i++) {
            class_2338 spawnPos = pos.method_10069(world.method_8409().method_39332(-2, 2), 1, world.method_8409().method_39332(-2, 2));
            class_1297 mob = switch (world.method_8409().method_43048(5)) {
                case 0 -> new MadZombieEntity(EntityType.MAD_ZOMBIE, serverWorld);
                case 1 -> new MadSkeletonEntity(EntityType.MAD_SKELETON, serverWorld);
                case 2 -> new HunterEntity(EntityType.HUNTER, serverWorld);
                case 3 -> new GoblinEntity(EntityType.GOBLIN, serverWorld);
                default -> new class_1642(net.minecraft.class_1299.field_6051, serverWorld);
            };

            if (mob != null) {
                mob.method_60949(class_243.method_24953(spawnPos), 0, 0);
                serverWorld.method_8649(mob);
                blockEntity.aliveEntities.add(mob.method_5667());
            }
        }

        blockEntity.waveCount++;
    }
}