package mc.garakrral.entity.block;

import static mc.garakrral.entity.EntityType.UPGREADED_HOPPER;

import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class UpgradedHopperBlockEntity extends class_2586 implements class_1263 {
    private final class_2371<class_1799> inventory = class_2371.method_10213(5, class_1799.field_8037);
    private int cooldown = 0;

    // Normal huni 8 tickte bir aktarım yapar, bunu aynı yapıyoruz
    private static final int TRANSFER_COOLDOWN = 8;

    public UpgradedHopperBlockEntity(class_2338 pos, class_2680 state) {
        super(UPGREADED_HOPPER, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, UpgradedHopperBlockEntity hopper) {
        if (world.field_9236) return;

        if (hopper.cooldown > 0) {
            hopper.cooldown--;
            return;
        }

        // Üstteki envanteri al
        class_2338 above = pos.method_10084();
        class_1263 aboveInv = net.minecraft.class_2614.method_11250(world, above);

        // Eğer üstte envanter varsa oradan eşya al
        if (aboveInv != null) {
            for (int i = 0; i < aboveInv.method_5439(); i++) {
                class_1799 stack = aboveInv.method_5438(i);
                if (!stack.method_7960()) {
                    // 1 eşya kopyala
                    class_1799 single = stack.method_7972();
                    single.method_7939(1);

                    // Eşyayı tam ortadan aşağı düşür (sağa sola saçılmadan)
                    double x = pos.method_10263() + 0.5;
                    double y = pos.method_10264() - 0.5; // biraz daha aşağıya
                    double z = pos.method_10260() + 0.5;

                    class_1542 drop = new class_1542(world, x, y, z, single);
                    drop.method_18800(0, -0.1, 0); // sadece aşağıya yavaşça düşsün
                    drop.method_5875(false); // normal yer çekimiyle düşsün
                    drop.method_6982(10); // hemen alınmasın
                    drop.method_36456(0);
                    drop.method_36457(0);

                    // Dümdüz, yönsüz şekilde doğsun
                    world.method_8649(drop);

                    // Üst envanterden 1 eşya eksilt
                    stack.method_7934(1);
                    aboveInv.method_5431();

                    // Cooldown başlat (normal huni gibi)
                    hopper.cooldown = TRANSFER_COOLDOWN;
                    break;
                }
            }
        }
    }

    // INVENTORY
    @Override public int method_5439() { return inventory.size(); }
    @Override public boolean method_5442() { for (class_1799 s : inventory) if (!s.method_7960()) return false; return true; }
    @Override public class_1799 method_5438(int slot) { return inventory.get(slot); }
    @Override public class_1799 method_5434(int slot, int amount) { class_1799 r = class_1262.method_5430(inventory, slot, amount); if (!r.method_7960()) method_5431(); return r; }
    @Override public class_1799 method_5441(int slot) { class_1799 r = class_1262.method_5428(inventory, slot); if (!r.method_7960()) method_5431(); return r; }
    @Override public void method_5447(int slot, class_1799 stack) { inventory.set(slot, stack); if (stack.method_7947() > method_5444()) stack.method_7939(method_5444()); method_5431(); }
    @Override public boolean method_5443(net.minecraft.class_1657 player) { return true; }
    @Override public void method_5448() { inventory.clear(); }
}
