package mc.garakrral.entity.goal;

import mc.garakrral.entity.mob.MiniCopperGolemEntity;
import mc.garakrral.entity.passive.MiniIronGolemEntity;


import mc.garakrral.item.ItemType;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1352;
import net.minecraft.class_1439;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_3417;
import java.util.EnumSet;
import java.util.List;

public class FindIngotAndHealGolemGoal extends class_1352 {

    private final MiniIronGolemEntity miniGolem;
    private class_1542 targetIngotEntity;
    private class_1439 targetGolem;
    private class_2338 targetChest;
    private boolean usingChest = false;
    private float followStartHealth = -1;


    private Phase phase = Phase.SEARCH;

    public enum Phase {
        SEARCH, PICKUP, MOVE_TO_GOLEM, HEAL, FOLLOW
    }

    public FindIngotAndHealGolemGoal(MiniIronGolemEntity golem) {
        this.miniGolem = golem;
        this.method_6265(EnumSet.of(class_4134.field_18405));
    }

    @Override
    public boolean method_6264() {
        return true;
    }


    @Override
    public boolean method_6266() {
        return true;
    }

    @Override
    public void method_6268() {
        switch (phase) {
            case SEARCH -> {
                targetIngotEntity = findNearbyIngot();
                if (targetIngotEntity != null) {
                    usingChest = false;
                    phase = Phase.PICKUP;
                    return;
                }

                targetChest = findChestWithIngot();
                if (targetChest != null) {
                    usingChest = true;
                    phase = Phase.PICKUP;
                    return;
                }

                List<class_1439> golems = miniGolem.method_37908().method_8390(class_1439.class,
                        miniGolem.method_5829().method_1014(10),
                        g -> !(g instanceof MiniIronGolemEntity || g instanceof MiniCopperGolemEntity) && g.method_6032() < g.method_6063());
// En yakını seç, mızıkçılık yapma!
                targetGolem = golems.stream()
                        .min((a, b) -> Double.compare(miniGolem.method_5858(a), miniGolem.method_5858(b)))
                        .orElse(null);


                if (!golems.isEmpty()) {
                    targetGolem = golems.get(0);
                    followStartHealth = -1; // yeni takibi başlat
                    phase = Phase.FOLLOW;
                } else if (targetGolem != null && targetGolem.method_5805()) {
                    // Eskiden izlenen golem hala yaşıyorsa, geri takip et
                    phase = Phase.FOLLOW;
                }

            }

            case FOLLOW -> {
                if (targetGolem != null && targetGolem.method_5805()) {
                    if (followStartHealth < 0) {
                        followStartHealth = targetGolem.method_6032(); // Başlangıç sağlığını kaydet
                    }

                    boolean golemDamaged = targetGolem.method_6032() < followStartHealth;
                    boolean foundIngot = findNearbyIngot() != null || findChestWithIngot() != null;

                    if (golemDamaged && foundIngot) {
                        phase = Phase.SEARCH;
                        return;
                    }

                    if (miniGolem.method_5858(targetGolem) > 4.0) {
                        miniGolem.method_5942().method_6335(targetGolem, 0.35);
                    } else {
                        miniGolem.method_5942().method_6340();
                    }

                } else {
                    fullReset();
                }
            }


            case PICKUP -> {
                List<class_1439> golems = miniGolem.method_37908().method_8390(class_1439.class,
                        miniGolem.method_5829().method_1014(10),
                        g -> !(g instanceof MiniIronGolemEntity) && g.method_6032() < g.method_6063());

                if (golems.isEmpty()) {
                    resetButKeepGolem();
                    return;
                }

                targetGolem = golems.get(0);

                if (usingChest) {
                    miniGolem.method_5942().method_6337(targetChest.method_10263() + 0.5, targetChest.method_10264(), targetChest.method_10260() + 0.5, 0.35);
                    if (miniGolem.method_24515().method_19771(targetChest, 1.5)) {
                        class_2586 be = miniGolem.method_37908().method_8321(targetChest);
                        if (be instanceof class_2595 chest) {
                            class_1263 inv = chest;
                            for (int i = 0; i < inv.method_5439(); i++) {
                                class_1799 stack = inv.method_5438(i);
                                if (stack.method_31574(ItemType.REINFORCED_COPPER_INGOT) || stack.method_31574(class_1802.field_8620)) {
                                    class_1792 selected = stack.method_7909();
                                    stack.method_7934(1);
                                    inv.method_5447(i, stack.method_7960() ? class_1799.field_8037 : stack);
                                    miniGolem.method_6122(class_1268.field_5808, new class_1799(selected));
                                    phase = Phase.MOVE_TO_GOLEM;
                                    break;
                                }

                            }
                        }
                    }
                } else {
                    if (targetIngotEntity != null && targetIngotEntity.method_5805()) {
                        miniGolem.method_5942().method_6335(targetIngotEntity, 0.35);
                        if (miniGolem.method_5858(targetIngotEntity) < 1) {
                            class_1799 stack = targetIngotEntity.method_6983();
                            class_1792 selected = stack.method_7909();
                            if (!stack.method_7960() && (selected == class_1802.field_8620 || selected == ItemType.REINFORCED_COPPER_INGOT)) {
                                if (stack.method_7947() > 1) {
                                    stack.method_7934(1);
                                    targetIngotEntity.method_6979(stack);
                                } else {
                                    targetIngotEntity.method_31472();
                                }
                                miniGolem.method_6122(class_1268.field_5808, new class_1799(selected));
                                phase = Phase.MOVE_TO_GOLEM;
                            }
                            else {
                                // Demir alınmış ya da değişmiş, yeniden ara
                                resetButKeepGolem(); // Golemi unutma, tekrar dene

                            }
                        }
                    } else {
                        fullReset(); // Entity yok olmuş, direkt resetle
                    }
                }
            }

            case MOVE_TO_GOLEM -> {
                if (targetGolem != null && targetGolem.method_5805()) {
                    miniGolem.method_5942().method_6335(targetGolem, 0.35);
                    if (miniGolem.method_5858(targetGolem) < 2.5) {
                        phase = Phase.HEAL;
                    }
                } else {
                    miniGolem.method_6122(class_1268.field_5808, class_1799.field_8037);
                    fullReset();
                }
            }

            case HEAL -> {
                if (targetGolem != null && targetGolem.method_5805()) {
                    // Golemin canı tam değilse iyileştir
                    if (targetGolem.method_6032() < targetGolem.method_6063()) {
                        class_1799 handStack = miniGolem.method_5998(class_1268.field_5808);
                        if (handStack.method_31574(ItemType.REINFORCED_COPPER_INGOT)) {
                            targetGolem.method_6025(16.0F); // 2 kat
                        } else {
                            targetGolem.method_6025(8.0F); // normal
                        }
                        miniGolem.method_6122(class_1268.field_5808, class_1799.field_8037);

                        miniGolem.method_6122(class_1268.field_5808, class_1799.field_8037);
                        miniGolem.method_5783(class_3417.field_21077, 0.4F, 1.1F);

                        // Eğer hala canı tam değilse, tekrar külçe aramaya gönder
                        if (targetGolem.method_6032() < targetGolem.method_6063()) {
                            phase = Phase.SEARCH;
                            return;
                        }
                    }
                    // Canı tam ise takip et
                    phase = Phase.FOLLOW;
                    followStartHealth = targetGolem.method_6032();
                } else {
                    fullReset(); // Golem ölmüşse sıfırla
                }
            }

        }
    }

    private class_1542 findNearbyIngot() {
        List<class_1542> items = miniGolem.method_37908().method_8390(class_1542.class,
                miniGolem.method_5829().method_1014(8),
                e -> {
                    class_1792 i = e.method_6983().method_7909();
                    return i == ItemType.REINFORCED_COPPER_INGOT || i == class_1802.field_8620;
                });

        // Öncelik: Reinforced
        return items.stream()
                .filter(e -> e.method_6983().method_31574(ItemType.REINFORCED_COPPER_INGOT))
                .findFirst()
                .orElse(items.isEmpty() ? null : items.get(0));
    }


    private class_2338 findChestWithIngot() {
        class_2338 origin = miniGolem.method_24515();
        class_2338.class_2339 check = new class_2338.class_2339();

        for (int x = -8; x <= 8; x++) {
            for (int y = -2; y <= 2; y++) {
                for (int z = -8; z <= 8; z++) {
                    check.method_10103(origin.method_10263() + x, origin.method_10264() + y, origin.method_10260() + z);
                    if (miniGolem.method_37908().method_8320(check).method_27852(class_2246.field_10380)) {
                        class_2586 be = miniGolem.method_37908().method_8321(check);
                        if (be instanceof class_2595 chest) {
                            for (int i = 0; i < chest.method_5439(); i++) {
                                class_1799 stack = chest.method_5438(i);
                                if (stack.method_31574(ItemType.REINFORCED_COPPER_INGOT) || stack.method_31574(class_1802.field_8620)) {
                                    return check.method_10062();
                                }
                            }
                        }
                    }
                }
            }
        }

        return null;
    }


    private void fullReset() {
        targetIngotEntity = null;
        targetGolem = null;
        targetChest = null;
        usingChest = false;
        phase = Phase.SEARCH;
        followStartHealth = -1;
    }

    private void resetButKeepGolem() {
        targetIngotEntity = null;
        targetChest = null;
        usingChest = false;
        phase = Phase.SEARCH;
        // targetGolem aynı kalıyor
    }

}
