package mc.garakrral.entity.goal;

import mc.garakrral.entity.boss.BulwarkEntity;
import mc.garakrral.entity.mob.MiniCopperGolemEntity;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1439;
import net.minecraft.class_1569;
import java.util.EnumSet;
import java.util.List;

public class FollowAndProtectGolemGoal extends class_1352 {

    private final MiniCopperGolemEntity miniGolem;
    private class_1439 targetGolem; // Asla unutmayacağı golem

    public FollowAndProtectGolemGoal(MiniCopperGolemEntity golem) {
        this.miniGolem = golem;
        this.method_6265(EnumSet.of(class_4134.field_18405, class_4134.field_18408));
    }

    @Override
    public boolean method_6264() {
        if (targetGolem == null || !targetGolem.method_5805()) {
            List<class_1439> golems = miniGolem.method_37908().method_8390(
                    class_1439.class,
                    miniGolem.method_5829().method_1014(2), // sadece 2 blok yakınındakiler
                    g -> !(g instanceof MiniCopperGolemEntity)
            );

            if (!golems.isEmpty()) {
                targetGolem = golems.get(0); // ilk bulduğu golemi seç
            }
        }
        return targetGolem != null && targetGolem.method_5805();
    }

    @Override
    public boolean method_6266() {
        return targetGolem != null && targetGolem.method_5805();
    }

    @Override
    public void method_6268() {

        List<class_1309> enemies = miniGolem.method_37908().method_8390(
                class_1309.class,
                miniGolem.method_5829().method_1014(8), // 8 blok içinde bak
                e -> (e instanceof class_1569 || e instanceof BulwarkEntity) && e.method_5805()
        );

        if (!enemies.isEmpty()) {
            class_1309 enemy = enemies.get(0);
            miniGolem.method_5980(enemy);
            // Saldırmayı MeleeAttackGoal halleder
            return;
        }

        // Düşman yoksa goleme odaklan
        miniGolem.method_5980(null);

        double distSq = miniGolem.method_5858(targetGolem);

        // Eğer çok uzaktaysa (3 bloktan fazla) → yaklaş
        if (distSq > 9.0D) { // 3 blok
            miniGolem.method_5942().method_6335(targetGolem, 1.0D);
        }
        // Eğer yeterince yakınsa (1.5 bloktan az) → dur
        else if (distSq < 2.25D) { // 1.5 blok
            miniGolem.method_5942().method_6340();
        }
        // Arada ise → dokunma (olduğu yerde kalır, çakışma yapmaz)
    }

}
