package mc.garakrral.entity.goal;

import mc.garakrral.entity.boss.TheGreatProtectorGolemEntity;
import net.minecraft.class_1299;
import net.minecraft.class_1352;
import net.minecraft.class_1439;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class GolemDivisionGoal extends class_1352 {
    private final TheGreatProtectorGolemEntity golem;
    private boolean hasSpawned = false;

    public GolemDivisionGoal(TheGreatProtectorGolemEntity golem) {
        this.golem = golem;
    }

    @Override
    public boolean method_6264() {
        if (golem.method_37908().method_8608()) return false;
        double health = golem.method_6032();
        return health <= 40.0D && !hasSpawned; // 20 kalp altı
    }

    @Override
    public void method_6269() {
        if (!(golem.method_37908() instanceof class_3218 serverWorld)) return;

        // 20 kalp altına düştüğünde 2 golem doğur
        spawnIronGolems(serverWorld);
        hasSpawned = true;

        // Ölümde de aynı şeyi yap
        golem.setOnDeath(() -> spawnIronGolems(serverWorld));
    }

    private void spawnIronGolems(class_3218 serverWorld) {
        class_2338 pos = golem.method_24515();

        class_1439 golem1 = class_1299.field_6147.method_5883(serverWorld);
        class_1439 golem2 = class_1299.field_6147.method_5883(serverWorld);

        if (golem1 != null && golem2 != null) {
            golem1.method_5725(pos.method_10069(2, 0, 0), golem.method_36454(), 0.0F);
            golem2.method_5725(pos.method_10069(-2, 0, 0), golem.method_36454(), 0.0F);

            golem1.method_6499(false);
            golem2.method_6499(false);

            serverWorld.method_8649(golem1);
            serverWorld.method_8649(golem2);
        }
    }

    @Override
    public boolean method_6266() {
        return false;
    }

    @Override
    public void method_6268() {
        // Eğer canı yeniden fullenirse tekrar çağırma sıfırlansın
        if (golem.method_6032() >= golem.method_6063()) {
            hasSpawned = false;
        }
    }
}
